/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.item.scanner;

import cofh.api.energy.IEnergyHandler;
import com.rwtema.extrautils.XUHelper;
import com.rwtema.extrautils.item.scanner.IScanner;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class ScannerRegistry {
    public static List<IScanner> scanners = new ArrayList<IScanner>();
    private static boolean isSorted = false;

    public static void addScanner(IScanner scan) {
        scanners.add(scan);
        isSorted = false;
    }

    public static void sort() {
        Collections.sort(scanners, new SortScanners());
        isSorted = true;
    }

    public static List<String> getData(Object obj, ForgeDirection side, EntityPlayer player) {
        ArrayList<String> data = new ArrayList<String>();
        if (!isSorted) {
            ScannerRegistry.sort();
        }
        for (IScanner scan : scanners) {
            if (!scan.getTargetClass().isAssignableFrom(obj.getClass())) continue;
            scan.addData(obj, data, side, player);
        }
        return data;
    }

    static {
        ScannerRegistry.addScanner(new scanTE());
        ScannerRegistry.addScanner(new scanEntity());
        ScannerRegistry.addScanner(new scanInv());
        ScannerRegistry.addScanner(new scanSidedInv());
        ScannerRegistry.addScanner(new scanTank());
        ScannerRegistry.addScanner(new scanTE3Power());
    }

    public static class scanShears
    implements IScanner {
        @Override
        public Class getTargetClass() {
            return IShearable.class;
        }

        @Override
        public void addData(Object target, List<String> data, ForgeDirection side, EntityPlayer player) {
            IShearable a = (IShearable)target;
            data.add("- Shearable");
        }

        @Override
        public int getPriority() {
            return 0;
        }
    }

    public static class scanTE3Power
    implements IScanner {
        @Override
        public Class getTargetClass() {
            return IEnergyHandler.class;
        }

        @Override
        public void addData(Object tile, List<String> data, ForgeDirection side, EntityPlayer player) {
            IEnergyHandler a = (IEnergyHandler)tile;
            data.add(" TE3 Side Energy: " + a.getEnergyStored(side) + " / " + a.getMaxEnergyStored(side));
        }

        @Override
        public int getPriority() {
            return 0;
        }
    }

    public static class scanTank
    implements IScanner {
        @Override
        public Class getTargetClass() {
            return IFluidHandler.class;
        }

        @Override
        public void addData(Object tile, List<String> data, ForgeDirection side, EntityPlayer player) {
            FluidTankInfo[] tanks = ((IFluidHandler)tile).getTankInfo(side);
            if (tanks != null) {
                if (tanks.length == 1) {
                    if (tanks[0].fluid != null && tanks[0].fluid.amount > 0) {
                        data.add("Fluid Tank: " + tanks[0].fluid.getFluid().getLocalizedName(tanks[0].fluid) + " - " + tanks[0].fluid.amount + " / " + tanks[0].capacity);
                    } else {
                        data.add("Fluid Tank: Empty - 0 / " + tanks[0].capacity);
                    }
                } else {
                    for (int i = 0; i < tanks.length; ++i) {
                        if (tanks[i].fluid != null && tanks[i].fluid.amount > 0) {
                            data.add("Fluid Tank " + i + ": " + tanks[i].fluid.getFluid().getLocalizedName(tanks[i].fluid) + " - " + tanks[i].fluid.amount + " / " + tanks[i].capacity);
                            continue;
                        }
                        data.add("Fluid Tank " + i + ": Empty - 0 / " + tanks[i].capacity);
                    }
                }
            }
        }

        @Override
        public int getPriority() {
            return -98;
        }
    }

    public static class scanSidedInv
    implements IScanner {
        @Override
        public Class getTargetClass() {
            return ISidedInventory.class;
        }

        @Override
        public void addData(Object tile, List<String> data, ForgeDirection side, EntityPlayer player) {
            int[] slots = ((ISidedInventory)tile).func_94128_d(side.ordinal());
            int k = 0;
            if (slots.length > 0) {
                for (int i = 0; i < slots.length; ++i) {
                    if (((ISidedInventory)tile).func_70301_a(i) == null) continue;
                    ++k;
                }
                data.add("Inventory Side Slots: " + k + " / " + slots.length);
            }
        }

        @Override
        public int getPriority() {
            return -99;
        }
    }

    public static class scanInv
    implements IScanner {
        @Override
        public Class getTargetClass() {
            return IInventory.class;
        }

        @Override
        public void addData(Object tile, List<String> data, ForgeDirection side, EntityPlayer player) {
            int n = ((IInventory)tile).func_70302_i_();
            if (n > 0) {
                int k = 0;
                for (int i = 0; i < n; ++i) {
                    if (((IInventory)tile).func_70301_a(i) == null) continue;
                    ++k;
                }
                data.add("Inventory Slots: " + k + " / " + n);
            }
        }

        @Override
        public int getPriority() {
            return -100;
        }
    }

    public static class scanEntityLiv
    implements IScanner {
        @Override
        public Class getTargetClass() {
            return EntityLivingBase.class;
        }

        @Override
        public void addData(Object target, List<String> data, ForgeDirection side, EntityPlayer player) {
            EntityLivingBase e = (EntityLivingBase)target;
            data.add(e.func_110143_aJ() + " / " + e.func_110138_aP());
        }

        @Override
        public int getPriority() {
            return -110;
        }
    }

    public static class scanEntity
    implements IScanner {
        @Override
        public Class getTargetClass() {
            return Entity.class;
        }

        @Override
        public void addData(Object tile, List<String> data, ForgeDirection side, EntityPlayer player) {
            NBTTagCompound tags = new NBTTagCompound();
            if (((Entity)tile).func_70039_c(tags)) {
                data.add("~~ " + tags.func_74779_i("id") + " ~~");
                data.add("Entity Data: " + tags.toString().length());
            }
        }

        @Override
        public int getPriority() {
            return Integer.MIN_VALUE;
        }
    }

    public static class scanTE
    implements IScanner {
        @Override
        public Class getTargetClass() {
            return TileEntity.class;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addData(Object tile, List<String> data, ForgeDirection side, EntityPlayer player) {
            NBTTagCompound tags = new NBTTagCompound();
            ((TileEntity)tile).func_145841_b(tags);
            data.add("~~ " + tags.func_74779_i("id") + " ~~");
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
            DataOutputStream dataoutputstream = new DataOutputStream(bytearrayoutputstream);
            try {
                try {
                    CompressedStreamTools.func_74800_a((NBTTagCompound)tags, (DataOutput)dataoutputstream);
                    data.add("Tile Data: " + bytearrayoutputstream.size());
                }
                finally {
                    dataoutputstream.close();
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
            if (player.field_71075_bZ.field_75098_d) {
                data.addAll(this.getString(tags));
            }
        }

        public List<String> getString(NBTTagCompound tag) {
            ArrayList<String> v = new ArrayList<String>();
            this.appendStrings(v, (NBTBase)tag, "", "Tags");
            return v;
        }

        public void appendStrings(List<String> strings, NBTBase nbt, String prefix, String name) {
            if (nbt.func_74732_a() == XUHelper.NBTIds.NBT.id) {
                NBTTagCompound tag = (NBTTagCompound)nbt;
                if (tag.func_150296_c().isEmpty()) {
                    strings.add(prefix + name + " = NBT{}");
                } else {
                    strings.add(prefix + name + " = NBT{");
                    ArrayList l = new ArrayList();
                    l.addAll(tag.func_150296_c());
                    Collections.sort(l);
                    for (String key : l) {
                        this.appendStrings(strings, tag.func_74781_a(key), prefix + "   ", key);
                    }
                    strings.add(prefix + "}");
                }
            } else if (nbt.func_74732_a() == XUHelper.NBTIds.List.id) {
                NBTTagList tag = (NBTTagList)nbt;
                if (tag.func_74745_c() == 0) {
                    strings.add(prefix + name + " = List{}");
                } else {
                    strings.add(prefix + name + " = List{");
                    for (int i = 0; i < tag.func_74745_c(); ++i) {
                        this.appendStrings(strings, (NBTBase)tag.func_150305_b(i), prefix + "   ", i + "");
                    }
                    strings.add(prefix + "}");
                }
            } else {
                strings.add(prefix + name + " = " + nbt.toString());
            }
        }

        @Override
        public int getPriority() {
            return -2147483647;
        }
    }

    public static class SortScanners
    implements Comparator<IScanner> {
        @Override
        public int compare(IScanner arg0, IScanner arg1) {
            int b;
            int a = arg0.getPriority();
            if (a == (b = arg1.getPriority())) {
                return 0;
            }
            if (a < b) {
                return -1;
            }
            return 1;
        }
    }
}

