/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.dynamicgui;

import com.rwtema.extrautils.dynamicgui.DynamicGui;
import com.rwtema.extrautils.dynamicgui.IWidget;
import com.rwtema.extrautils.dynamicgui.WidgetText;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import org.lwjgl.opengl.GL11;

public abstract class WidgetTextData
extends WidgetText
implements IWidget {
    public Object[] curData = null;

    public WidgetTextData(int x, int y, int align, int color) {
        super(x, y, align, color, null);
    }

    public WidgetTextData(int x, int y, int w, int h, int align, int color) {
        super(x, y, w, h, align, color, null);
    }

    public WidgetTextData(int x, int y, int w) {
        super(x, y, null, w);
    }

    public static Object getNBTBaseData(NBTBase nbt) {
        if (nbt == null) {
            return null;
        }
        switch (nbt.func_74732_a()) {
            case 1: {
                return ((NBTTagByte)nbt).func_150290_f();
            }
            case 2: {
                return ((NBTTagShort)nbt).func_150289_e();
            }
            case 3: {
                return ((NBTTagInt)nbt).func_150287_d();
            }
            case 4: {
                return ((NBTTagLong)nbt).func_150291_c();
            }
            case 5: {
                return Float.valueOf(((NBTTagFloat)nbt).func_150288_h());
            }
            case 6: {
                return ((NBTTagDouble)nbt).func_150286_g();
            }
            case 8: {
                return ((NBTTagString)nbt).func_150285_a_();
            }
            case 10: {
                return nbt;
            }
        }
        return null;
    }

    public static NBTBase getNBTBase(Object o) {
        if (o instanceof Integer) {
            return new NBTTagInt(((Integer)o).intValue());
        }
        if (o instanceof Short) {
            return new NBTTagShort(((Short)o).shortValue());
        }
        if (o instanceof Long) {
            return new NBTTagLong(((Long)o).longValue());
        }
        if (o instanceof String) {
            return new NBTTagString((String)o);
        }
        if (o instanceof Double) {
            return new NBTTagDouble(((Double)o).doubleValue());
        }
        if (o instanceof Float) {
            return new NBTTagFloat(((Float)o).floatValue());
        }
        if (o instanceof NBTTagCompound) {
            return (NBTTagCompound)o;
        }
        throw new RuntimeException("Error Invalid Type");
    }

    public abstract int getNumParams();

    public abstract Object[] getData();

    public abstract String getConstructedText();

    @Override
    public NBTTagCompound getDescriptionPacket(boolean changesOnly) {
        Object[] newData = this.getData();
        if (this.curData == null) {
            this.curData = new Object[this.getNumParams()];
            changesOnly = false;
        }
        NBTTagCompound tag = new NBTTagCompound();
        for (int i = 0; i < this.curData.length; ++i) {
            if (!(newData[i] == null || changesOnly && this.curData[i] != null && this.curData[i].toString().equals(newData[i].toString()))) {
                tag.func_74782_a(Integer.toString(i), WidgetTextData.getNBTBase(newData[i]));
            }
            this.curData[i] = newData[i];
        }
        if (tag.func_82582_d()) {
            return null;
        }
        return tag;
    }

    @Override
    public void handleDescriptionPacket(NBTTagCompound packet) {
        if (this.curData == null) {
            this.curData = new Object[this.getNumParams()];
        }
        int n = this.getNumParams();
        for (int i = 0; i < n; ++i) {
            NBTBase base = packet.func_74781_a(Integer.toString(i));
            if (base == null) continue;
            this.curData[i] = WidgetTextData.getNBTBaseData(base);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
        if (this.curData == null) {
            return;
        }
        int x = this.getX() + (1 - this.align) * (this.getW() - gui.getFontRenderer().func_78256_a(this.getMsgClient())) / 2;
        gui.getFontRenderer().func_78279_b(this.getConstructedText(), guiLeft + x, guiTop + this.getY(), this.getW(), 0x404040);
        manager.func_110577_a(gui.getWidgets());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

