/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.utils;

import java.util.Random;

public final class RandomUtils {
    public static final Random random = new Random();

    private RandomUtils() {
    }

    public static int getInt(int max) {
        return random.nextInt(max);
    }

    public static int getInt(int min, int max) {
        return max > min ? min + RandomUtils.getInt(max - min) : min;
    }

    public static float getFloat() {
        return random.nextFloat();
    }

    public static float getFloat(float max) {
        return RandomUtils.getFloat() * max;
    }

    public static float getFloat(float min, float max) {
        return max > min ? min + RandomUtils.getFloat(max - min) : min;
    }

    public static double getDouble() {
        return random.nextDouble();
    }

    public static double getDouble(double max) {
        return RandomUtils.getDouble() * max;
    }

    public static double getDouble(double min, double max) {
        return max > min ? min + RandomUtils.getDouble(max - min) : min;
    }

    public static boolean getBoolean(double probability) {
        return RandomUtils.getDouble() < probability;
    }

    public static double getGaussian() {
        return random.nextGaussian();
    }
}

