/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.crate;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.tile.crate.CratePileData;
import net.mcft.copy.betterstorage.utils.RandomUtils;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.SaveHandler;

public class CratePileCollection {
    private static final int maxCount = Short.MAX_VALUE;
    private static Map<Integer, CratePileCollection> collectionMap = new HashMap<Integer, CratePileCollection>();
    public final World world;
    public final int dimension;
    private int count = RandomUtils.getInt(Short.MAX_VALUE);
    private Map<Integer, CratePileData> pileDataMap = new HashMap<Integer, CratePileData>();

    public CratePileCollection(World world) {
        this.world = world;
        this.dimension = world.field_73011_w.field_76574_g;
    }

    public static CratePileCollection getCollection(World world) {
        CratePileCollection collection;
        int dimension = world.field_73011_w.field_76574_g;
        if (!collectionMap.containsKey(dimension)) {
            collection = new CratePileCollection(world);
            collectionMap.put(dimension, collection);
        } else {
            collection = collectionMap.get(dimension);
        }
        return collection;
    }

    public CratePileData getCratePile(int id) {
        CratePileData pileData;
        if (!this.pileDataMap.containsKey(id)) {
            pileData = this.load(id);
            if (pileData == null) {
                pileData = new CratePileData(this, id, 0);
            }
            this.pileDataMap.put(id, pileData);
        } else {
            pileData = this.pileDataMap.get(id);
        }
        return pileData;
    }

    public CratePileData createCratePile() {
        int id = this.count;
        while (this.pileDataMap.containsKey(++this.count)) {
        }
        CratePileData pileData = new CratePileData(this, id, 0);
        this.pileDataMap.put(id, pileData);
        return pileData;
    }

    public void removeCratePile(CratePileData pileData) {
        this.pileDataMap.remove(pileData.id);
        this.getSaveFile(pileData.id).delete();
        if (this.pileDataMap.size() <= 0) {
            collectionMap.remove(this.dimension);
        }
    }

    public void save(CratePileData pileData) {
        try {
            File file = this.getSaveFile(pileData.id);
            File tempFile = this.getTempSaveFile(pileData.id);
            file.getParentFile().mkdir();
            NBTTagCompound root = new NBTTagCompound();
            root.func_74782_a("data", (NBTBase)pileData.toCompound());
            CompressedStreamTools.func_74795_b((NBTTagCompound)root, (File)tempFile);
            if (file.exists() && !file.delete()) {
                throw new Exception(file + " could not be deleted.");
            }
            tempFile.renameTo(file);
        }
        catch (Exception e) {
            BetterStorage.log.warn("Error saving CratePileData: " + e);
            e.printStackTrace();
        }
    }

    public CratePileData load(int id) {
        try {
            File file = this.getSaveFile(id);
            if (!file.exists()) {
                return null;
            }
            NBTTagCompound root = CompressedStreamTools.func_74797_a((File)file);
            return CratePileData.fromCompound(this, id, root.func_74775_l("data"));
        }
        catch (Exception e) {
            BetterStorage.log.warn("Error loading CratePileData: " + e);
            e.printStackTrace();
            return null;
        }
    }

    private File getSaveDirectory() {
        File saveFolder = ((SaveHandler)this.world.func_72860_G()).func_75765_b();
        return new File(saveFolder, "data" + File.separator + "crates");
    }

    private File getSaveFile(int id) {
        return new File(this.getSaveDirectory(), id + ".dat");
    }

    private File getTempSaveFile(int id) {
        return new File(this.getSaveDirectory(), id + ".tmp");
    }

    public static void unload(World world) {
        int dimension = world.field_73011_w.field_76574_g;
        collectionMap.remove(dimension);
    }

    public void onTick() {
        for (CratePileData data : this.pileDataMap.values()) {
            data.blockView.onUpdate();
        }
    }
}

