/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.misc.handlers;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.api.BetterStorageBackpack;
import net.mcft.copy.betterstorage.content.BetterStorageItems;
import net.mcft.copy.betterstorage.content.BetterStorageTiles;
import net.mcft.copy.betterstorage.entity.EntityFrienderman;
import net.mcft.copy.betterstorage.inventory.InventoryStacks;
import net.mcft.copy.betterstorage.item.ItemBackpack;
import net.mcft.copy.betterstorage.item.ItemEnderBackpack;
import net.mcft.copy.betterstorage.misc.PropertiesBackpack;
import net.mcft.copy.betterstorage.network.packet.PacketSyncSetting;
import net.mcft.copy.betterstorage.tile.TileEnderBackpack;
import net.mcft.copy.betterstorage.utils.DirectionUtils;
import net.mcft.copy.betterstorage.utils.EntityUtils;
import net.mcft.copy.betterstorage.utils.NbtUtils;
import net.mcft.copy.betterstorage.utils.RandomUtils;
import net.mcft.copy.betterstorage.utils.ReflectionUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class BackpackHandler {
    private static final WeightedRandomChestContent[] randomBackpackItems = new WeightedRandomChestContent[]{BackpackHandler.makeWeightedContent(Items.field_151055_y, 8, 20, 100), BackpackHandler.makeWeightedContent(Blocks.field_150344_f, 2, 10, 100), BackpackHandler.makeWeightedContent(Blocks.field_150364_r, 1, 8, 40), BackpackHandler.makeWeightedContent(Blocks.field_150347_e, 6, 16, 80), BackpackHandler.makeWeightedContent(Items.field_151039_o, 50, 35), BackpackHandler.makeWeightedContent(Items.field_151039_o, 20, 10), BackpackHandler.makeWeightedContent(Items.field_151050_s, 120, 10), BackpackHandler.makeWeightedContent(Items.field_151050_s, 80, 5), BackpackHandler.makeWeightedContent(Items.field_151035_b, 220, 2), BackpackHandler.makeWeightedContent(Items.field_151041_m, 40, 30), BackpackHandler.makeWeightedContent(Items.field_151052_q, 60, 5), BackpackHandler.makeWeightedContent((Item)Items.field_151031_f, 200, 1, 1, 10), BackpackHandler.makeWeightedContent((Item)Items.field_151031_f, 50, 1, 1, 3), BackpackHandler.makeWeightedContent((Item)Items.field_151112_aM, 20, 1, 1, 4), BackpackHandler.makeWeightedContent(Items.field_151111_aL, 1, 1, 6), BackpackHandler.makeWeightedContent(Items.field_151113_aN, 1, 1, 5), BackpackHandler.makeWeightedContent(Blocks.field_150478_aa, 6, 24, 30), BackpackHandler.makeWeightedContent(Items.field_151032_g, 2, 12, 10), BackpackHandler.makeWeightedContent(Items.field_151078_bh, 0, 3, 6, 15), BackpackHandler.makeWeightedContent(Items.field_151103_aS, 2, 5, 20), BackpackHandler.makeWeightedContent(Items.field_151007_F, 3, 10, 15), BackpackHandler.makeWeightedContent(Items.field_151034_e, 2, 5, 15), BackpackHandler.makeWeightedContent(Items.field_151025_P, 2, 4, 10), BackpackHandler.makeWeightedContent(Items.field_151015_O, 3, 6, 10), BackpackHandler.makeWeightedContent(Items.field_151172_bF, 1, 2, 8), BackpackHandler.makeWeightedContent(Items.field_151174_bG, 1, 2, 5), BackpackHandler.makeWeightedContent(Items.field_151115_aP, 1, 4, 5), BackpackHandler.makeWeightedContent(Items.field_151101_aQ, 1, 2, 4), BackpackHandler.makeWeightedContent(Items.field_151044_h, 3, 9, 20), BackpackHandler.makeWeightedContent(Items.field_151044_h, 20, 32, 5), BackpackHandler.makeWeightedContent(Blocks.field_150366_p, 2, 5, 15), BackpackHandler.makeWeightedContent(Blocks.field_150366_p, 10, 20, 2), BackpackHandler.makeWeightedContent(Blocks.field_150352_o, 2, 7, 8), BackpackHandler.makeWeightedContent(Items.field_151045_i, 1, 2, 1), BackpackHandler.makeWeightedContent(Items.field_151166_bC, 1, 1, 1)};
    private static Comparator<BlockCoordinate> blockDistanceComparator = new Comparator<BlockCoordinate>(){

        @Override
        public int compare(BlockCoordinate o1, BlockCoordinate o2) {
            if (o1.distance < o2.distance) {
                return -1;
            }
            if (o1.distance > o2.distance) {
                return 1;
            }
            return 0;
        }
    };

    private static WeightedRandomChestContent makeWeightedContent(Item item, int damage, int min, int max, int weight) {
        return new WeightedRandomChestContent(item, damage, min, max, weight);
    }

    private static WeightedRandomChestContent makeWeightedContent(Item item, int min, int max, int weight) {
        return BackpackHandler.makeWeightedContent(item, 0, min, max, weight);
    }

    private static WeightedRandomChestContent makeWeightedContent(Item item, int damage, int weight) {
        return BackpackHandler.makeWeightedContent(item, damage, 1, 1, weight);
    }

    private static WeightedRandomChestContent makeWeightedContent(Block block, int min, int max, int weight) {
        return BackpackHandler.makeWeightedContent(Item.func_150898_a((Block)block), min, max, weight);
    }

    public BackpackHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        BetterStorageBackpack.spawnWithBackpack(EntityZombie.class, 0.00125);
        BetterStorageBackpack.spawnWithBackpack(EntitySkeleton.class, 8.333333333333334E-4);
        BetterStorageBackpack.spawnWithBackpack(EntityPigZombie.class, 0.001);
        BetterStorageBackpack.spawnWithBackpack(EntityEnderman.class, 0.0125);
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityLivingBase) {
            ItemBackpack.initBackpackData((EntityLivingBase)event.entity);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && ItemBackpack.onPlaceBackpack(event.entityPlayer, event.x, event.y, event.z, event.face)) {
            event.useBlock = Event.Result.DENY;
            event.useItem = Event.Result.DENY;
        }
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        if (event.entity.field_70170_p.field_72995_K || !(event.entity instanceof EntityPlayerMP) || !(event.target instanceof EntityLivingBase) || ((EntityPlayerMP)event.entity).field_71135_a == null || event.target instanceof EntityPlayer && !BetterStorage.globalConfig.getBoolean("general.enableBackpackInteraction")) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.entity;
        EntityLivingBase target = (EntityLivingBase)event.target;
        if (ItemBackpack.openBackpack((EntityPlayer)player, target)) {
            player.func_71038_i();
        }
    }

    @SubscribeEvent
    public void onSpecialSpawn(LivingSpawnEvent.SpecialSpawn event) {
        EntityLivingBase entity = event.entityLiving;
        World world = entity.field_70170_p;
        double probability = 0.0;
        for (BetterStorageBackpack.BackpackSpawnEntry entry : BetterStorageBackpack.spawnWithBackpack) {
            if (!entity.getClass().equals(entry.entityClass)) continue;
            probability = entry.probability;
            break;
        }
        if (!RandomUtils.getBoolean(probability) || entity.func_70631_g_()) {
            return;
        }
        if (entity.getClass().equals(EntityEnderman.class)) {
            if (BetterStorageTiles.enderBackpack != null && world.field_73011_w.field_76574_g != 1 && world.func_72807_a((int)entity.field_70165_t, (int)entity.field_70161_v) != BiomeGenBase.field_76779_k) {
                EntityFrienderman frienderman = new EntityFrienderman(world);
                frienderman.func_70080_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, 0.0f);
                world.func_72838_d((Entity)frienderman);
                ItemBackpack.getBackpackData((EntityLivingBase)frienderman).spawnsWithBackpack = true;
                entity.func_70106_y();
            }
        } else if (BetterStorageTiles.backpack != null) {
            ItemBackpack.getBackpackData((EntityLivingBase)entity).spawnsWithBackpack = true;
        }
    }

    @SubscribeEvent
    public void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        if (event.target instanceof EntityLivingBase) {
            ItemBackpack.getBackpackData((EntityLivingBase)event.target).sendDataToPlayer((EntityLivingBase)event.target, event.entityPlayer);
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        ItemBackpack.getBackpackData((EntityLivingBase)event.player).sendDataToPlayer((EntityLivingBase)event.player, event.player);
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.entityLiving;
        EntityPlayer player = entity instanceof EntityPlayer ? (EntityPlayer)entity : null;
        ItemStack backpack = ItemBackpack.getBackpack(entity);
        if (backpack == null) {
            PropertiesBackpack backpackData = EntityUtils.getProperties((Entity)entity, PropertiesBackpack.class);
            if (backpackData == null) {
                return;
            }
            if (backpackData.spawnsWithBackpack) {
                ItemStack[] contents = null;
                if (entity instanceof EntityFrienderman) {
                    backpack = new ItemStack((Item)BetterStorageItems.itemEnderBackpack);
                    ((EntityLiving)entity).func_96120_a(3, 0.0f);
                } else {
                    backpack = new ItemStack((Item)BetterStorageItems.itemBackpack, 1, RandomUtils.getInt(120, 240));
                    ItemBackpack backpackType = (ItemBackpack)backpack.func_77973_b();
                    if (RandomUtils.getBoolean(0.15)) {
                        int r = RandomUtils.getInt(32, 224);
                        int g = RandomUtils.getInt(32, 224);
                        int b = RandomUtils.getInt(32, 224);
                        int color = r << 16 | g << 8 | b;
                        StackUtils.set(backpack, color, "display", "color");
                    }
                    contents = new ItemStack[backpackType.getBackpackColumns() * backpackType.getBackpackRows()];
                    ((EntityLiving)entity).func_96120_a(3, 1.0f);
                }
                ItemStack armor = entity.func_71124_b(3);
                if (armor != null && armor.func_77948_v()) {
                    NBTTagCompound compound = new NBTTagCompound();
                    compound.func_74782_a("ench", armor.func_77978_p().func_74781_a("ench"));
                    backpack.func_77982_d(compound);
                }
                if (contents != null) {
                    InventoryStacks inventory = new InventoryStacks(new ItemStack[][]{contents});
                    WeightedRandomChestContent.func_76293_a((Random)RandomUtils.random, (WeightedRandomChestContent[])randomBackpackItems, (IInventory)inventory, (int)20);
                    if (RandomUtils.getDouble() < 0.1) {
                        ChestGenHooks info = ChestGenHooks.getInfo((String)"dungeonChest");
                        WeightedRandomChestContent.func_76293_a((Random)RandomUtils.random, (WeightedRandomChestContent[])info.getItems(RandomUtils.random), (IInventory)inventory, (int)5);
                    }
                }
                ItemBackpack.setBackpack(entity, backpack, contents);
                backpackData.spawnsWithBackpack = false;
            } else if (backpackData.contents != null) {
                for (ItemStack stack : backpackData.contents) {
                    WorldUtils.dropStackFromEntity((Entity)entity, stack, 1.5f);
                }
                backpackData.contents = null;
            }
        }
        ItemBackpack.getBackpackData(entity).update(entity);
        if (backpack != null) {
            ((ItemBackpack)backpack.func_77973_b()).onEquippedUpdate(entity, backpack);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = entity instanceof EntityPlayer ? (EntityPlayer)entity : null;
        ItemStack backpack = ItemBackpack.getBackpack(entity);
        if (backpack == null) {
            return;
        }
        PropertiesBackpack backpackData = ItemBackpack.getBackpackData(entity);
        if (backpackData.contents == null) {
            return;
        }
        boolean keepInventory = entity.field_70170_p.func_82736_K().func_82766_b("keepInventory");
        if (player != null && keepInventory) {
            NBTTagCompound persistent;
            NBTTagCompound compound = player.getEntityData();
            if (!compound.func_74764_b("PlayerPersisted")) {
                persistent = new NBTTagCompound();
                compound.func_74782_a("PlayerPersisted", (NBTBase)persistent);
            } else {
                persistent = compound.func_74775_l("PlayerPersisted");
            }
            NBTTagCompound backpackCompound = new NBTTagCompound();
            backpackCompound.func_74768_a("count", backpackData.contents.length);
            backpackCompound.func_74782_a("Items", (NBTBase)NbtUtils.writeItems(backpackData.contents));
            if (!ItemBackpack.hasChestplateBackpackEquipped(entity)) {
                backpackCompound.func_74782_a("Stack", (NBTBase)backpack.func_77955_b(new NBTTagCompound()));
            }
            persistent.func_74782_a("Backpack", (NBTBase)backpackCompound);
        } else {
            if (BetterStorage.globalConfig.getBoolean("general.dropBackpackOnDeath")) {
                ForgeDirection orientation = DirectionUtils.getOrientation((Entity)entity);
                int recentlyHit = (Integer)ReflectionUtils.get(EntityLivingBase.class, entity, "field_70718_bc", "recentlyHit");
                boolean despawn = player == null && recentlyHit <= 0;
                ArrayList<BlockCoordinate> coords = new ArrayList<BlockCoordinate>();
                for (int x = -2; x <= 2; ++x) {
                    for (int z = -2; z <= 2; ++z) {
                        coords.add(new BlockCoordinate(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, x, 0, z));
                    }
                }
                Collections.sort(coords, blockDistanceComparator);
                while (!coords.isEmpty()) {
                    Iterator iter = coords.iterator();
                    while (iter.hasNext()) {
                        BlockCoordinate coord = (BlockCoordinate)iter.next();
                        if (ItemBackpack.placeBackpack(entity, player, backpack, coord.x, coord.y, coord.z, 1, orientation, despawn, true)) {
                            ItemBackpack.setBackpack(entity, null, null);
                            return;
                        }
                        boolean replacable = entity.field_70170_p.func_147439_a(coord.x, coord.y, coord.z).isReplaceable((IBlockAccess)entity.field_70170_p, coord.x, coord.y, coord.z);
                        coord.y = coord.y + (replacable ? -1 : 1);
                        coord.moved = coord.moved + (replacable ? 1 : 5);
                        if (coord.y > 0 && coord.y <= entity.field_70170_p.func_72800_K() && !((double)coord.moved > 24.0 - coord.distance * 4.0)) continue;
                        iter.remove();
                    }
                }
                if (backpackData.backpack != null) {
                    WorldUtils.dropStackFromEntity((Entity)entity, backpack, 4.0f);
                }
            }
            for (ItemStack stack : backpackData.contents) {
                WorldUtils.dropStackFromEntity((Entity)entity, stack, 4.0f);
            }
            backpackData.contents = null;
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        if (!(event.entity instanceof EntityItem)) {
            return;
        }
        EntityItem entity = (EntityItem)event.entity;
        ItemStack stack = entity.func_70096_w().func_82710_f(10);
        if (stack == null || !(stack.func_77973_b() instanceof ItemEnderBackpack)) {
            return;
        }
        event.setCanceled(true);
        for (int i = 0; i < 64 && !TileEnderBackpack.teleportRandomly(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, i > 48, stack); ++i) {
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        BetterStorage.networkChannel.sendTo(new PacketSyncSetting(BetterStorage.globalConfig), event.player);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        NBTTagCompound entityData = event.player.getEntityData();
        if (!entityData.func_74764_b("PlayerPersisted")) {
            return;
        }
        NBTTagCompound persistent = entityData.func_74775_l("PlayerPersisted");
        if (!persistent.func_74764_b("Backpack")) {
            return;
        }
        NBTTagCompound compound = persistent.func_74775_l("Backpack");
        PropertiesBackpack backpackData = ItemBackpack.getBackpackData((EntityLivingBase)event.player);
        int size = compound.func_74762_e("count");
        ItemStack[] contents = new ItemStack[size];
        NbtUtils.readItems(contents, compound.func_150295_c("Items", 10));
        backpackData.contents = contents;
        if (compound.func_74764_b("Stack")) {
            backpackData.backpack = ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("Stack"));
        }
        persistent.func_82580_o("Backpack");
        if (persistent.func_82582_d()) {
            entityData.func_82580_o("PlayerPersisted");
        }
    }

    private static class BlockCoordinate {
        public int x;
        public int y;
        public int z;
        public double distance;
        public int moved = 0;

        public BlockCoordinate(double ex, double ey, double ez, int x, int y, int z) {
            this.x = (int)ex + x;
            this.y = (int)ey + y;
            this.z = (int)ez + z;
            this.distance = Math.sqrt(Math.pow((double)this.x + 0.5 - ex, 2.0) + Math.pow((double)this.y + 0.5 - ey, 2.0) + Math.pow((double)this.z + 0.5 - ez, 2.0));
        }
    }
}

