/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.container;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import invtweaks.api.container.InventoryContainer;
import net.mcft.copy.betterstorage.container.ContainerBetterStorage;
import net.mcft.copy.betterstorage.inventory.InventoryCratePlayerView;
import net.mcft.copy.betterstorage.tile.crate.CratePileData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2FPacketSetSlot;

@InventoryContainer
public class ContainerCrate
extends ContainerBetterStorage {
    private InventoryCratePlayerView playerView;
    public int fullness = 0;
    private int lastFullness = 0;

    public ContainerCrate(EntityPlayer player, InventoryCratePlayerView inventory) {
        super(player, inventory, 9, inventory.func_70302_i_() / 9);
        this.playerView = inventory;
        CratePileData data = inventory.data;
        this.fullness = data.getOccupiedSlots() * 255 / data.getCapacity();
    }

    public ContainerCrate(EntityPlayer player, int rows, String name, boolean localized) {
        super(player, (IInventory)new InventoryBasic(name, !localized, 9 * rows), 9, rows);
    }

    public void func_75142_b() {
        if (this.playerView == null) {
            return;
        }
        super.func_75142_b();
        CratePileData data = this.playerView.data;
        if (data.getNumCrates() <= 0) {
            return;
        }
        this.fullness = data.getOccupiedSlots() * 255 / data.getCapacity();
        this.sendUpdateIfChanged(0, this.fullness, this.lastFullness);
        this.lastFullness = this.fullness;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int val) {
        if (id == 0) {
            this.fullness = val;
        }
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int slotId) {
        if (this.playerView == null) {
            return super.func_82846_b(player, slotId);
        }
        Slot slot = (Slot)this.field_75151_b.get(slotId);
        ItemStack slotStack = slot.func_75211_c();
        if (slotStack == null) {
            return null;
        }
        ItemStack stackBefore = slotStack.func_77946_l();
        if (slotId < this.getColumns() * this.getRows()) {
            int count = slotStack.field_77994_a;
            boolean success = this.func_75135_a(slotStack, this.playerView.func_70302_i_(), this.field_75151_b.size(), true);
            int amount = count - slotStack.field_77994_a;
            slotStack.field_77994_a = count;
            this.playerView.func_70298_a(slotId, amount);
            if (!success) {
                return null;
            }
        } else {
            boolean success = this.playerView.canFitSome(slotStack);
            ItemStack overflow = this.playerView.data.addItems(slotStack);
            slot.func_75215_d(overflow);
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S2FPacketSetSlot(player.field_71070_bA.field_75152_c, slotId, overflow));
            if (!success) {
                return null;
            }
        }
        return stackBefore;
    }
}

