/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.config.setting;

import cpw.mods.fml.client.config.ConfigGuiType;
import java.util.Arrays;
import net.mcft.copy.betterstorage.config.Config;
import net.mcft.copy.betterstorage.config.setting.SinglePropertySetting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.ArrayUtils;

public class IntegerSetting
extends SinglePropertySetting<Integer> {
    protected int minValue = Integer.MIN_VALUE;
    protected int maxValue = Integer.MAX_VALUE;
    protected int[] validValues = null;

    public IntegerSetting(Config config, String fullName, Integer defaultValue) {
        super(config, fullName, defaultValue, ConfigGuiType.INTEGER);
    }

    public IntegerSetting(Config config, String fullName, Integer defaultValue, String langKey) {
        super(config, fullName, defaultValue, ConfigGuiType.INTEGER, langKey);
    }

    public IntegerSetting(Config config, String fullName) {
        this(config, fullName, 0);
    }

    public IntegerSetting(Config config, String fullName, String langKey) {
        this(config, fullName, 0, langKey);
    }

    public IntegerSetting setComment(String comment) {
        super.setComment(comment);
        return this;
    }

    public IntegerSetting setSynced() {
        super.setSynced();
        return this;
    }

    public IntegerSetting setValidRange(int min, int max) {
        this.minValue = min;
        this.maxValue = max;
        return this;
    }

    public IntegerSetting setValidValues(int ... values) {
        this.validValues = values;
        return this;
    }

    @Override
    public String validateInternal(Integer value) {
        if (value < this.minValue || value > this.maxValue) {
            return String.format("Value %s is not in valid range, %s to %s", value, this.minValue, this.maxValue);
        }
        if (this.validValues != null && !ArrayUtils.contains((int[])this.validValues, (int)value)) {
            return String.format("Value %s is not valid, needs to be one of %s", value, Arrays.toString(this.validValues));
        }
        return null;
    }

    @Override
    protected Property.Type getPropertyType() {
        return Property.Type.INTEGER;
    }

    @Override
    protected Integer loadInternal(Configuration config) {
        return this.getProperty(config).getInt();
    }

    @Override
    protected void saveInternal(Configuration config, Integer value) {
        this.getProperty(config).set(value.intValue());
    }

    @Override
    protected Integer readInternal(NBTTagCompound compound) {
        return compound.func_74762_e(this.fullName);
    }

    @Override
    protected void writeInternal(NBTTagCompound compound, Integer value) {
        compound.func_74768_a(this.fullName, value.intValue());
    }

    public Integer getMinValue() {
        return this.minValue;
    }

    public Integer getMaxValue() {
        return this.maxValue;
    }
}

