/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.blocks.logic;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import mantle.world.CoordTuple;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tmechworks.blocks.component.SignalBusMasterLogic;
import tmechworks.common.MechContent;
import tmechworks.lib.multiblock.IMultiblockMember;
import tmechworks.lib.multiblock.MultiblockBaseLogic;
import tmechworks.lib.multiblock.MultiblockMasterBaseLogic;
import tmechworks.lib.signal.ISignalBusConnectable;
import tmechworks.lib.signal.ISignalTransceiver;

public class SignalBusLogic
extends MultiblockBaseLogic
implements ISignalBusConnectable {
    private int ticks = 0;
    private Map<CoordTuple, byte[]> transceivers = new HashMap<CoordTuple, byte[]>();
    private byte[] localHighSignals = new byte[16];
    private byte[] cachedReceivedSignals = new byte[16];
    private int cachedConnectableCount = 0;
    private boolean southboundSignalsChanged = false;
    private boolean northboundSignalsChanged = false;
    private boolean forceCheck = false;
    private World world;
    private boolean[] placedSides = new boolean[]{false, false, false, false, false, false};

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public IMultiblockMember[] getNeighboringMembers() {
        LinkedList<IMultiblockMember> corners = new LinkedList<IMultiblockMember>();
        for (int i = 0; i < 6; ++i) {
            if (!this.placedSides[i]) continue;
            for (int j = 0; j < 6; ++j) {
                TileEntity te;
                int tZ;
                int tY;
                int tX;
                if (j == i || j == ForgeDirection.OPPOSITES[i] || this.field_145850_b.func_147439_a(tX = ForgeDirection.VALID_DIRECTIONS[j].offsetX + this.field_145851_c, tY = ForgeDirection.VALID_DIRECTIONS[j].offsetY + this.field_145848_d, tZ = ForgeDirection.VALID_DIRECTIONS[j].offsetZ + this.field_145849_e).func_149662_c() || !((te = this.field_145850_b.func_147438_o(tX += ForgeDirection.VALID_DIRECTIONS[i].offsetX, tY += ForgeDirection.VALID_DIRECTIONS[i].offsetY, tZ += ForgeDirection.VALID_DIRECTIONS[i].offsetZ)) instanceof IMultiblockMember) || !((IMultiblockMember)te).isCompatible(this) || !((IMultiblockMember)te).willConnect(this.getCoordInWorld())) continue;
                corners.add((IMultiblockMember)te);
            }
        }
        corners.addAll(Arrays.asList(super.getNeighboringMembers()));
        IMultiblockMember[] tmp = new IMultiblockMember[corners.size()];
        return corners.toArray(tmp);
    }

    public void broadcastSouthboundSignals() {
        if (this.southboundSignalsChanged) {
            TileEntity te = null;
            for (CoordTuple coord : this.transceivers.keySet()) {
                if (!this.field_145850_b.func_72863_F().func_73149_a(coord.x >> 4, coord.z >> 4) || !((te = this.field_145850_b.func_147438_o(coord.x, coord.y, coord.z)) instanceof ISignalTransceiver)) continue;
                ((ISignalTransceiver)te).receiveSignalUpdate(this.cachedReceivedSignals);
            }
            this.southboundSignalsChanged = false;
        }
    }

    public void multiBlockTick() {
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.isConnected()) {
            return;
        }
        if (this.forceCheck) {
            int connectableCount = this.getNeighboringMembers().length;
            this.forceCheck = false;
            if (connectableCount != this.cachedConnectableCount) {
                this.cachedConnectableCount = connectableCount;
                super.onBlockAdded(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (this.northboundSignalsChanged) {
            this.localHighSignals = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            for (CoordTuple coord : this.transceivers.keySet()) {
                byte[] signals = this.transceivers.get(coord);
                if (signals[0] > this.localHighSignals[0]) {
                    this.localHighSignals[0] = signals[0];
                }
                if (signals[1] > this.localHighSignals[1]) {
                    this.localHighSignals[1] = signals[1];
                }
                if (signals[2] > this.localHighSignals[2]) {
                    this.localHighSignals[2] = signals[2];
                }
                if (signals[3] > this.localHighSignals[3]) {
                    this.localHighSignals[3] = signals[3];
                }
                if (signals[4] > this.localHighSignals[4]) {
                    this.localHighSignals[4] = signals[4];
                }
                if (signals[5] > this.localHighSignals[5]) {
                    this.localHighSignals[5] = signals[5];
                }
                if (signals[6] > this.localHighSignals[6]) {
                    this.localHighSignals[6] = signals[6];
                }
                if (signals[7] > this.localHighSignals[7]) {
                    this.localHighSignals[7] = signals[7];
                }
                if (signals[8] > this.localHighSignals[8]) {
                    this.localHighSignals[8] = signals[8];
                }
                if (signals[9] > this.localHighSignals[9]) {
                    this.localHighSignals[9] = signals[9];
                }
                if (signals[10] > this.localHighSignals[10]) {
                    this.localHighSignals[10] = signals[10];
                }
                if (signals[11] > this.localHighSignals[11]) {
                    this.localHighSignals[11] = signals[11];
                }
                if (signals[12] > this.localHighSignals[12]) {
                    this.localHighSignals[12] = signals[12];
                }
                if (signals[13] > this.localHighSignals[13]) {
                    this.localHighSignals[13] = signals[13];
                }
                if (signals[14] > this.localHighSignals[14]) {
                    this.localHighSignals[14] = signals[14];
                }
                if (signals[15] <= this.localHighSignals[15]) continue;
                this.localHighSignals[15] = signals[15];
            }
            ((SignalBusMasterLogic)this.getMultiblockMaster()).updateBusSignals(this.getCoordInWorld(), this.localHighSignals);
            this.northboundSignalsChanged = false;
        }
        this.broadcastSouthboundSignals();
    }

    public boolean registerTerminal(World world, int x, int y, int z, boolean rehome) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        this.world = world;
        if (world == this.field_145850_b && world.field_72995_K == this.field_145850_b.field_72995_K && this.field_145850_b.func_147438_o(x, y, z) instanceof ISignalTransceiver) {
            TileEntity te = world.func_147438_o(x, y, z);
            CoordTuple coords = new CoordTuple((double)x, (double)y, (double)z);
            byte[] signals = null;
            if (this.transceivers.containsKey(coords)) {
                return true;
            }
            int dropWire = ((ISignalTransceiver)te).doUnregister(rehome);
            if (dropWire > 0) {
                Random rand = new Random();
                ItemStack tempStack = new ItemStack(MechContent.lengthWire, dropWire);
                float jumpX = rand.nextFloat() * 0.8f + 0.1f;
                float jumpY = rand.nextFloat() * 0.8f + 0.1f;
                float jumpZ = rand.nextFloat() * 0.8f + 0.1f;
                EntityItem entityitem = new EntityItem(world, (double)((float)this.field_145851_c + jumpX), (double)((float)this.field_145848_d + jumpY), (double)((float)this.field_145849_e + jumpZ), tempStack);
                float offset = 0.05f;
                entityitem.field_70159_w = (float)rand.nextGaussian() * offset;
                entityitem.field_70181_x = (float)rand.nextGaussian() * offset + 0.2f;
                entityitem.field_70179_y = (float)rand.nextGaussian() * offset;
                world.func_72838_d((Entity)entityitem);
            }
            ((ISignalTransceiver)te).setBusCoords(world, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            signals = ((ISignalTransceiver)te).getReceivedSignals();
            this.transceivers.put(coords, signals);
            this.northboundSignalsChanged = true;
            if (this.getMultiblockMaster() instanceof MultiblockMasterBaseLogic) {
                this.updateLocalSignals(((SignalBusMasterLogic)this.getMultiblockMaster()).getSignals());
            }
            ((ISignalTransceiver)te).receiveSignalUpdate(this.cachedReceivedSignals);
            return true;
        }
        return false;
    }

    @Override
    public void onDetached(MultiblockMasterBaseLogic oldMaster) {
        super.onDetached(oldMaster);
    }

    @Override
    public void onAttached(MultiblockMasterBaseLogic newMaster) {
        super.onAttached(newMaster);
        if (this.transceivers != null || !this.transceivers.isEmpty()) {
            this.northboundSignalsChanged = true;
            this.updateLocalSignals(((SignalBusMasterLogic)this.getMultiblockMaster()).getSignals());
        }
    }

    public boolean isRegisteredTerminal(World world, int x, int y, int z) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        return this.transceivers.containsKey(new CoordTuple((double)x, (double)y, (double)z));
    }

    public boolean unregisterTerminal(World world, int x, int y, int z) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        if (this.transceivers.remove(new CoordTuple((double)x, (double)y, (double)z)) != null) {
            this.northboundSignalsChanged = true;
            return true;
        }
        return false;
    }

    public boolean hasTerminals() {
        return this.transceivers.size() > 0;
    }

    @Override
    public boolean isCompatible(Object other) {
        return other.getClass() == this.getClass();
    }

    @Override
    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.readCustomNBT(tags);
    }

    public void readCustomNBT(NBTTagCompound tags) {
        int temp = tags.func_74762_e("placedSides");
        for (int i = 0; i < 6; ++i) {
            this.placedSides[i] = (temp >> i & 1) == 1;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tags) {
        super.func_145841_b(tags);
        this.writeCustomNBT(tags);
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        int temp = 0;
        for (int i = 0; i < 6; ++i) {
            if (!this.placedSides[i]) continue;
            temp |= 1 << i;
        }
        tags.func_74768_a("placedSides", temp);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.readCustomNBT(packet.func_148857_g());
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean[] placedSides() {
        return (boolean[])this.placedSides.clone();
    }

    public boolean[] connectedSides(ForgeDirection fromFace) {
        boolean[] connected = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            if (i == fromFace.ordinal() || i == fromFace.getOpposite().ordinal()) continue;
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            int neighborX = this.field_145851_c + dir.offsetX;
            int neighborY = this.field_145848_d + dir.offsetY;
            int neighborZ = this.field_145849_e + dir.offsetZ;
            TileEntity te = this.field_145850_b.func_147438_o(neighborX, neighborY, neighborZ);
            connected[i] = te instanceof ISignalBusConnectable && ((ISignalBusConnectable)te).connectableOnFace(fromFace);
        }
        return connected;
    }

    @Override
    public boolean connectableOnFace(ForgeDirection side) {
        return this.placedSides[side.ordinal()];
    }

    public boolean isConnected(ForgeDirection side, ForgeDirection dir) {
        switch (dir) {
            case DOWN: {
                return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) instanceof SignalBusLogic;
            }
            case NORTH: {
                return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) instanceof SignalBusLogic;
            }
            case SOUTH: {
                return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) instanceof SignalBusLogic;
            }
            case WEST: {
                return this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) instanceof SignalBusLogic;
            }
            case EAST: {
                return this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) instanceof SignalBusLogic;
            }
        }
        return false;
    }

    @Override
    public MultiblockMasterBaseLogic getNewMultiblockMasterObject() {
        return new SignalBusMasterLogic(this.field_145850_b);
    }

    public byte[] getLocalSignals() {
        return this.localHighSignals;
    }

    public void updateTransceiverSignals(CoordTuple coords, byte[] signals) {
        if (!Arrays.equals(signals, this.transceivers.get(coords))) {
            this.transceivers.put(coords, signals);
            this.northboundSignalsChanged = true;
        }
    }

    public void updateLocalSignals(byte[] signals) {
        if (!Arrays.equals(signals, this.cachedReceivedSignals)) {
            this.cachedReceivedSignals = (byte[])signals.clone();
            this.southboundSignalsChanged = true;
        }
    }

    public void addPlacedSide(int side) {
        this.placedSides[side] = true;
        if (!this.field_145850_b.field_72995_K) {
            this.forceCheck = true;
        }
    }

    public boolean[] getRenderCorners(ForgeDirection fromFace) {
        boolean[] corners = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            if (i == fromFace.ordinal() || i == fromFace.getOpposite().ordinal()) continue;
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            int neighborX = this.field_145851_c + dir.offsetX;
            int neighborY = this.field_145848_d + dir.offsetY;
            int neighborZ = this.field_145849_e + dir.offsetZ;
            if (this.field_145850_b.func_147439_a(neighborX, neighborY, neighborZ).func_149662_c()) continue;
            TileEntity te = this.field_145850_b.func_147438_o(neighborX += fromFace.offsetX, neighborY += fromFace.offsetY, neighborZ += fromFace.offsetZ);
            corners[i] = te instanceof ISignalBusConnectable && ((ISignalBusConnectable)te).connectableOnCorner(fromFace.getOpposite(), dir.getOpposite());
        }
        return corners;
    }

    @Override
    public boolean connectableOnCorner(ForgeDirection side, ForgeDirection turn) {
        return !this.placedSides[side.ordinal()] && this.placedSides[turn.ordinal()];
    }

    @Override
    public boolean willConnect(CoordTuple coord) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection iDir = ForgeDirection.VALID_DIRECTIONS[i];
            if (!this.placedSides[i]) continue;
            for (int j = 0; j < 6; ++j) {
                TileEntity te;
                if (this.placedSides[j] || j == i || j == iDir.getOpposite().ordinal()) continue;
                ForgeDirection jDir = ForgeDirection.VALID_DIRECTIONS[j];
                if (this.field_145851_c + jDir.offsetX == coord.x && this.field_145848_d + jDir.offsetY == coord.y && this.field_145849_e + jDir.offsetZ == coord.z && (te = this.field_145850_b.func_147438_o(this.field_145851_c + jDir.offsetX, this.field_145848_d + jDir.offsetY, this.field_145849_e + jDir.offsetZ)) instanceof ISignalBusConnectable && ((ISignalBusConnectable)te).connectableOnFace(iDir)) {
                    return true;
                }
                if (this.field_145850_b.func_147439_a(this.field_145851_c + jDir.offsetX, this.field_145848_d + jDir.offsetY, this.field_145849_e + jDir.offsetZ).func_149662_c() || this.field_145851_c + iDir.offsetX + jDir.offsetX != coord.x || this.field_145848_d + iDir.offsetY + jDir.offsetY != coord.y || this.field_145849_e + iDir.offsetZ + jDir.offsetZ != coord.z || !((te = this.field_145850_b.func_147438_o(this.field_145851_c + iDir.offsetX + jDir.offsetX, this.field_145848_d + iDir.offsetY + jDir.offsetY, this.field_145849_e + iDir.offsetZ + jDir.offsetZ)) instanceof ISignalBusConnectable) || !((ISignalBusConnectable)te).connectableOnCorner(iDir.getOpposite(), jDir.getOpposite())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected CoordTuple[] getNeighborCoords() {
        LinkedList<CoordTuple> cornerCoords = new LinkedList<CoordTuple>();
        for (int i = 0; i < 6; ++i) {
            if (!this.placedSides[i]) continue;
            ForgeDirection iDir = ForgeDirection.VALID_DIRECTIONS[i];
            for (int j = 0; j < 6; ++j) {
                if (this.placedSides[j] || j == i || j == iDir.getOpposite().ordinal()) continue;
                ForgeDirection jDir = ForgeDirection.VALID_DIRECTIONS[j];
                if (this.field_145850_b.func_147439_a(this.field_145851_c + jDir.offsetX, this.field_145848_d + jDir.offsetY, this.field_145849_e + jDir.offsetZ).func_149662_c()) continue;
                cornerCoords.add(new CoordTuple((double)(this.field_145851_c + iDir.offsetX + jDir.offsetX), (double)(this.field_145848_d + iDir.offsetY + jDir.offsetY), (double)(this.field_145849_e + iDir.offsetZ + jDir.offsetZ)));
            }
        }
        cornerCoords.addAll(Arrays.asList(super.getNeighborCoords()));
        CoordTuple[] tmp = new CoordTuple[cornerCoords.size()];
        return cornerCoords.toArray(tmp);
    }

    public void forceNeighborCheck() {
        this.forceCheck = true;
    }

    public int getDroppedBuses() {
        int calc = 0;
        for (int i = 0; i < 6; ++i) {
            if (!this.placedSides[i]) continue;
            ++calc;
        }
        return calc;
    }

    public int getDroppedWire() {
        int calc = 0;
        for (CoordTuple coord : this.transceivers.keySet()) {
            TileEntity te = this.field_145850_b.func_147438_o(coord.x, coord.y, coord.z);
            if (!(te instanceof ISignalTransceiver)) continue;
            calc += ((ISignalTransceiver)te).getDroppedWire();
        }
        return calc;
    }

    public void notifyBreak() {
        CoordTuple[] scan = new CoordTuple[this.transceivers.keySet().size()];
        for (CoordTuple coord : scan = this.transceivers.keySet().toArray(scan)) {
            TileEntity te = this.field_145850_b.func_147438_o(coord.x, coord.y, coord.z);
            if (!(te instanceof ISignalTransceiver)) continue;
            ((ISignalTransceiver)te).doUnregister(true);
        }
        this.destroySelf();
    }

    public boolean canPlaceOnSide(int side) {
        for (int i = 0; i < 6; ++i) {
            if (i == side || i == ForgeDirection.OPPOSITES[side] || !this.placedSides[i]) continue;
            return true;
        }
        return false;
    }

    public int checkUnsupportedSides() {
        int dropCount = 0;
        for (int i = 0; i < 6; ++i) {
            if (!this.placedSides[i]) continue;
            ForgeDirection iDir = ForgeDirection.VALID_DIRECTIONS[i];
            ForgeDirection sDir = ForgeDirection.VALID_DIRECTIONS[i].getOpposite();
            if (sDir == ForgeDirection.NORTH || sDir == ForgeDirection.SOUTH) {
                sDir = sDir.getOpposite();
            }
            if (this.field_145850_b.isSideSolid(this.field_145851_c + iDir.offsetX, this.field_145848_d + iDir.offsetY, this.field_145849_e + iDir.offsetZ, iDir.getOpposite())) continue;
            this.placedSides[i] = false;
            ++dropCount;
        }
        return dropCount;
    }

    public boolean checkShouldDestroy() {
        for (int i = 0; i < 6; ++i) {
            if (!this.placedSides[i]) continue;
            return false;
        }
        return true;
    }

    public World func_145831_w() {
        return this.world;
    }
}

