/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tileEntity;

import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentContainer;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentStack;
import WayofTime.alchemicalWizardry.api.items.interfaces.IBloodOrb;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import WayofTime.alchemicalWizardry.common.tileEntity.TEReagentConduit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TEAlchemicCalcinator
extends TEReagentConduit
implements IInventory {
    protected ItemStack[] inv;
    protected ReagentContainer bufferTank = new ReagentContainer(2000);
    protected int bufferTransferRate = 20;
    private int lpPerTick = 10;
    private int ticksPerReagent = 200;
    public int progress;

    public TEAlchemicCalcinator() {
        super(1, 4000);
        this.inv = new ItemStack[2];
        this.tickRate = 20;
        this.maxConnextions = 1;
        this.progress = 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.bufferTransferRate = tag.func_74762_e("bufferTransferRate");
        this.progress = tag.func_74762_e("progress");
        NBTTagCompound bufferTankTag = tag.func_74775_l("bufferTank");
        this.bufferTank = ReagentContainer.readFromNBT(bufferTankTag);
        NBTTagList tagList = tag.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound savedTag = tagList.func_150305_b(i);
            this.inv[i] = savedTag.func_74767_n("Empty") ? null : ItemStack.func_77949_a((NBTTagCompound)savedTag);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("bufferTransferRate", this.bufferTransferRate);
        tag.func_74768_a("progress", this.progress);
        NBTTagCompound bufferTankTag = new NBTTagCompound();
        this.bufferTank.writeToNBT(bufferTankTag);
        tag.func_74782_a("bufferTank", (NBTBase)bufferTankTag);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack stack = this.inv[i];
            NBTTagCompound savedTag = new NBTTagCompound();
            if (this.inv[i] != null) {
                this.inv[i].func_77955_b(savedTag);
            } else {
                savedTag.func_74757_a("Empty", true);
            }
            itemList.func_74742_a((NBTBase)savedTag);
        }
        tag.func_74782_a("Inventory", (NBTBase)itemList);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.moveBufferToMain();
            this.tickProgress();
        }
    }

    public void moveBufferToMain() {
        ReagentStack amountStack = this.bufferTank.drain(this.bufferTransferRate, false);
        int drainAmount = this.fill(ForgeDirection.UNKNOWN, amountStack, false);
        if (drainAmount > 0) {
            ReagentStack drainedStack = this.bufferTank.drain(drainAmount, true);
            this.fill(ForgeDirection.UNKNOWN, drainedStack, true);
        }
    }

    public void tickProgress() {
        ItemStack reagentItemStack = this.func_70301_a(1);
        if (reagentItemStack == null) {
            this.progress = 0;
            return;
        }
        ReagentStack possibleReagent = ReagentRegistry.getReagentStackForItem(reagentItemStack);
        if (possibleReagent == null || !this.canReagentFitBuffer(possibleReagent)) {
            return;
        }
        ItemStack orbStack = this.func_70301_a(0);
        if (orbStack == null || !(orbStack.func_77973_b() instanceof IBloodOrb)) {
            return;
        }
        if (!SoulNetworkHandler.canSyphonFromOnlyNetwork(orbStack, this.lpPerTick)) {
            SoulNetworkHandler.causeNauseaToPlayer(orbStack);
            return;
        }
        if (!SoulNetworkHandler.syphonFromNetworkWhileInContainer(orbStack, this.lpPerTick)) {
            return;
        }
        ++this.progress;
        if (this.field_145850_b.func_72820_D() % 4L == 0L) {
            SpellHelper.sendIndexedParticleToAllAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 20, this.field_145850_b.field_73011_w.field_76574_g, 1, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.progress >= this.ticksPerReagent) {
            this.progress = 0;
            this.bufferTank.fill(possibleReagent, true);
            this.func_70298_a(1, 1);
        }
    }

    public boolean canReagentFitBuffer(ReagentStack stack) {
        int amount = this.bufferTank.fill(stack, false);
        return amount >= stack.amount;
    }

    @Override
    public void readClientNBT(NBTTagCompound tag) {
        super.readClientNBT(tag);
        NBTTagList tagList = tag.func_150295_c("reagentTanks", 10);
        int size = tagList.func_74745_c();
        this.tanks = new ReagentContainer[size];
        for (int i = 0; i < size; ++i) {
            NBTTagCompound savedTag = tagList.func_150305_b(i);
            this.tanks[i] = ReagentContainer.readFromNBT(savedTag);
        }
        NBTTagList invTagList = tag.func_150295_c("Inventory", 10);
        for (int i = 0; i < invTagList.func_74745_c(); ++i) {
            NBTTagCompound savedTag = invTagList.func_150305_b(i);
            this.inv[i] = savedTag.func_74767_n("Empty") ? null : ItemStack.func_77949_a((NBTTagCompound)savedTag);
        }
    }

    @Override
    public void writeClientNBT(NBTTagCompound tag) {
        super.writeClientNBT(tag);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.tanks.length; ++i) {
            NBTTagCompound savedTag = new NBTTagCompound();
            if (this.tanks[i] != null) {
                this.tanks[i].writeToNBT(savedTag);
            }
            tagList.func_74742_a((NBTBase)savedTag);
        }
        tag.func_74782_a("reagentTanks", (NBTBase)tagList);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack stack = this.inv[i];
            NBTTagCompound savedTag = new NBTTagCompound();
            if (this.inv[i] != null) {
                this.inv[i].func_77955_b(savedTag);
            } else {
                savedTag.func_74757_a("Empty", true);
            }
            itemList.func_74742_a((NBTBase)savedTag);
        }
        tag.func_74782_a("Inventory", (NBTBase)itemList);
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeClientNBT(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -999, nbttagcompound);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.readClientNBT(packet.func_148857_g());
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv[slot];
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amt) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amt);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public String func_145825_b() {
        return "AlchemicCalcinator";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return true;
    }

    @Override
    public int fill(ForgeDirection from, ReagentStack resource, boolean doFill) {
        if (doFill && !this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return super.fill(from, resource, doFill);
    }
}

