/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.api.alchemy.energy.IAlchemyGoggles;
import WayofTime.alchemicalWizardry.api.items.interfaces.ArmourUpgrade;
import WayofTime.alchemicalWizardry.api.items.interfaces.IBindable;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.items.ILPGauge;
import WayofTime.alchemicalWizardry.common.items.sigil.DivinationSigil;
import WayofTime.alchemicalWizardry.common.renderer.model.ModelOmegaArmour;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import thaumcraft.api.IGoggles;
import thaumcraft.api.IRunicArmor;
import thaumcraft.api.nodes.IRevealer;

@Optional.InterfaceList(value={@Optional.Interface(iface="thaumcraft.api.nodes.IRevealer", modid="Thaumcraft"), @Optional.Interface(iface="thaumcraft.api.IGoggles", modid="Thaumcraft"), @Optional.Interface(iface="thaumcraft.api.IRunicArmor", modid="Thaumcraft")})
public class BoundArmour
extends ItemArmor
implements IAlchemyGoggles,
ISpecialArmor,
IBindable,
IRevealer,
IGoggles,
IRunicArmor,
ILPGauge {
    private static int invSize = 9;
    private static IIcon helmetIcon;
    private static IIcon plateIcon;
    private static IIcon leggingsIcon;
    private static IIcon bootsIcon;
    public static boolean tryComplexRendering;
    ModelBiped model1 = null;
    ModelBiped model2 = null;
    ModelBiped model = null;

    public BoundArmour(int armorType) {
        super(ItemArmor.ArmorMaterial.GOLD, 0, armorType);
        this.func_77656_e(1000);
        this.func_77637_a(AlchemicalWizardry.tabBloodMagic);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        if (tryComplexRendering) {
            int type = ((ItemArmor)itemStack.func_77973_b()).field_77881_a;
            if (this.model1 == null) {
                this.model1 = new ModelOmegaArmour(1.0f, true, true, false, true);
            }
            if (this.model2 == null) {
                this.model2 = new ModelOmegaArmour(0.5f, false, false, true, false);
            }
            this.model = type == 1 || type == 3 || type == 0 ? this.model1 : this.model2;
            if (this.model != null) {
                this.model.field_78116_c.field_78806_j = type == 0;
                this.model.field_78114_d.field_78806_j = type == 0;
                this.model.field_78115_e.field_78806_j = type == 1 || type == 2;
                this.model.field_78113_g.field_78806_j = type == 1;
                this.model.field_78112_f.field_78806_j = type == 1;
                this.model.field_78124_i.field_78806_j = type == 2 || type == 3;
                this.model.field_78123_h.field_78806_j = type == 2 || type == 3;
                this.model.field_78117_n = entityLiving.func_70093_af();
                this.model.field_78093_q = entityLiving.func_70115_ae();
                this.model.field_78091_s = entityLiving.func_70631_g_();
                this.model.field_78118_o = false;
                int n = this.model.field_78120_m = entityLiving.func_70694_bm() != null ? 1 : 0;
                if (entityLiving instanceof EntityPlayer && ((EntityPlayer)entityLiving).func_71057_bx() > 0) {
                    EnumAction enumaction = ((EntityPlayer)entityLiving).func_71011_bu().func_77975_n();
                    if (enumaction == EnumAction.block) {
                        this.model.field_78120_m = 3;
                    } else if (enumaction == EnumAction.bow) {
                        this.model.field_78118_o = true;
                    }
                }
            }
            return this.model;
        }
        return super.getArmorModel(entityLiving, itemStack, armorSlot);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("AlchemicalWizardry:SheathedItem");
        helmetIcon = iconRegister.func_94245_a("AlchemicalWizardry:BoundHelmet");
        plateIcon = iconRegister.func_94245_a("AlchemicalWizardry:BoundPlate");
        leggingsIcon = iconRegister.func_94245_a("AlchemicalWizardry:BoundLeggings");
        bootsIcon = iconRegister.func_94245_a("AlchemicalWizardry:BoundBoots");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        if (this.equals(ModItems.boundHelmet)) {
            return helmetIcon;
        }
        if (this.equals(ModItems.boundPlate)) {
            return plateIcon;
        }
        if (this.equals(ModItems.boundLeggings)) {
            return leggingsIcon;
        }
        if (this.equals(ModItems.boundBoots)) {
            return bootsIcon;
        }
        return this.field_77791_bV;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        double armourReduction = 0.0;
        int f = 0;
        int h = 0;
        if (player.func_70644_a(AlchemicalWizardry.customPotionSoulFray)) {
            f = player.func_70660_b(AlchemicalWizardry.customPotionSoulFray).func_76458_c() + 1;
        }
        double damageAmount = 0.25;
        if (player.func_70644_a(AlchemicalWizardry.customPotionSoulHarden)) {
            h = player.func_70660_b(AlchemicalWizardry.customPotionSoulHarden).func_76458_c() + 1;
        }
        armourReduction = 1.0 - 0.1 * Math.pow(0.3333333333333333, Math.max(0, h - f)) - 0.1 * (double)Math.max(0, f - h);
        damageAmount *= armourReduction;
        int maxAbsorption = 100000;
        if (source.equals(DamageSource.field_76369_e)) {
            return new ISpecialArmor.ArmorProperties(-1, 0.0, 0);
        }
        if (source.equals(DamageSource.field_76380_i)) {
            if (this.isImmuneToVoid(armor)) {
                return new ISpecialArmor.ArmorProperties(-1, damageAmount * 1000.0, maxAbsorption);
            }
            return new ISpecialArmor.ArmorProperties(-1, 0.0, 0);
        }
        ItemStack helmet = player.func_71124_b(4);
        ItemStack plate = player.func_71124_b(3);
        ItemStack leggings = player.func_71124_b(2);
        ItemStack boots = player.func_71124_b(1);
        if (helmet == null || plate == null || leggings == null || boots == null) {
            return new ISpecialArmor.ArmorProperties(-1, 0.0, 0);
        }
        if (helmet.func_77973_b().equals(ModItems.boundHelmet) && plate.func_77973_b().equals(ModItems.boundPlate) && leggings.func_77973_b().equals(ModItems.boundLeggings) && boots.func_77973_b().equals(ModItems.boundBoots)) {
            if (source.func_76363_c()) {
                return new ISpecialArmor.ArmorProperties(-1, damageAmount * 0.9, maxAbsorption);
            }
            return new ISpecialArmor.ArmorProperties(-1, damageAmount, maxAbsorption);
        }
        return new ISpecialArmor.ArmorProperties(-1, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        if (armor.equals(ModItems.boundHelmet)) {
            return 3;
        }
        if (armor.equals(ModItems.boundPlate)) {
            return 8;
        }
        if (armor.equals(ModItems.boundLeggings)) {
            return 6;
        }
        if (armor.equals(ModItems.boundBoots)) {
            return 3;
        }
        return 5;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (entity instanceof EntityPlayer) {
            EnergyItems.checkAndSetItemOwner(stack, (EntityPlayer)entity);
            if (((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                return;
            }
        }
        stack.func_77964_b(stack.func_77960_j() + damage);
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add("Devilish Protection");
        if (par1ItemStack.field_77990_d != null) {
            ItemStack[] inv;
            if (!par1ItemStack.field_77990_d.func_74779_i("ownerName").equals("")) {
                par3List.add("Current owner: " + par1ItemStack.field_77990_d.func_74779_i("ownerName"));
            }
            if ((inv = this.getInternalInventory(par1ItemStack)) == null) {
                return;
            }
            for (int i = 0; i < invSize; ++i) {
                if (inv[i] == null) continue;
                par3List.add("Item in slot " + i + ": " + inv[i].func_82833_r());
            }
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (tryComplexRendering) {
            return "alchemicalwizardry:models/armor/BloodArmour_WIP.png";
        }
        if (entity instanceof EntityLivingBase && this.getIsInvisible(stack)) {
            if (this == ModItems.boundHelmet || this == ModItems.boundPlate || this == ModItems.boundBoots) {
                return "alchemicalwizardry:models/armor/boundArmour_invisible_layer_1.png";
            }
            if (this == ModItems.boundLeggings) {
                return "alchemicalwizardry:models/armor/boundArmour_invisible_layer_2.png";
            }
        }
        if (this == ModItems.boundHelmet || this == ModItems.boundPlate || this == ModItems.boundBoots) {
            return "alchemicalwizardry:models/armor/boundArmour_layer_1.png";
        }
        if (this == ModItems.boundLeggings) {
            return "alchemicalwizardry:models/armor/boundArmour_layer_2.png";
        }
        return null;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer);
        return super.func_77659_a(par1ItemStack, par2World, par3EntityPlayer);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        int maxBloodLevel = this.getMaxBloodShardLevel(itemStack);
        ItemStack[] inv = this.getInternalInventory(itemStack);
        if (inv != null) {
            boolean iSize = false;
            boolean iBlood = false;
        }
        if (!player.func_70644_a(AlchemicalWizardry.customPotionInhibit)) {
            this.tickInternalInventory(itemStack, world, player, 0, false);
        }
        this.setIsInvisible(itemStack, player.func_82165_m(Potion.field_76441_p.field_76415_H));
        if (itemStack.func_77960_j() > 0) {
            EnergyItems.checkAndSetItemOwner(itemStack, player);
            if (!player.field_71075_bZ.field_75098_d && EnergyItems.syphonBatteries(itemStack, player, itemStack.func_77960_j() * 75)) {
                itemStack.func_77964_b(0);
            }
        }
    }

    public void tickInternalInventory(ItemStack par1ItemStack, World par2World, EntityPlayer par3Entity, int par4, boolean par5) {
        ItemStack[] inv = this.getInternalInventory(par1ItemStack);
        if (inv == null) {
            return;
        }
        int blood = this.getMaxBloodShardLevel(par1ItemStack);
        for (int i = 0; i < invSize; ++i) {
            if (inv[i] == null || !(inv[i].func_77973_b() instanceof ArmourUpgrade) || blood <= 0) continue;
            if (((ArmourUpgrade)inv[i].func_77973_b()).isUpgrade()) {
                ((ArmourUpgrade)inv[i].func_77973_b()).onArmourUpdate(par2World, par3Entity, inv[i]);
                --blood;
            }
            if (par2World.func_72820_D() % 200L != 0L || !(this.getUpgradeCostMultiplier(par1ItemStack) > 0.02f)) continue;
            EnergyItems.syphonBatteries(par1ItemStack, par3Entity, (int)((float)((ArmourUpgrade)inv[i].func_77973_b()).getEnergyForTenSeconds() * this.getUpgradeCostMultiplier(par1ItemStack)));
        }
    }

    public int getMaxBloodShardLevel(ItemStack armourStack) {
        ItemStack[] inv = this.getInternalInventory(armourStack);
        if (inv == null) {
            return 0;
        }
        int max = 0;
        for (int i = 0; i < invSize; ++i) {
            ItemStack itemStack = inv[i];
            if (itemStack == null) continue;
            if (itemStack.func_77973_b().equals(ModItems.weakBloodShard)) {
                max = Math.max(max, 1);
            }
            if (!itemStack.func_77973_b().equals(ModItems.demonBloodShard)) continue;
            max = Math.max(max, 2);
        }
        return max;
    }

    public boolean hasAddedToInventory(ItemStack sigilItemStack, ItemStack addedItemStack) {
        ItemStack[] inv = this.getInternalInventory(sigilItemStack);
        if (inv == null) {
            return false;
        }
        if (addedItemStack == null) {
            return false;
        }
        Item item = addedItemStack.func_77973_b();
        int candidateSlot = -1;
        for (int i = invSize - 1; i >= 0; --i) {
            ItemStack nextItem = inv[i];
            if (nextItem != null) continue;
            candidateSlot = i;
        }
        if (candidateSlot == -1) {
            return false;
        }
        if (addedItemStack.func_77973_b() instanceof ArmourUpgrade) {
            inv[candidateSlot] = addedItemStack;
            this.saveInternalInventory(sigilItemStack, inv);
            return true;
        }
        return false;
    }

    public ItemStack[] getInternalInventory(ItemStack itemStack) {
        NBTTagCompound itemTag = itemStack.field_77990_d;
        if (itemTag == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemTag = itemStack.field_77990_d;
        ItemStack[] inv = new ItemStack[9];
        NBTTagList tagList = itemTag.func_150295_c("Inventory", 10);
        if (tagList == null) {
            return null;
        }
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= invSize) continue;
            inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        return inv;
    }

    public void saveInternalInventory(ItemStack itemStack, ItemStack[] inventory) {
        NBTTagCompound itemTag = itemStack.field_77990_d;
        if (itemTag == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < invSize; ++i) {
            ItemStack stack = inventory[i];
            if (inventory[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            inventory[i].func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        itemTag.func_74782_a("Inventory", (NBTBase)itemList);
    }

    public boolean isImmuneToVoid(ItemStack itemStack) {
        ItemStack[] inv = this.getInternalInventory(itemStack);
        if (inv == null) {
            return false;
        }
        for (ItemStack item : inv) {
            if (item == null || !item.func_77973_b().equals(ModItems.voidSigil)) continue;
            return true;
        }
        return false;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean hasIRevealer(ItemStack itemStack) {
        ItemStack[] inv = this.getInternalInventory(itemStack);
        if (inv == null) {
            return false;
        }
        for (ItemStack item : inv) {
            if (item == null || !(item.func_77973_b() instanceof IRevealer)) continue;
            return true;
        }
        return false;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean hasIGoggles(ItemStack itemStack) {
        ItemStack[] inv = this.getInternalInventory(itemStack);
        if (inv == null) {
            return false;
        }
        int blood = this.getMaxBloodShardLevel(itemStack);
        for (ItemStack item : inv) {
            if (item == null || !(item.func_77973_b() instanceof ArmourUpgrade) || blood <= 0) continue;
            if (item.func_77973_b() instanceof IGoggles) {
                return true;
            }
            if (!((ArmourUpgrade)item.func_77973_b()).isUpgrade()) continue;
            --blood;
        }
        return false;
    }

    @Override
    public boolean canSeeLPBar(ItemStack itemStack) {
        ItemStack[] inv = this.getInternalInventory(itemStack);
        if (inv == null) {
            return false;
        }
        int blood = this.getMaxBloodShardLevel(itemStack);
        for (ItemStack item : inv) {
            if (item == null || !(item.func_77973_b() instanceof ArmourUpgrade) || blood <= 0) continue;
            if (item.func_77973_b() instanceof DivinationSigil) {
                return true;
            }
            if (!((ArmourUpgrade)item.func_77973_b()).isUpgrade()) continue;
            --blood;
        }
        return false;
    }

    public float getUpgradeCostMultiplier(ItemStack itemStack) {
        ItemStack[] inv = this.getInternalInventory(itemStack);
        if (inv == null) {
            return 1.0f;
        }
        for (ItemStack item : inv) {
            if (item == null) continue;
            if (item.func_77973_b().equals(ModItems.weakBloodOrb)) {
                return 0.75f;
            }
            if (item.func_77973_b().equals(ModItems.apprenticeBloodOrb)) {
                return 0.5f;
            }
            if (item.func_77973_b().equals(ModItems.magicianBloodOrb)) {
                return 0.25f;
            }
            if (item.func_77973_b().equals(ModItems.masterBloodOrb)) {
                return 0.0f;
            }
            if (!item.func_77973_b().equals(ModItems.archmageBloodOrb)) continue;
            return 0.0f;
        }
        return 1.0f;
    }

    public int func_77619_b() {
        return Integer.MIN_VALUE;
    }

    public boolean getIsInvisible(ItemStack armourStack) {
        NBTTagCompound tag = armourStack.func_77978_p();
        if (tag != null) {
            return tag.func_74767_n("invisible");
        }
        return false;
    }

    public void setIsInvisible(ItemStack armourStack, boolean invisible) {
        NBTTagCompound tag = armourStack.func_77978_p();
        if (tag == null) {
            armourStack.func_77982_d(new NBTTagCompound());
            tag = armourStack.func_77978_p();
        }
        tag.func_74757_a("invisible", invisible);
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean showNodes(ItemStack itemstack, EntityLivingBase player) {
        return this.hasIRevealer(itemstack);
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean showIngamePopups(ItemStack itemstack, EntityLivingBase player) {
        return this.hasIGoggles(itemstack);
    }

    @Optional.Method(modid="Thaumcraft")
    public int getRunicCharge(ItemStack itemstack) {
        ItemStack[] inv = this.getInternalInventory(itemstack);
        int shardLevel = this.getMaxBloodShardLevel(itemstack);
        int count = 0;
        int harden = 0;
        if (inv == null) {
            return 0;
        }
        for (ItemStack stack : inv) {
            if (count >= shardLevel) break;
            if (stack == null || !(stack.func_77973_b() instanceof ArmourUpgrade) || stack.func_77973_b() instanceof ItemArmor && ((ItemArmor)stack.func_77973_b()).field_77881_a != this.field_77881_a || !stack.func_77942_o()) continue;
            NBTTagCompound tag = stack.func_77978_p();
            int enchLvl = tag.func_74771_c("RS.HARDEN");
            if (stack.func_77973_b() instanceof IRunicArmor) {
                enchLvl += ((IRunicArmor)stack.func_77973_b()).getRunicCharge(stack);
            }
            if (enchLvl <= 0) continue;
            harden += enchLvl;
            if (!((ArmourUpgrade)stack.func_77973_b()).isUpgrade()) continue;
            ++count;
        }
        return harden;
    }

    @Override
    public boolean showIngameHUD(World world, ItemStack stack, EntityPlayer player) {
        ItemStack[] inv = this.getInternalInventory(stack);
        if (inv == null) {
            return false;
        }
        for (ItemStack item : inv) {
            if (item == null || !item.func_77973_b().equals(ModItems.itemSeerSigil)) continue;
            return true;
        }
        return false;
    }

    static {
        tryComplexRendering = true;
    }
}

