/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.book.entries;

import WayofTime.alchemicalWizardry.api.altarRecipeRegistry.AltarRecipe;
import WayofTime.alchemicalWizardry.book.classes.guide.GuiEntry;
import WayofTime.alchemicalWizardry.book.entries.IEntry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class EntryAltarRecipe
implements IEntry {
    public AltarRecipe recipes;
    public ItemStack input;
    public ItemStack output;
    public int essence;
    public ArrayList<ItemIcon> icons = new ArrayList();

    public EntryAltarRecipe(AltarRecipe recipes) {
        this.recipes = recipes;
        this.populate(recipes);
    }

    public void populate(AltarRecipe recipe) {
        this.input = recipe.requiredItem;
        this.output = recipe.result;
        this.essence = recipe.liquidRequired;
    }

    @Override
    public void draw(GuiEntry entry, int width, int height, int left, int top, EntityPlayer player, String key, int page, int mX, int mY) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74520_c();
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2929);
        this.renderOverlay(entry, width, height, left, top);
        int x = left + width / 2 - 20;
        int y = height / 2 - 36 + 18;
        this.drawIcon(this.input, x, y);
        x = left + width / 2 - -36;
        y = height / 2 - 36 + 18;
        this.drawIcon(this.output, x, y);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
        for (ItemIcon icon : this.icons) {
            if (icon.stack == null) continue;
            icon.onMouseBetween(mX, mY);
        }
    }

    public void drawIcon(ItemStack stack, int x, int y) {
        RenderItem ri = new RenderItem();
        ri.func_82406_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), stack, x, y);
        ri.func_77021_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), stack, x, y);
        this.icons.add(new ItemIcon(stack, x, y));
    }

    public void renderOverlay(GuiEntry entry, int width, int height, int left, int top) {
        TextureManager tm = Minecraft.func_71410_x().func_110434_K();
        tm.func_110577_a(new ResourceLocation("bloodutils:textures/gui/altar.png"));
        entry.func_73729_b(left, height / 2 - 36 + 0 - 17, 0, 0, width, height);
    }

    @Override
    public void initGui(int width, int height, int left, int top, EntityPlayer player, List buttonList) {
    }

    @Override
    public void actionPerformed(GuiButton button) {
    }

    static class ItemIcon {
        public ItemStack stack;
        public int x;
        public int y;

        public ItemIcon(ItemStack stack, int x, int y) {
            this.stack = stack;
            this.x = x;
            this.y = y;
        }

        public void onMouseBetween(int mX, int mY) {
            int xSize = this.x + 16;
            int ySize = this.y + 16;
            if (mX > this.x && mX < xSize && mY > this.y && mY < ySize) {
                GL11.glDisable((int)2929);
                if (this.stack != null && this.stack.func_82833_r() != null) {
                    Minecraft.func_71410_x().field_71466_p.func_78276_b(this.stack.func_82833_r(), mX + 6, mY, new Color(139, 137, 137).getRGB());
                }
                GL11.glEnable((int)2929);
            }
        }
    }
}

