/*
 * Decompiled with CFR 0.152.
 */
package cofh.mod.updater;

import cofh.mod.updater.ModVersion;
import cpw.mods.fml.common.versioning.ArtifactVersion;

public class ReleaseVersion
implements ArtifactVersion {
    private final String _label;
    private final int _major;
    private final int _minor;
    private final int _patch;
    private final int _rc;
    private final int _beta;

    public ReleaseVersion(String string, int n, int n2, int n3) {
        this(string, n, n2, n3, 0, 0);
    }

    public ReleaseVersion(String string, int n, int n2, int n3, int n4, int n5) {
        this._label = string;
        this._major = n;
        this._minor = n2;
        this._patch = n3;
        this._rc = n4;
        this._beta = n5;
    }

    public ReleaseVersion(String string, String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        String string3 = string2;
        String[] stringArray = string3.split("RC");
        if (stringArray.length > 1) {
            n4 = Integer.parseInt(stringArray[1]);
            string3 = stringArray[0];
        }
        if ((stringArray = string3.split("B")).length > 1) {
            n5 = Integer.parseInt(stringArray[1]);
            string3 = stringArray[0];
        }
        stringArray = string3.split("\\.");
        switch (stringArray.length) {
            default: {
                n3 = Integer.parseInt(stringArray[2]);
            }
            case 2: {
                n2 = Integer.parseInt(stringArray[1]);
            }
            case 1: {
                n = Integer.parseInt(stringArray[0]);
            }
            case 0: 
        }
        this._label = string;
        this._major = n;
        this._minor = n2;
        this._patch = n3;
        this._rc = n4;
        this._beta = n5;
    }

    public static ReleaseVersion parse(String string, String string2) {
        return new ReleaseVersion(string, string2);
    }

    public int major() {
        return this._major;
    }

    public int minor() {
        return this._minor;
    }

    public int patch() {
        return this._patch;
    }

    public int rc() {
        return this._rc;
    }

    public int beta() {
        return this._beta;
    }

    public boolean isStable() {
        return this._rc == 0 & this._beta == 0;
    }

    public boolean isRC() {
        return this._rc > 0;
    }

    public boolean isBeta() {
        return this._beta > 0;
    }

    public int compareTo(ArtifactVersion artifactVersion) {
        if (artifactVersion instanceof ReleaseVersion) {
            return this.compareTo((ReleaseVersion)artifactVersion);
        }
        if (artifactVersion instanceof ModVersion) {
            ModVersion modVersion = (ModVersion)artifactVersion;
            if (this._label.equals(modVersion.getLabel())) {
                return this.compareTo(modVersion.modVersion());
            }
            if ("Minecraft".equals(this._label)) {
                return this.compareTo(modVersion.minecraftVersion());
            }
        }
        return 0;
    }

    public int compareTo(ReleaseVersion releaseVersion) {
        if (this.major() != releaseVersion.major()) {
            return this.major() < releaseVersion.major() ? -1 : 1;
        }
        if (this.minor() != releaseVersion.minor()) {
            return this.minor() < releaseVersion.minor() ? -1 : 1;
        }
        if (this.patch() != releaseVersion.patch()) {
            return this.patch() < releaseVersion.patch() ? -1 : 1;
        }
        if (this.isStable() && !releaseVersion.isStable()) {
            return 1;
        }
        if (this.isRC() && releaseVersion.isBeta()) {
            return 1;
        }
        if (!this.isStable() && releaseVersion.isStable()) {
            return -1;
        }
        if (this.isBeta() && releaseVersion.isRC()) {
            return -1;
        }
        if (this.rc() != releaseVersion.rc()) {
            return this.rc() < releaseVersion.rc() ? -1 : 1;
        }
        if (this.beta() != releaseVersion.beta()) {
            return this.beta() < releaseVersion.beta() ? -1 : 1;
        }
        return 0;
    }

    public String toString() {
        return this._label + " " + this.getVersionString();
    }

    public String getVersionString() {
        String string = this._major + "." + this._minor + "." + this._patch;
        if (this._rc != 0) {
            string = string + "RC" + this._rc;
        }
        if (this._beta != 0) {
            string = string + "B" + this._beta;
        }
        return string;
    }

    public String getLabel() {
        return this._label;
    }

    public boolean containsVersion(ArtifactVersion artifactVersion) {
        return this.compareTo(artifactVersion) == 0;
    }

    public String getRangeString() {
        return null;
    }
}

