/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.entity;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2BPacketChangeGameState;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tconstruct.library.ActiveToolMod;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.weaponry.AmmoItem;
import tconstruct.util.Reference;
import tconstruct.weaponry.entity.ArrowEntity;

public abstract class ProjectileBase
extends EntityArrow
implements IEntityAdditionalSpawnData {
    public static final String woodSound = Reference.resource("woodHit");
    public static final String stoneSound = Reference.resource("stoneHit");
    public ItemStack returnStack;
    public boolean bounceOnNoDamage = true;
    public boolean defused = false;

    public ProjectileBase(World world) {
        super(world);
    }

    public ProjectileBase(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1, d2);
    }

    public ProjectileBase(World world, EntityPlayer player, float speed, float accuracy, ItemStack stack) {
        this(world);
        this.field_70250_c = player;
        this.field_70251_a = 1;
        this.func_70012_b(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, player.field_70177_z, player.field_70125_A);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, speed, accuracy);
        this.returnStack = stack;
    }

    public ItemStack getEntityItem() {
        return this.returnStack;
    }

    protected void playHitBlockSound(int x, int y, int z) {
        Block block = this.field_70170_p.func_147439_a(x, y, z);
        if (block != null && block.field_149764_J == Material.field_151575_d) {
            this.field_70170_p.func_72956_a((Entity)this, woodSound, 1.0f, 1.0f);
        } else {
            this.field_70170_p.func_72956_a((Entity)this, stoneSound, 1.0f, 1.0f);
        }
        if (block != null) {
            this.field_70170_p.func_72956_a((Entity)this, block.field_149762_H.func_150495_a(), 0.7f, 1.0f);
        }
    }

    protected void playHitEntitySound() {
    }

    protected double getStuckDepth() {
        return 0.5;
    }

    protected void doLivingHit(EntityLivingBase entityHit) {
        double horizontalSpeed;
        float knockback = this.returnStack.func_77978_p().func_74775_l("InfiTool").func_74760_g("Knockback");
        if (this.field_70250_c instanceof EntityLivingBase) {
            knockback += (float)EnchantmentHelper.func_77507_b((EntityLivingBase)((EntityLivingBase)this.field_70250_c), (EntityLivingBase)entityHit);
        }
        if (!this.field_70170_p.field_72995_K) {
            entityHit.func_85034_r(entityHit.func_85035_bI() + 1);
        }
        if (knockback > 0.0f && (horizontalSpeed = (double)MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0) {
            entityHit.func_70024_g(this.field_70159_w * (double)knockback * (double)0.6f / horizontalSpeed, 0.1, this.field_70179_y * (double)knockback * (double)0.6f / horizontalSpeed);
        }
        if (this.field_70250_c != null && this.field_70250_c instanceof EntityLivingBase) {
            EnchantmentHelper.func_151384_a((EntityLivingBase)entityHit, (Entity)this.field_70250_c);
            EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.field_70250_c), (Entity)entityHit);
        }
        if (this.field_70250_c != null && entityHit != this.field_70250_c && entityHit instanceof EntityPlayer && this.field_70250_c instanceof EntityPlayerMP) {
            ((EntityPlayerMP)this.field_70250_c).field_71135_a.func_147359_a((Packet)new S2BPacketChangeGameState(6, 0.0f));
        }
    }

    public void onHitBlock(MovingObjectPosition movingobjectposition) {
        this.field_145791_d = movingobjectposition.field_72311_b;
        this.field_145792_e = movingobjectposition.field_72312_c;
        this.field_145789_f = movingobjectposition.field_72309_d;
        this.field_145790_g = this.field_70170_p.func_147439_a(this.field_145791_d, this.field_145792_e, this.field_145789_f);
        this.field_70253_h = this.field_70170_p.func_72805_g(this.field_145791_d, this.field_145792_e, this.field_145789_f);
        this.field_70159_w = movingobjectposition.field_72307_f.field_72450_a - this.field_70165_t;
        this.field_70181_x = movingobjectposition.field_72307_f.field_72448_b - this.field_70163_u;
        this.field_70179_y = movingobjectposition.field_72307_f.field_72449_c - this.field_70161_v;
        double speed = this.getStuckDepth() * (double)MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        this.field_70165_t -= this.field_70159_w / speed * (double)0.05f;
        this.field_70163_u -= this.field_70181_x / speed * (double)0.05f;
        this.field_70161_v -= this.field_70179_y / speed * (double)0.05f;
        this.playHitBlockSound(movingobjectposition.field_72311_b, movingobjectposition.field_72312_c, movingobjectposition.field_72309_d);
        this.field_70254_i = true;
        this.field_70249_b = 7;
        this.func_70243_d(false);
        if (this.field_145790_g.func_149688_o() != Material.field_151579_a) {
            this.field_145790_g.func_149670_a(this.field_70170_p, this.field_145791_d, this.field_145792_e, this.field_145789_f, (Entity)this);
        }
    }

    public void onHitEntity(MovingObjectPosition movingobjectposition) {
        NBTTagCompound tags = this.returnStack.func_77978_p().func_74775_l("InfiTool");
        float speed = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        float distance = speed * (float)(this.field_70257_an - 1);
        float dist2 = 0.0f;
        dist2 += MathHelper.func_76135_e((float)((float)movingobjectposition.field_72308_g.field_70142_S - (float)this.field_70142_S));
        dist2 += MathHelper.func_76135_e((float)((float)movingobjectposition.field_72308_g.field_70137_T - (float)this.field_70137_T));
        dist2 += MathHelper.func_76135_e((float)((float)movingobjectposition.field_72308_g.field_70136_U - (float)this.field_70136_U));
        dist2 = MathHelper.func_76133_a((double)dist2);
        distance += dist2;
        if (!tags.func_74764_b("BaseAttack")) {
            int atk = tags.func_74762_e("Attack");
            if (tags.func_74764_b("ModAttack")) {
                int bonusDmg = tags.func_74759_k("ModAttack")[0] / 24 + 1;
                atk -= bonusDmg;
            }
            tags.func_74768_a("BaseAttack", atk);
        }
        float baseAttack = tags.func_74762_e("BaseAttack");
        float totalAttack = tags.func_74762_e("Attack");
        float damage = speed * baseAttack;
        damage += totalAttack - baseAttack;
        if (this instanceof ArrowEntity) {
            damage = Math.max(0.0f, damage - totalAttack / 2.0f);
        }
        boolean shotByPlayer = this.field_70250_c != null && this.field_70250_c instanceof EntityPlayer;
        ToolCore ammo = (ToolCore)this.returnStack.func_77973_b();
        int baseDamage = 0;
        if (shotByPlayer) {
            for (ActiveToolMod toolmod : TConstructRegistry.activeModifiers) {
                int dmg = toolmod.baseAttackDamage(baseDamage, (int)damage, ammo, this.returnStack.func_77978_p(), tags, this.returnStack, (EntityLivingBase)((EntityPlayer)this.field_70250_c), movingobjectposition.field_72308_g);
                if (dmg <= baseDamage) continue;
                baseDamage = dmg;
            }
        }
        damage += (float)baseDamage;
        damage *= ammo.getDamageModifier();
        float bonusDamage = -AbilityHelper.calcStoneboundBonus(ammo, tags);
        if (this.field_70250_c != null && movingobjectposition.field_72308_g instanceof EntityLivingBase) {
            bonusDamage += EnchantmentHelper.func_77512_a((EntityLivingBase)((EntityLivingBase)this.field_70250_c), (EntityLivingBase)((EntityLivingBase)movingobjectposition.field_72308_g));
        }
        if ((damage += bonusDamage) < 1.0f) {
            damage = 1.0f;
        }
        int modDamage = 0;
        if (shotByPlayer) {
            for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
                modDamage += mod.attackDamage(modDamage, (int)damage, ammo, this.returnStack.func_77978_p(), tags, this.returnStack, (EntityLivingBase)((EntityPlayer)this.field_70250_c), movingobjectposition.field_72308_g);
            }
        }
        damage += (float)modDamage;
        if (this.func_70241_g()) {
            damage += (this.field_70146_Z.nextFloat() / 4.0f + Math.min(0.75f, distance / 25.0f)) * (damage / 2.0f + 2.0f);
        }
        if (!this.dealDamage(damage, ammo, tags, movingobjectposition.field_72308_g)) {
            if (!this.bounceOnNoDamage) {
                this.func_70106_y();
            }
            this.field_70159_w *= (double)-0.1f;
            this.field_70181_x *= (double)-0.1f;
            this.field_70179_y *= (double)-0.1f;
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
            this.field_70257_an = 0;
            return;
        }
        AbilityHelper.processFiery(this.field_70250_c, movingobjectposition.field_72308_g, tags);
        if (movingobjectposition.field_72308_g instanceof EntityLivingBase) {
            this.doLivingHit((EntityLivingBase)movingobjectposition.field_72308_g);
        }
        this.playHitEntitySound();
        if (!(movingobjectposition.field_72308_g instanceof EntityEnderman)) {
            if (this.field_70146_Z.nextInt(10) + 1 > tags.func_74762_e("Reinforced")) {
                this.func_70106_y();
            } else {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                this.field_70257_an = 0;
            }
        }
    }

    public boolean dealDamage(float damage, ToolCore ammo, NBTTagCompound tags, Entity entityHit) {
        boolean dealtDamage = false;
        DamageSource damagesource = this.field_70250_c == null ? DamageSource.func_76353_a((EntityArrow)this, (Entity)this) : DamageSource.func_76353_a((EntityArrow)this, (Entity)this.field_70250_c);
        dealtDamage = entityHit.func_70097_a(damagesource, damage);
        return dealtDamage;
    }

    public void func_70016_h(double p_70016_1_, double p_70016_3_, double p_70016_5_) {
    }

    public void func_70071_h_() {
        Block block;
        this.func_70030_z();
        if (this.field_70249_b > 0) {
            --this.field_70249_b;
        }
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / Math.PI);
        }
        if ((block = this.field_70170_p.func_147439_a(this.field_145791_d, this.field_145792_e, this.field_145789_f)).func_149688_o() != Material.field_151579_a) {
            block.func_149719_a((IBlockAccess)this.field_70170_p, this.field_145791_d, this.field_145792_e, this.field_145789_f);
            AxisAlignedBB axisalignedbb = block.func_149668_a(this.field_70170_p, this.field_145791_d, this.field_145792_e, this.field_145789_f);
            if (axisalignedbb != null && axisalignedbb.func_72318_a(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v))) {
                this.field_70254_i = true;
            }
        }
        if (this.field_70254_i) {
            this.updateInGround();
        } else {
            this.updateInAir();
        }
    }

    protected void updateInGround() {
        Block block = this.field_70170_p.func_147439_a(this.field_145791_d, this.field_145792_e, this.field_145789_f);
        int j = this.field_70170_p.func_72805_g(this.field_145791_d, this.field_145792_e, this.field_145789_f);
        if (block == this.field_145790_g && j == this.field_70253_h) {
            ++this.field_70252_j;
            if (this.field_70252_j == 1200) {
                this.func_70106_y();
            }
        } else {
            this.field_70254_i = false;
            this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70252_j = 0;
            this.field_70257_an = 0;
        }
    }

    protected void updateInAir() {
        ++this.field_70257_an;
        Vec3 curPos = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        Vec3 newPos = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        MovingObjectPosition movingobjectposition = this.field_70170_p.func_147447_a(curPos, newPos, false, true, false);
        curPos = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        newPos = movingobjectposition != null ? Vec3.func_72443_a((double)movingobjectposition.field_72307_f.field_72450_a, (double)movingobjectposition.field_72307_f.field_72448_b, (double)movingobjectposition.field_72307_f.field_72449_c) : Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        if (!this.defused) {
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double distance = 0.0;
            for (Entity ent : list) {
                double otherDistance;
                float f1;
                AxisAlignedBB axisalignedbb1;
                MovingObjectPosition movingobjectposition1;
                if (!ent.func_70067_L() || ent == this.field_70250_c && this.field_70257_an < 5 || (movingobjectposition1 = (axisalignedbb1 = ent.field_70121_D.func_72314_b((double)(f1 = 0.3f), (double)f1, (double)f1)).func_72327_a(curPos, newPos)) == null || !((otherDistance = curPos.func_72438_d(movingobjectposition1.field_72307_f)) < distance) && distance != 0.0) continue;
                entity = ent;
                distance = otherDistance;
            }
            if (entity != null) {
                movingobjectposition = new MovingObjectPosition(entity);
            }
            if (movingobjectposition != null && movingobjectposition.field_72308_g != null && movingobjectposition.field_72308_g instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)movingobjectposition.field_72308_g;
                if (entityplayer.field_71075_bZ.field_75102_a || this.field_70250_c instanceof EntityPlayer && !((EntityPlayer)this.field_70250_c).func_96122_a(entityplayer)) {
                    movingobjectposition = null;
                }
            }
        }
        if (movingobjectposition != null) {
            if (movingobjectposition.field_72308_g != null) {
                this.onHitEntity(movingobjectposition);
            } else {
                this.onHitBlock(movingobjectposition);
            }
        }
        if (this.func_70241_g()) {
            this.drawCritParticles();
        }
        this.doMoveUpdate();
        double slowdown = 1.0 - this.getSlowdown();
        if (this.func_70090_H()) {
            for (int l = 0; l < 4; ++l) {
                float f4 = 0.25f;
                this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            slowdown = 1.0 - 20.0 * this.getSlowdown();
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        this.field_70159_w *= slowdown;
        this.field_70181_x *= slowdown;
        this.field_70179_y *= slowdown;
        this.field_70181_x -= this.getGravity();
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
    }

    public void drawCritParticles() {
        for (int i = 0; i < 4; ++i) {
            this.field_70170_p.func_72869_a("crit", this.field_70165_t + this.field_70159_w * (double)i / 4.0, this.field_70163_u + this.field_70181_x * (double)i / 4.0, this.field_70161_v + this.field_70179_y * (double)i / 4.0, -this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y);
        }
    }

    protected void doMoveUpdate() {
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        double f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f2) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
    }

    protected double getSlowdown() {
        return 0.01;
    }

    protected double getGravity() {
        return 0.05;
    }

    public void func_70100_b_(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && this.field_70254_i && this.field_70249_b <= 0) {
            boolean flag;
            boolean bl = flag = this.field_70251_a == 1 || this.field_70251_a == 2 && player.field_71075_bZ.field_75098_d;
            if (this.field_70251_a == 1) {
                if (this.returnStack != null && this.returnStack.func_77973_b() instanceof AmmoItem) {
                    if (!((AmmoItem)this.returnStack.func_77973_b()).pickupAmmo(this.returnStack, null, player)) {
                        flag = false;
                    }
                } else if (this.returnStack != null && !player.field_71071_by.func_70441_a(this.returnStack)) {
                    flag = false;
                }
            }
            if (flag) {
                this.func_85030_a("random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                player.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
        }
    }

    public void func_70014_b(NBTTagCompound tags) {
        super.func_70014_b(tags);
        tags.func_74782_a("Throwable", (NBTBase)this.returnStack.func_77955_b(new NBTTagCompound()));
        tags.func_74774_a("onGround", (byte)(this.field_70122_E ? 1 : 0));
    }

    public void func_70037_a(NBTTagCompound tags) {
        super.func_70037_a(tags);
        this.returnStack = ItemStack.func_77949_a((NBTTagCompound)tags.func_74775_l("Throwable"));
        this.field_70122_E = tags.func_74771_c("onGround") == 1;
    }

    public void writeSpawnData(ByteBuf data) {
        ByteBufUtils.writeItemStack((ByteBuf)data, (ItemStack)this.returnStack);
        data.writeFloat(this.field_70177_z);
        int id = this.field_70250_c == null ? this.func_145782_y() : this.field_70250_c.func_145782_y();
        data.writeInt(id);
        data.writeDouble(this.field_70159_w);
        data.writeDouble(this.field_70181_x);
        data.writeDouble(this.field_70179_y);
    }

    public void readSpawnData(ByteBuf data) {
        this.returnStack = ByteBufUtils.readItemStack((ByteBuf)data);
        this.field_70177_z = data.readFloat();
        this.field_70250_c = this.field_70170_p.func_73045_a(data.readInt());
        this.field_70159_w = data.readDouble();
        this.field_70181_x = data.readDouble();
        this.field_70179_y = data.readDouble();
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
    }
}

