/*
 * Decompiled with CFR 0.152.
 */
package lumien.perfectspawn.Core;

import lumien.perfectspawn.Core.PerfectSpawnClientHandler;
import lumien.perfectspawn.Core.PerfectSpawnSettings;
import lumien.perfectspawn.PerfectSpawn;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class CoreHandler {
    static boolean testingRespawnDimension = false;

    public static int getRespawnDimension(WorldProvider provider, EntityPlayerMP player) {
        if (!testingRespawnDimension) {
            PerfectSpawnSettings.SettingEntry se = null;
            se = provider.field_76579_a.field_72995_K ? PerfectSpawnClientHandler.currentServerSettings : PerfectSpawn.settings.getValidSettingEntry();
            if (se != null) {
                testingRespawnDimension = true;
                int normalRespawn = provider.getRespawnDimension(player);
                testingRespawnDimension = false;
                if (normalRespawn == 0) {
                    return se.spawnDimension;
                }
            }
        }
        return -126;
    }

    public static boolean canWakeUp(EntityPlayer player) {
        PerfectSpawnSettings.SettingEntry se = null;
        se = player.field_70170_p.field_72995_K ? PerfectSpawnClientHandler.currentServerSettings : PerfectSpawn.settings.getValidSettingEntry();
        return se == null || !se.forceBed || player.field_70170_p.field_73011_w.field_76574_g != se.spawnDimension || player.field_70170_p.field_73011_w.func_76569_d();
    }

    public static boolean isBlockNotProtectedByDimension(int dimension) {
        return !CoreHandler.isBlockProtectedByDimension(dimension);
    }

    public static boolean isBlockProtectedByDimension(int dimension) {
        WorldServer w = DimensionManager.getWorld((int)dimension);
        PerfectSpawnSettings.SettingEntry se = null;
        se = w.field_72995_K ? PerfectSpawnClientHandler.currentServerSettings : PerfectSpawn.settings.getValidSettingEntry();
        if (se == null || !se.spawnProtection) {
            return dimension == 0;
        }
        return se.spawnDimension == dimension;
    }

    public static ChunkCoordinates getRandomizedSpawnPoint(WorldProvider provider) {
        PerfectSpawnSettings.SettingEntry se = null;
        se = provider.field_76579_a.field_72995_K ? PerfectSpawnClientHandler.currentServerSettings : PerfectSpawn.settings.getValidSettingEntry();
        if (se != null && se.exactSpawn && se.spawnDimension == provider.field_76574_g) {
            return provider.getSpawnPoint();
        }
        return null;
    }

    public static int canRespawnHere(WorldProvider provider) {
        PerfectSpawnSettings.SettingEntry se = null;
        se = provider.field_76579_a.field_72995_K ? PerfectSpawnClientHandler.currentServerSettings : PerfectSpawn.settings.getValidSettingEntry();
        if (se != null) {
            if (provider.field_76574_g == se.spawnDimension) {
                return 1;
            }
            if (provider.field_76574_g == 0) {
                return 0;
            }
        }
        return -1;
    }

    public static int isSurfaceWorld(WorldProvider provider) {
        return -126;
    }
}

