/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.leveling;

import iguanaman.iguanatweakstconstruct.leveling.LevelingLogic;
import iguanaman.iguanatweakstconstruct.leveling.LevelingTooltips;
import iguanaman.iguanatweakstconstruct.leveling.modifiers.ModCritical;
import iguanaman.iguanatweakstconstruct.leveling.modifiers.ModShoddy;
import iguanaman.iguanatweakstconstruct.reference.Config;
import iguanaman.iguanatweakstconstruct.util.Log;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import tconstruct.TConstruct;
import tconstruct.items.tools.Hammer;
import tconstruct.library.crafting.ModifyBuilder;
import tconstruct.library.modifier.ItemModifier;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.weaponry.IAmmo;
import tconstruct.modifiers.tools.ModWindup;
import tconstruct.tools.TinkerTools;
import tconstruct.weaponry.TinkerWeaponry;

public class RandomBonuses {
    public static Set<Modifier> usefulToolModifiers = new HashSet<Modifier>();
    public static Set<Modifier> usefulWeaponModifiers = new HashSet<Modifier>();
    public static Set<Modifier> usefulBowModifiers = new HashSet<Modifier>();
    public static Set<Modifier> usefulAmmoModifiers = new HashSet<Modifier>();
    public static Map<Modifier, Integer> toolWeights = new HashMap<Modifier, Integer>();
    public static Map<Modifier, Integer> weaponWeights = new HashMap<Modifier, Integer>();
    public static Map<Modifier, Integer> bowWeights = new HashMap<Modifier, Integer>();
    public static Map<Modifier, Integer> ammoWeights = new HashMap<Modifier, Integer>();
    public static Integer usageBonusWeight = 70;
    private static Map<String, ItemModifier> modCache = new HashMap<String, ItemModifier>();

    public static Modifier tryModifying(EntityPlayer player, ItemStack tool) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        int modifiers = tags.func_74762_e("Modifiers");
        tags.func_74768_a("Modifiers", modifiers + 1);
        if (!(tool.func_77973_b() instanceof ToolCore)) {
            return null;
        }
        ToolCore toolCore = (ToolCore)tool.func_77973_b();
        Modifier[] mods = Modifier.values();
        int[] chances = new int[mods.length];
        int total = 0;
        int i = 0;
        for (Modifier mod : mods) {
            if (Config.deactivatedModifiers.contains((Object)mod)) {
                chances[i] = 0;
            } else {
                chances[i] = Config.randomBonusesAreRandom ? 1 : (RandomBonuses.hasTrait(toolCore, "bow") ? (Config.randomBonusesAreUseful && !usefulBowModifiers.contains((Object)mod) ? 0 : bowWeights.get((Object)mod)) : (RandomBonuses.hasTrait(toolCore, "ammo") ? (Config.randomBonusesAreUseful && !usefulAmmoModifiers.contains((Object)mod) ? 0 : ammoWeights.get((Object)mod)) : (RandomBonuses.hasTrait(toolCore, "weapon") && !(toolCore instanceof Hammer) ? (Config.randomBonusesAreUseful && !usefulWeaponModifiers.contains((Object)mod) ? 0 : weaponWeights.get((Object)mod)) : (RandomBonuses.hasTrait(toolCore, "harvest") ? (Config.randomBonusesAreUseful && !usefulToolModifiers.contains((Object)mod) ? 0 : toolWeights.get((Object)mod)) : 0))));
                if (tags.func_74764_b(String.format("Extra%s", mod.toString()))) {
                    float bonus = tags.func_74762_e(String.format("Extra%s", mod.toString()));
                    bonus /= (float)LevelingLogic.getRequiredXp(tool, tags);
                    int n = i;
                    chances[n] = (int)((float)chances[n] + (bonus *= (float)usageBonusWeight.intValue()));
                }
            }
            total += chances[i];
            ++i;
        }
        if (total <= 0) {
            return null;
        }
        boolean modified = false;
        Modifier choice = null;
        int tries = 0;
        while (!modified) {
            int random = TConstruct.random.nextInt(total);
            int counter = 0;
            choice = null;
            i = 0;
            for (Modifier mod : mods) {
                if ((counter += chances[++i]) <= random) continue;
                choice = mod;
                break;
            }
            if (choice == null) {
                return null;
            }
            modified = RandomBonuses.applyModifier(choice, player, tool);
            if (tries++ <= 100) continue;
            choice = null;
            for (Modifier mod : Modifier.values()) {
                if (!RandomBonuses.applyModifier(mod, player, tool)) continue;
                choice = mod;
                modified = true;
                break;
            }
            if (modified) continue;
            break;
        }
        modifiers = Math.max(0, modifiers);
        tags.func_74768_a("Modifiers", modifiers);
        if (!modified) {
            Log.warn(String.format("Couldn't find any applicable modifier to reward for %s's %s", player.getDisplayName(), tool.func_82833_r()));
            return null;
        }
        if (Config.logBonusExtraChance) {
            Log.debug(String.format("Chance of getting %s was %f %%", choice.toString(), Float.valueOf(100.0f * (float)chances[i - 1] / (float)total)));
        }
        if (Config.logBonusExtraChance && tags.func_74764_b(String.format("Extra%s", choice.toString()))) {
            float bonus = tags.func_74762_e(String.format("Extra%s", choice.toString()));
            bonus /= (float)LevelingLogic.getRequiredXp(tool, tags);
            Log.debug(String.format("Bonus weight for getting %s was %f", choice.toString(), Float.valueOf(bonus *= (float)usageBonusWeight.intValue())));
            Log.debug(String.format("Bonus chance for getting %s was %f %%", choice.toString(), Float.valueOf(100.0f * bonus / (float)total)));
        }
        RandomBonuses.resetModifierExtraWeight(choice, tags);
        return choice;
    }

    private static boolean hasTrait(ToolCore tool, String trait) {
        return Arrays.asList(tool.getTraits()).contains(trait);
    }

    private static boolean applyModifier(Modifier modifier, EntityPlayer player, ItemStack tool) {
        switch (modifier) {
            case REDSTONE: {
                return RandomBonuses.addRedstoneModifier(player, tool);
            }
            case LAPIS: {
                return RandomBonuses.addLapisModifier(player, tool);
            }
            case AUTOSMELT: {
                return RandomBonuses.addAutoSmeltModifier(player, tool);
            }
            case SILKTOUCH: {
                return RandomBonuses.addSilktouchModifier(player, tool);
            }
            case DIAMOND: {
                return RandomBonuses.addDiamondModifier(player, tool);
            }
            case EMERALD: {
                return RandomBonuses.addEmeraldModifier(player, tool);
            }
            case REPAIR: {
                return RandomBonuses.addRepairModifier(player, tool);
            }
            case REINFORCED: {
                return RandomBonuses.addReinforcedModifier(player, tool);
            }
            case ATTACK: {
                return RandomBonuses.addAttackModifier(player, tool);
            }
            case BLAZE: {
                return RandomBonuses.addBlazeModifier(player, tool);
            }
            case SMITE: {
                return RandomBonuses.addSmiteModifier(player, tool);
            }
            case BANE: {
                return RandomBonuses.addAntiSpiderModifier(player, tool);
            }
            case BEHEADING: {
                return RandomBonuses.addBeheadingModifier(player, tool);
            }
            case LIFESTEAL: {
                return RandomBonuses.addLifeStealModifier(player, tool);
            }
            case KNOCKBACK: {
                return RandomBonuses.addKnockbackModifier(player, tool);
            }
            case JAGGED: {
                return RandomBonuses.addJaggedModifier(player, tool);
            }
            case STONEBOUND: {
                return RandomBonuses.addStoneboundModifier(player, tool);
            }
            case CRITICAL: {
                return RandomBonuses.addCriticalModifier(player, tool);
            }
        }
        return false;
    }

    public static boolean addRedstoneModifier(EntityPlayer player, ItemStack tool) {
        ItemStack[] redstoneStack = new ItemStack[]{new ItemStack(Items.field_151137_ax, 1)};
        String key = "Redstone";
        if (tool.func_77973_b() instanceof ToolCore && RandomBonuses.hasTrait((ToolCore)tool.func_77973_b(), "windup")) {
            key = "Windup";
        }
        return RandomBonuses.addGenericModifier(player, tool, key, redstoneStack, 50, 1, "message.levelup.redstone", "\u00a74");
    }

    public static boolean addLapisModifier(EntityPlayer player, ItemStack tool) {
        ItemStack[] lapisStack = new ItemStack[]{new ItemStack(Items.field_151100_aR, 1, 4)};
        return RandomBonuses.addGenericModifier(player, tool, "Lapis", lapisStack, 100, 100, "message.levelup.lapis", "\u00a79");
    }

    public static boolean addAutoSmeltModifier(EntityPlayer player, ItemStack tool) {
        return RandomBonuses.addGenericModifier(player, tool, "Lava", "message.levelup.autosmelt", "\u00a74");
    }

    public static boolean addSilktouchModifier(EntityPlayer player, ItemStack tool) {
        return RandomBonuses.addGenericModifier(player, tool, "Silk Touch", "message.levelup.silktouch", "\u00a7e");
    }

    public static boolean addDiamondModifier(EntityPlayer player, ItemStack tool) {
        return RandomBonuses.addGenericModifier(player, tool, "Diamond", "message.levelup.diamond", "\u00a7b");
    }

    public static boolean addEmeraldModifier(EntityPlayer player, ItemStack tool) {
        return RandomBonuses.addGenericModifier(player, tool, "Emerald", "message.levelup.emerald", "\u00a72");
    }

    public static boolean addFluxModifier(EntityPlayer player, ItemStack tool) {
        return RandomBonuses.addGenericModifier(player, tool, "Flux", "message.levelup.flux", "\u00a7e");
    }

    public static boolean addRepairModifier(EntityPlayer player, ItemStack tool) {
        return RandomBonuses.addGenericModifier(player, tool, "Moss", "message.levelup.repair", "\u00a72");
    }

    public static boolean addReinforcedModifier(EntityPlayer player, ItemStack tool) {
        return RandomBonuses.addGenericModifier(player, tool, "Reinforced", "message.levelup.reinforced", "\u00a75");
    }

    public static boolean addAttackModifier(EntityPlayer player, ItemStack tool) {
        ItemStack[] quarzStack = new ItemStack[]{new ItemStack(Items.field_151128_bU, 1)};
        String key = "ModAttack";
        if (tool.func_77973_b() != null && tool.func_77973_b() instanceof IAmmo) {
            key = "ModAttackAmmo";
        }
        return RandomBonuses.addGenericModifier(player, tool, key, quarzStack, 24, 1, "message.levelup.attack", "\u00a7f");
    }

    public static boolean addBlazeModifier(EntityPlayer player, ItemStack tool) {
        ItemStack[] blazePowderStack = new ItemStack[]{new ItemStack(Items.field_151065_br, 1)};
        return RandomBonuses.addGenericModifier(player, tool, "Blaze", blazePowderStack, 25, 1, "message.levelup.blaze", "\u00a76");
    }

    public static boolean addSmiteModifier(EntityPlayer player, ItemStack tool) {
        ItemStack[] consecratedEartStack = new ItemStack[]{new ItemStack(TinkerTools.craftedSoil, 1, 4)};
        return RandomBonuses.addGenericModifier(player, tool, "ModSmite", consecratedEartStack, 36, 1, "message.levelup.smite", "\u00a7e");
    }

    public static boolean addAntiSpiderModifier(EntityPlayer player, ItemStack tool) {
        ItemStack[] fermentedEyeStack = new ItemStack[]{new ItemStack(Items.field_151071_bq, 1)};
        return RandomBonuses.addGenericModifier(player, tool, "ModAntiSpider", fermentedEyeStack, 4, 1, "message.levelup.antispider", "\u00a72");
    }

    public static boolean addBeheadingModifier(EntityPlayer player, ItemStack tool) {
        return RandomBonuses.addGenericModifier(player, tool, "Beheading", "message.levelup.beheading", "\u00a7d");
    }

    public static boolean addLifeStealModifier(EntityPlayer player, ItemStack tool) {
        return RandomBonuses.addGenericModifier(player, tool, "Necrotic", "message.levelup.lifesteal", "\u00a78");
    }

    public static boolean addKnockbackModifier(EntityPlayer player, ItemStack tool) {
        ItemStack[] pistonStack = new ItemStack[]{new ItemStack((Block)Blocks.field_150331_J, 1)};
        return RandomBonuses.addGenericModifier(player, tool, "Piston", pistonStack, 10, 1, "message.levelup.knockback", "\u00a77");
    }

    public static boolean addJaggedModifier(EntityPlayer player, ItemStack tool) {
        return RandomBonuses.addGenericModifier(player, tool, ModShoddy.ModJagged.key, "message.levelup.jagged", EnumChatFormatting.RED.toString());
    }

    public static boolean addStoneboundModifier(EntityPlayer player, ItemStack tool) {
        return RandomBonuses.addGenericModifier(player, tool, ModShoddy.ModStonebound.key, "message.levelup.stonebound", EnumChatFormatting.AQUA.toString());
    }

    public static boolean addCriticalModifier(EntityPlayer player, ItemStack tool) {
        return RandomBonuses.addGenericModifier(player, tool, ModCritical.modCritical.key, null, 1, 10, "message.levelup.critical", EnumChatFormatting.WHITE.toString());
    }

    private static boolean addGenericModifier(EntityPlayer player, ItemStack tool, String key, String message, String modColor) {
        return RandomBonuses.addGenericModifier(player, tool, key, null, 1, 1, message, modColor);
    }

    private static boolean addGenericModifier(EntityPlayer player, ItemStack tool, String key, ItemStack[] stacksToAdd, int times, int displayedTimes, String message, String modColor) {
        ItemModifier modifier = RandomBonuses.getModifier(key);
        if (modifier == null) {
            return false;
        }
        if (stacksToAdd == null) {
            stacksToAdd = RandomBonuses.stackFromModifier(modifier);
        }
        if (!modifier.matches(stacksToAdd, tool)) {
            return false;
        }
        if (player != null && !player.field_70170_p.field_72995_K) {
            player.func_145747_a((IChatComponent)new ChatComponentText(LevelingTooltips.getInfoString(StatCollector.func_74838_a((String)message), EnumChatFormatting.DARK_AQUA, String.format("+%d %s", displayedTimes, StatCollector.func_74838_a((String)(message + ".tag"))), modColor)));
        }
        modifier.addMatchingEffect(tool);
        while (times-- > 0) {
            modifier.modify(stacksToAdd, tool);
        }
        return true;
    }

    private static ItemModifier getModifier(String key) {
        if (modCache.containsKey(key)) {
            return modCache.get(key);
        }
        for (ItemModifier modifier : ModifyBuilder.instance.itemModifiers) {
            if (!modifier.key.equals(key)) continue;
            modCache.put(key, modifier);
            return modifier;
        }
        Log.error("Couldn't detect " + key + " modifier when applying random bonus");
        return null;
    }

    private static ItemStack[] stackFromModifier(ItemModifier modifier) {
        ItemStack[] stack = new ItemStack[modifier.stacks.size()];
        int i = 0;
        for (Object s : modifier.stacks) {
            stack[i++] = (ItemStack)s;
        }
        return stack;
    }

    public static void addModifierExtraWeight(Modifier modifier, int amount, NBTTagCompound tags) {
        String key = "Extra" + modifier.toString();
        int old = 0;
        if (tags.func_74764_b(key)) {
            old = tags.func_74762_e(key);
        }
        tags.func_74768_a(key, old + amount);
    }

    public static void resetModifierExtraWeight(Modifier modifier, NBTTagCompound tags) {
        String key = "Extra" + modifier.toString();
        if (tags.func_74764_b(key)) {
            tags.func_82580_o(key);
        }
    }

    private static void preFill(Map<Modifier, Integer> map) {
        for (Modifier mod : Modifier.values()) {
            map.put(mod, 0);
        }
    }

    private static void initToolModifiers() {
        Map<Modifier, Integer> m = toolWeights;
        RandomBonuses.preFill(m);
        m.put(Modifier.REDSTONE, 45);
        m.put(Modifier.LAPIS, 40);
        m.put(Modifier.AUTOSMELT, 3);
        m.put(Modifier.SILKTOUCH, 2);
        m.put(Modifier.DIAMOND, 30);
        m.put(Modifier.EMERALD, 35);
        m.put(Modifier.REPAIR, 50);
        m.put(Modifier.REINFORCED, 77);
        m.put(Modifier.STONEBOUND, 5);
        m.put(Modifier.ATTACK, 7);
        m.put(Modifier.BLAZE, 3);
        m.put(Modifier.SMITE, 3);
        m.put(Modifier.BANE, 3);
        m.put(Modifier.BEHEADING, 3);
        m.put(Modifier.LIFESTEAL, 3);
        m.put(Modifier.KNOCKBACK, 10);
        m.put(Modifier.JAGGED, 1);
        m.put(Modifier.CRITICAL, 1);
        Set<Modifier> u = usefulToolModifiers;
        u.add(Modifier.REDSTONE);
        u.add(Modifier.LAPIS);
        u.add(Modifier.AUTOSMELT);
        u.add(Modifier.SILKTOUCH);
        u.add(Modifier.DIAMOND);
        u.add(Modifier.EMERALD);
        u.add(Modifier.REPAIR);
        u.add(Modifier.REINFORCED);
        u.add(Modifier.STONEBOUND);
    }

    private static void initWeaponModifiers() {
        Map<Modifier, Integer> m = weaponWeights;
        RandomBonuses.preFill(m);
        m.put(Modifier.LAPIS, 75);
        m.put(Modifier.REPAIR, 55);
        m.put(Modifier.ATTACK, 110);
        m.put(Modifier.BLAZE, 45);
        m.put(Modifier.SMITE, 40);
        m.put(Modifier.BANE, 40);
        m.put(Modifier.BEHEADING, 50);
        m.put(Modifier.LIFESTEAL, 30);
        m.put(Modifier.KNOCKBACK, 50);
        m.put(Modifier.JAGGED, 5);
        m.put(Modifier.CRITICAL, 2);
        m.put(Modifier.REDSTONE, 0);
        m.put(Modifier.AUTOSMELT, 15);
        m.put(Modifier.SILKTOUCH, 1);
        m.put(Modifier.DIAMOND, 15);
        m.put(Modifier.EMERALD, 30);
        m.put(Modifier.REINFORCED, 55);
        m.put(Modifier.STONEBOUND, 1);
        Set<Modifier> u = usefulWeaponModifiers;
        u.add(Modifier.LAPIS);
        u.add(Modifier.REPAIR);
        u.add(Modifier.ATTACK);
        u.add(Modifier.BLAZE);
        u.add(Modifier.SMITE);
        u.add(Modifier.BANE);
        u.add(Modifier.BEHEADING);
        u.add(Modifier.LIFESTEAL);
        u.add(Modifier.KNOCKBACK);
        u.add(Modifier.JAGGED);
        u.add(Modifier.CRITICAL);
    }

    private static void initBowModifiers() {
        Map<Modifier, Integer> m = bowWeights;
        RandomBonuses.preFill(m);
        m.put(Modifier.REDSTONE, 100);
        m.put(Modifier.REPAIR, 55);
        m.put(Modifier.REINFORCED, 65);
        m.put(Modifier.KNOCKBACK, 50);
        m.put(Modifier.LAPIS, 60);
        m.put(Modifier.DIAMOND, 20);
        m.put(Modifier.EMERALD, 25);
        m.put(Modifier.ATTACK, 25);
        m.put(Modifier.BLAZE, 15);
        m.put(Modifier.SMITE, 15);
        m.put(Modifier.BANE, 15);
        m.put(Modifier.BEHEADING, 10);
        m.put(Modifier.LIFESTEAL, 10);
        m.put(Modifier.JAGGED, 1);
        m.put(Modifier.CRITICAL, 0);
        m.put(Modifier.AUTOSMELT, 1);
        m.put(Modifier.SILKTOUCH, 1);
        m.put(Modifier.STONEBOUND, 1);
        Set<Modifier> u = usefulBowModifiers;
        u.add(Modifier.REDSTONE);
        u.add(Modifier.KNOCKBACK);
        u.add(Modifier.REPAIR);
        u.add(Modifier.REINFORCED);
        u.add(Modifier.LAPIS);
    }

    private static void initAmmoModifiers() {
        Map<Modifier, Integer> m = ammoWeights;
        RandomBonuses.preFill(m);
        m.put(Modifier.LAPIS, 75);
        m.put(Modifier.REPAIR, 65);
        m.put(Modifier.ATTACK, 100);
        m.put(Modifier.BLAZE, 45);
        m.put(Modifier.SMITE, 20);
        m.put(Modifier.BANE, 20);
        m.put(Modifier.BEHEADING, 30);
        m.put(Modifier.LIFESTEAL, 30);
        m.put(Modifier.KNOCKBACK, 50);
        m.put(Modifier.AUTOSMELT, 15);
        m.put(Modifier.SILKTOUCH, 1);
        m.put(Modifier.DIAMOND, 25);
        m.put(Modifier.EMERALD, 35);
        m.put(Modifier.REINFORCED, 45);
        m.put(Modifier.STONEBOUND, 0);
        m.put(Modifier.JAGGED, 0);
        m.put(Modifier.CRITICAL, 0);
        m.put(Modifier.REDSTONE, 0);
        Set<Modifier> u = usefulAmmoModifiers;
        u.add(Modifier.LAPIS);
        u.add(Modifier.REPAIR);
        u.add(Modifier.ATTACK);
        u.add(Modifier.BLAZE);
        u.add(Modifier.SMITE);
        u.add(Modifier.BANE);
        u.add(Modifier.BEHEADING);
        u.add(Modifier.LIFESTEAL);
        u.add(Modifier.KNOCKBACK);
        u.add(Modifier.JAGGED);
        u.add(Modifier.CRITICAL);
        u.add(Modifier.DIAMOND);
    }

    static {
        RandomBonuses.initToolModifiers();
        RandomBonuses.initWeaponModifiers();
        RandomBonuses.initBowModifiers();
        RandomBonuses.initAmmoModifiers();
        modCache.put(ModShoddy.ModJagged.key, ModShoddy.ModJagged);
        modCache.put(ModShoddy.ModStonebound.key, ModShoddy.ModStonebound);
        modCache.put(ModCritical.modCritical.key, (ItemModifier)ModCritical.modCritical);
        modCache.put(TinkerTools.modAttack.key, (ItemModifier)TinkerTools.modAttack);
        modCache.put(TinkerWeaponry.modAttack.key + "Ammo", (ItemModifier)TinkerWeaponry.modAttack);
        for (ItemModifier modifier : ModifyBuilder.instance.itemModifiers) {
            if (!(modifier instanceof ModWindup)) continue;
            modCache.put("Windup", modifier);
            break;
        }
    }

    public static enum Modifier {
        REDSTONE,
        LAPIS,
        AUTOSMELT,
        SILKTOUCH,
        DIAMOND,
        EMERALD,
        REPAIR,
        REINFORCED,
        ATTACK,
        BLAZE,
        SMITE,
        BANE,
        BEHEADING,
        LIFESTEAL,
        KNOCKBACK,
        STONEBOUND,
        JAGGED,
        CRITICAL;


        public String toString() {
            switch (this) {
                case REDSTONE: {
                    return "Redstone";
                }
                case LAPIS: {
                    return "LuckLooting";
                }
                case AUTOSMELT: {
                    return "Autosmelt";
                }
                case SILKTOUCH: {
                    return "SilkTouch";
                }
                case DIAMOND: {
                    return "Diamond";
                }
                case EMERALD: {
                    return "Emerald";
                }
                case REPAIR: {
                    return "Repair";
                }
                case REINFORCED: {
                    return "Reinforced";
                }
                case ATTACK: {
                    return "Attack";
                }
                case BLAZE: {
                    return "Fiery";
                }
                case SMITE: {
                    return "Smite";
                }
                case BANE: {
                    return "BaneOfArthropods";
                }
                case BEHEADING: {
                    return "Beheading";
                }
                case LIFESTEAL: {
                    return "LifeSteal";
                }
                case KNOCKBACK: {
                    return "Knockback";
                }
                case JAGGED: {
                    return "Jagged";
                }
                case STONEBOUND: {
                    return "Stonebound";
                }
                case CRITICAL: {
                    return "Critical";
                }
            }
            return super.toString();
        }

        public static Modifier getEnumByString(String string) throws IllegalArgumentException {
            for (Modifier mod : Modifier.values()) {
                if (!mod.toString().equals(string)) continue;
                return mod;
            }
            throw new IllegalArgumentException();
        }
    }
}

