/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration.ae2;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.ILockable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IVoidable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import net.minecraft.item.ItemStack;

public class DrawerMEInventory
implements IMEInventory<IAEItemStack> {
    final IDrawerGroup group;

    public DrawerMEInventory(IDrawerGroup drawerGroup) {
        this.group = drawerGroup;
    }

    public IAEItemStack injectItems(IAEItemStack input, Actionable type, BaseActionSource src) {
        IDrawer drawer;
        ItemStack itemProto;
        int i;
        long itemsLeft = input.getStackSize();
        int n = this.group.getDrawerCount();
        for (i = 0; i < n; ++i) {
            if (!this.group.isDrawerEnabled(i) || (itemProto = (drawer = this.group.getDrawer(i)).getStoredItemPrototype()) == null || !drawer.canItemBeStored(input.getItemStack())) continue;
            itemsLeft = this.injectItemsIntoDrawer(drawer, itemsLeft, type);
            if (drawer instanceof IVoidable && ((IVoidable)((Object)drawer)).isVoid()) {
                itemsLeft = 0L;
            }
            if (itemsLeft != 0L) continue;
            return null;
        }
        n = this.group.getDrawerCount();
        for (i = 0; i < n; ++i) {
            if (!this.group.isDrawerEnabled(i) || this.group instanceof ILockable && ((ILockable)((Object)this.group)).isLocked(LockAttribute.LOCK_EMPTY) || (itemProto = (drawer = this.group.getDrawer(i)).getStoredItemPrototype()) == null && drawer instanceof ILockable && ((ILockable)((Object)drawer)).isLocked(LockAttribute.LOCK_EMPTY) || itemProto != null || !drawer.canItemBeStored(itemProto = input.getItemStack())) continue;
            drawer.setStoredItem(itemProto, 0);
            itemsLeft = this.injectItemsIntoDrawer(drawer, itemsLeft, type);
            if (drawer instanceof IVoidable && ((IVoidable)((Object)drawer)).isVoid()) {
                itemsLeft = 0L;
            }
            if (itemsLeft != 0L) continue;
            return null;
        }
        if (itemsLeft > 0L) {
            IAEItemStack overflow = AEApi.instance().storage().createItemStack(input.getItemStack());
            overflow.setStackSize(itemsLeft);
            return overflow;
        }
        return input;
    }

    private long injectItemsIntoDrawer(IDrawer drawer, long itemCount, Actionable type) {
        int storedItems;
        int capacity = drawer.getMaxCapacity();
        if (capacity == (storedItems = drawer.getStoredItemCount())) {
            return itemCount;
        }
        if ((storedItems = (int)((long)storedItems + itemCount)) > capacity) {
            if (type == Actionable.MODULATE) {
                drawer.setStoredItemCount(capacity);
            }
            return storedItems - capacity;
        }
        if (type == Actionable.MODULATE) {
            drawer.setStoredItemCount(storedItems);
        }
        return 0L;
    }

    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
        long itemsLeft = request.getStackSize();
        int n = this.group.getDrawerCount();
        for (int i = 0; i < n; ++i) {
            IDrawer drawer;
            if (!this.group.isDrawerEnabled(i) || !(drawer = this.group.getDrawer(i)).canItemBeExtracted(request.getItemStack())) continue;
            int itemCount = drawer.getStoredItemCount();
            if (itemsLeft > (long)itemCount) {
                if (mode == Actionable.MODULATE) {
                    drawer.setStoredItemCount(0);
                }
                itemsLeft -= (long)itemCount;
                continue;
            }
            if (mode == Actionable.MODULATE) {
                drawer.setStoredItemCount(itemCount - (int)itemsLeft);
            }
            itemsLeft = 0L;
            break;
        }
        if (itemsLeft < request.getStackSize()) {
            ItemStack fulfillment = request.getItemStack().func_77946_l();
            fulfillment.field_77994_a = (int)((long)fulfillment.field_77994_a - itemsLeft);
            return AEApi.instance().storage().createItemStack(fulfillment);
        }
        return null;
    }

    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
        int n = this.group.getDrawerCount();
        for (int i = 0; i < n; ++i) {
            IDrawer drawer;
            if (!this.group.isDrawerEnabled(i) || (drawer = this.group.getDrawer(i)).isEmpty()) continue;
            out.add((IAEStack)AEApi.instance().storage().createItemStack(drawer.getStoredItemCopy()));
        }
        return out;
    }

    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }
}

