/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityController;
import com.jaquadro.minecraft.storagedrawers.core.ModCreativeTabs;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockController
extends BlockContainer
implements INetworked {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFront;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconSide;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconSideEtched;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTrim;

    public BlockController(String blockName) {
        super(Material.field_151576_e);
        this.func_149647_a(ModCreativeTabs.tabStorageDrawers);
        this.func_149711_c(5.0f);
        this.func_149663_c(blockName);
        this.func_149672_a(Block.field_149769_e);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.func_149675_a(true);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return StorageDrawers.proxy.controllerRenderID;
    }

    public int func_149738_a(World world) {
        return 100;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
        TileEntityController tile = this.getTileEntitySafe(world, x, y, z);
        if (tile.getDirection() > 1) {
            return;
        }
        int quadrant = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (quadrant) {
            case 0: {
                tile.setDirection(2);
                break;
            }
            case 1: {
                tile.setDirection(5);
                break;
            }
            case 2: {
                tile.setDirection(3);
                break;
            }
            case 3: {
                tile.setDirection(4);
            }
        }
        if (world.field_72995_K) {
            tile.func_145843_s();
            world.func_147471_g(x, y, z);
        }
    }

    public void func_149714_e(World world, int x, int y, int z, int meta) {
        if (world.field_72995_K) {
            return;
        }
        TileEntityController te = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te == null) {
            return;
        }
        te.updateCache();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntityController te = this.getTileEntitySafe(world, x, y, z);
        ItemStack item = player.field_71071_by.func_70448_g();
        if (item != null && item.func_77973_b() != null) {
            if (item.func_77973_b() == ModItems.shroudKey) {
                if (!world.field_72995_K) {
                    te.toggleShroud();
                }
                return true;
            }
            if (item.func_77973_b() == ModItems.upgradeLock) {
                if (!world.field_72995_K) {
                    te.toggleLock(EnumSet.allOf(LockAttribute.class), LockAttribute.LOCK_POPULATED);
                }
                return true;
            }
        }
        if (te.getDirection() != side) {
            return false;
        }
        if (!world.field_72995_K) {
            te.interactPutItemsIntoInventory(player);
        }
        return true;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        if (this.getTileEntity(world, x, y, z) == null) {
            return true;
        }
        return side.ordinal() != this.getTileEntity(world, x, y, z).getDirection();
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        TileEntityController te = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te == null) {
            return;
        }
        te.updateCache();
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        switch (side) {
            case 0: 
            case 1: {
                return this.iconSide;
            }
            case 4: {
                return this.iconFront;
            }
        }
        return this.iconSideEtched;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntityController tile = this.getTileEntity(blockAccess, x, y, z);
        if (tile == null) {
            return this.iconFront;
        }
        if (side == tile.getDirection()) {
            return this.iconFront;
        }
        switch (side) {
            case 0: 
            case 1: {
                return this.iconSide;
            }
        }
        return this.iconSideEtched;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTrim(int meta) {
        return this.iconTrim;
    }

    public TileEntityController createNewTileEntity(World world, int meta) {
        return new TileEntityController();
    }

    public TileEntityController getTileEntity(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity tile = blockAccess.func_147438_o(x, y, z);
        return tile instanceof TileEntityController ? (TileEntityController)tile : null;
    }

    public TileEntityController getTileEntitySafe(World world, int x, int y, int z) {
        TileEntityController tile = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (tile == null) {
            tile = this.createNewTileEntity(world, world.func_72805_g(x, y, z));
            world.func_147455_a(x, y, z, (TileEntity)tile);
        }
        return tile;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.iconFront = register.func_94245_a("StorageDrawers:drawers_controller_front");
        this.iconSide = register.func_94245_a("StorageDrawers:drawers_comp_side");
        this.iconSideEtched = register.func_94245_a("StorageDrawers:drawers_comp_side_2");
        this.iconTrim = register.func_94245_a("StorageDrawers:drawers_comp_trim");
    }
}

