/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.crafting;

import cofh.core.CoFHProps;
import cofh.thermalexpansion.ThermalExpansion;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.block.Block;

public class TECraftingParser {
    private static File craftingFolder;

    private TECraftingParser() {
    }

    public static void initialize() {
        craftingFolder = new File(CoFHProps.configDir, "/cofh/thermalexpansion/crafting/");
        if (!craftingFolder.exists()) {
            try {
                craftingFolder.mkdir();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void addFiles(ArrayList<File> arrayList, File file) {
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                if (string == null) {
                    return false;
                }
                return string.toLowerCase().endsWith(".json") || new File(file, string).isDirectory();
            }
        });
        if (fileArray == null || fileArray.length <= 0) {
            ThermalExpansion.log.info("There are no crafting files present in " + file + ".");
            return;
        }
        ThermalExpansion.log.info(fileArray.length + " crafting files present in " + file + "/.");
        arrayList.addAll(Arrays.asList(fileArray));
    }

    public static void parseCraftingFiles() {
        JsonParser jsonParser = new JsonParser();
        ArrayList<File> arrayList = new ArrayList<File>();
        TECraftingParser.addFiles(arrayList, craftingFolder);
        for (int i = 0; i < arrayList.size(); ++i) {
            JsonObject jsonObject;
            File file = arrayList.get(i);
            if (file.isDirectory()) {
                TECraftingParser.addFiles(arrayList, file);
                continue;
            }
            try {
                jsonObject = (JsonObject)jsonParser.parse((Reader)new FileReader(file));
            }
            catch (Throwable throwable) {
                ThermalExpansion.log.error("Critical error reading from a crafting file: " + file + " > Please be sure the file is correct!", throwable);
                continue;
            }
            ThermalExpansion.log.info("Reading template info from: " + file + ":");
            for (Map.Entry entry : jsonObject.entrySet()) {
                if (TECraftingParser.acquireCraftingEntry((String)entry.getKey(), (JsonElement)entry.getValue())) {
                    ThermalExpansion.log.debug("Crafting entry acquired: \"" + (String)entry.getKey() + "\"");
                    continue;
                }
                ThermalExpansion.log.error("Error acquiring entry: \"" + (String)entry.getKey() + "\" > Please check the parameters. It *may* be a duplicate.");
            }
        }
    }

    private static boolean acquireCraftingEntry(String string, JsonElement jsonElement) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        String string2 = jsonObject.get("type").getAsString().toLowerCase();
        if (string2.equals("furnace")) {
            return TECraftingParser.parseFurnaceRecipe(string, jsonObject);
        }
        if (string2.equals("pulverizer")) {
            return TECraftingParser.parsePulverizerRecipe(string, jsonObject);
        }
        if (string2.equals("sawmill")) {
            return TECraftingParser.parseSawmillRecipe(string, jsonObject);
        }
        if (string2.equals("smelter")) {
            return TECraftingParser.parseSmelterRecipe(string, jsonObject);
        }
        if (string2.equals("crucible")) {
            return TECraftingParser.parseCrucibleRecipe(string, jsonObject);
        }
        if (string2.equals("transposer")) {
            return TECraftingParser.parseTransposerRecipe(string, jsonObject);
        }
        if (string2.equals("charger")) {
            return TECraftingParser.parseChargerRecipe(string, jsonObject);
        }
        if (string2.equals("insolator")) {
            return TECraftingParser.parseInsolatorRecipe(string, jsonObject);
        }
        return false;
    }

    private static boolean parseFurnaceRecipe(String string, JsonObject jsonObject) {
        if (!jsonObject.has("input") || !jsonObject.has("output")) {
            return false;
        }
        return false;
    }

    private static boolean parsePulverizerRecipe(String string, JsonObject jsonObject) {
        if (!jsonObject.has("input")) {
            return false;
        }
        if (jsonObject.has("output") || !jsonObject.has("primaryOutput")) {
            // empty if block
        }
        return false;
    }

    private static boolean parseSawmillRecipe(String string, JsonObject jsonObject) {
        if (!jsonObject.has("input")) {
            return false;
        }
        if (jsonObject.has("output") || !jsonObject.has("primaryOutput")) {
            // empty if block
        }
        return false;
    }

    private static boolean parseSmelterRecipe(String string, JsonObject jsonObject) {
        if (!jsonObject.has("input")) {
            return false;
        }
        if (jsonObject.has("output") || !jsonObject.has("primaryOutput")) {
            // empty if block
        }
        return false;
    }

    private static boolean parseCrucibleRecipe(String string, JsonObject jsonObject) {
        if (!jsonObject.has("input") || !jsonObject.has("output")) {
            return false;
        }
        return false;
    }

    private static boolean parseTransposerRecipe(String string, JsonObject jsonObject) {
        if (!jsonObject.has("input") || !jsonObject.has("output")) {
            return false;
        }
        return false;
    }

    private static boolean parseChargerRecipe(String string, JsonObject jsonObject) {
        if (!jsonObject.has("input") || !jsonObject.has("output")) {
            return false;
        }
        return false;
    }

    private static boolean parseInsolatorRecipe(String string, JsonObject jsonObject) {
        if (!jsonObject.has("input")) {
            return false;
        }
        if (jsonObject.has("output") || !jsonObject.has("primaryOutput")) {
            // empty if block
        }
        return false;
    }

    public static Block parseBlockName(String string) {
        String[] stringArray = string.split(":", 2);
        int n = 0;
        return GameRegistry.findBlock((String)(stringArray.length > 1 ? stringArray[n++] : "minecraft"), (String)stringArray[n]);
    }
}

