/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.network.PacketCoFHBase;
import cofh.core.util.CoreUtils;
import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiAccumulator;
import cofh.thermalexpansion.gui.container.ContainerTEBase;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileAccumulator
extends TileMachineBase
implements IFluidHandler {
    static final int TYPE = BlockMachine.Types.ACCUMULATOR.ordinal();
    public static int genRate = 800;
    public static int genRatePassive = 32;
    public static boolean passiveGen = false;
    FluidTankAdv tank = new FluidTankAdv(4000);
    int adjacentSources = -1;
    int outputTrackerFluid;
    boolean inHell;
    FluidStack outputBuffer;

    public static void initialize() {
        TileMachineBase.defaultSideConfig[TileAccumulator.TYPE] = new TileTEBase.SideConfig();
        TileMachineBase.defaultSideConfig[TileAccumulator.TYPE].numConfig = 2;
        TileMachineBase.defaultSideConfig[TileAccumulator.TYPE].slotGroups = new int[][]{new int[0], new int[0]};
        TileMachineBase.defaultSideConfig[TileAccumulator.TYPE].allowInsertionSide = new boolean[]{false, false};
        TileMachineBase.defaultSideConfig[TileAccumulator.TYPE].allowExtractionSide = new boolean[]{false, false};
        TileMachineBase.defaultSideConfig[TileAccumulator.TYPE].sideTex = new int[]{0, 4};
        TileMachineBase.defaultSideConfig[TileAccumulator.TYPE].defaultSides = new byte[]{1, 1, 1, 1, 1, 1};
        TileMachineBase.defaultEnergyConfig[TileAccumulator.TYPE] = new TileTEBase.EnergyConfig();
        TileMachineBase.defaultEnergyConfig[TYPE].setParamsPower(0);
        TileMachineBase.sounds[TileAccumulator.TYPE] = CoreUtils.getSoundName((String)"ThermalExpansion", (String)"blockMachineAccumulator");
        GameRegistry.registerTileEntity(TileAccumulator.class, (String)"thermalexpansion.Accumulator");
    }

    public TileAccumulator() {
        this.tank.setLock(FluidRegistry.WATER);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.updateAdjacentSources();
    }

    @Override
    public void func_145845_h() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        boolean bl = this.isActive;
        this.transferFluid();
        if (this.isActive) {
            if (this.timeCheck()) {
                if (this.adjacentSources >= 2) {
                    this.tank.fillLocked(genRate * this.processMod, true);
                } else if (((TileEntity)this).field_145850_b.func_72896_J() && ((TileEntity)this).field_145850_b.func_72937_j(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e)) {
                    this.tank.fillLocked(genRate * this.processMod, true);
                } else if (passiveGen) {
                    this.tank.fillLocked(genRatePassive * this.processMod, true);
                }
            }
            if (!this.redstoneControlOrDisable()) {
                this.isActive = false;
                this.wasActive = true;
                this.tracker.markTime(((TileEntity)this).field_145850_b);
            }
        } else if (this.redstoneControlOrDisable() && this.canStart()) {
            this.isActive = true;
        }
        if (this.adjacentSources < 0) {
            this.updateAdjacentSources();
        }
        this.updateIfChanged(bl);
    }

    @Override
    protected boolean canStart() {
        return !this.inHell;
    }

    protected void updateAdjacentSources() {
        this.inHell = ((TileEntity)this).field_145850_b.func_72807_a(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145849_e) == BiomeGenBase.field_76778_j;
        this.adjacentSources = 0;
        Block block = ((TileEntity)this).field_145850_b.func_147439_a(((TileEntity)this).field_145851_c - 1, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        int n = ((TileEntity)this).field_145850_b.func_72805_g(((TileEntity)this).field_145851_c - 1, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        if (n == 0 && (block == Blocks.field_150355_j || block == Blocks.field_150358_i)) {
            ++this.adjacentSources;
        }
        block = ((TileEntity)this).field_145850_b.func_147439_a(((TileEntity)this).field_145851_c + 1, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        n = ((TileEntity)this).field_145850_b.func_72805_g(((TileEntity)this).field_145851_c + 1, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        if (n == 0 && (block == Blocks.field_150355_j || block == Blocks.field_150358_i)) {
            ++this.adjacentSources;
        }
        block = ((TileEntity)this).field_145850_b.func_147439_a(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e - 1);
        n = ((TileEntity)this).field_145850_b.func_72805_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e - 1);
        if (n == 0 && (block == Blocks.field_150355_j || block == Blocks.field_150358_i)) {
            ++this.adjacentSources;
        }
        block = ((TileEntity)this).field_145850_b.func_147439_a(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e + 1);
        n = ((TileEntity)this).field_145850_b.func_72805_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e + 1);
        if (n == 0 && (block == Blocks.field_150355_j || block == Blocks.field_150358_i)) {
            ++this.adjacentSources;
        }
    }

    protected void transferFluid() {
        if (!this.augmentAutoTransfer) {
            return;
        }
        if (this.tank.getFluidAmount() <= 0) {
            return;
        }
        this.outputBuffer = new FluidStack(this.tank.getFluid(), Math.min(this.tank.getFluidAmount(), 500));
        for (int i = this.outputTrackerFluid + 1; i <= this.outputTrackerFluid + 6; ++i) {
            int n;
            int n2 = i % 6;
            if (this.sideCache[n2] != 1 || (n = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (int)n2, (FluidStack)this.outputBuffer, (boolean)true)) <= 0) continue;
            this.tank.drain(n, true);
            this.outputTrackerFluid = n2;
            break;
        }
    }

    @Override
    protected void onLevelChange() {
        super.onLevelChange();
        this.tank.setCapacity(4000 * TileMachineBase.FLUID_CAPACITY[this.level]);
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiAccumulator(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerTEBase(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public FluidTankAdv getTank() {
        return this.tank;
    }

    @Override
    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.inHell = nBTTagCompound.func_74767_n("Hell");
        this.adjacentSources = nBTTagCompound.func_74762_e("Sources");
        this.outputTrackerFluid = nBTTagCompound.func_74762_e("Tracker");
        this.tank.readFromNBT(nBTTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74757_a("Hell", this.inHell);
        nBTTagCompound.func_74768_a("Sources", this.adjacentSources);
        nBTTagCompound.func_74768_a("Tracker", this.outputTrackerFluid);
        this.tank.writeToNBT(nBTTagCompound);
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        packetCoFHBase.addInt(this.tank.getFluidAmount());
        return packetCoFHBase;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        super.handleGuiPacket(packetCoFHBase);
        this.tank.getFluid().amount = packetCoFHBase.getInt();
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (forgeDirection != ForgeDirection.UNKNOWN && this.sideCache[forgeDirection.ordinal()] < 1) {
            return null;
        }
        if (fluidStack == null || fluidStack.getFluid() != FluidRegistry.WATER) {
            return null;
        }
        return this.tank.drain(fluidStack.amount, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        if (forgeDirection != ForgeDirection.UNKNOWN && this.sideCache[forgeDirection.ordinal()] < 1) {
            return null;
        }
        return this.tank.drain(n, bl);
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    static {
        String string = "This controls how many mB/t the Accumulator generates. (Default: 25)";
        int n = ThermalExpansion.config.get("Machine.Accumulator", "BaseRate", genRate / 32, string);
        if (n < 1 || n > 1000) {
            ThermalExpansion.log.info("'Machine.Accumulator.BaseRate' config value is out of acceptable range. Using default. (25)");
        } else {
            genRate = n * 32;
        }
        string = "This controls how many mB/t the Accumulator generates without two or more adjacent source blocks, if enabled. (Default: 1)";
        n = ThermalExpansion.config.get("Machine.Accumulator", "PassiveRate", 1, string);
        if (n < 1 || n > 1000) {
            ThermalExpansion.log.info("'Machine.Accumulator.PassiveRate' config value is out of acceptable range. Using default. (1)");
        } else {
            genRatePassive = n * 32;
        }
        string = "Set this to true to enable passive generation (less than two adjacent sources) for the Accumulator.";
        passiveGen = ThermalExpansion.config.get("Machine.Accumulator", "PassiveGeneration", false);
    }
}

