/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.ram.server;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.zip.ZipException;
import mcp.mobius.ram.RPGAdvMod;
import mcp.mobius.ram.server.ISaveable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.DimensionManager;

public class DataSaveManager {
    private File saveDir;
    private File[] saveFiles;
    private int saveTo;
    private NBTTagCompound saveTag;
    private ISaveable target;

    public DataSaveManager(ISaveable target) {
        this.target = target;
    }

    public void writeToFile() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return;
        }
        try {
            this.target.writeToNBT(this.saveTag);
            File saveFile = this.saveFiles[this.saveTo];
            if (!saveFile.exists()) {
                saveFile.createNewFile();
            }
            DataOutputStream dout = new DataOutputStream(new FileOutputStream(saveFile));
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.saveTag, (OutputStream)dout);
            dout.close();
            FileOutputStream fout = new FileOutputStream(this.saveFiles[2]);
            fout.write(this.saveTo);
            fout.close();
            this.saveTo ^= 1;
        }
        catch (Exception e) {
            System.out.printf("RPGAdvMod state directory missing. Skipping saving state. If you are in hardcore mode, this is a perfectly normal situation, otherwise, please report to my bugtracker.\n", new Object[0]);
        }
    }

    public void loadFromFile() {
        System.out.printf("Attemping to load RPGAdvMod data.\n", new Object[0]);
        this.saveDir = new File(DimensionManager.getCurrentSaveRootDirectory(), "RPGAdvMod");
        try {
            boolean dataLoaded;
            block9: {
                if (!this.saveDir.exists()) {
                    this.saveDir.mkdirs();
                }
                this.saveFiles = new File[]{new File(this.saveDir, this.target.getFilenames()[0]), new File(this.saveDir, this.target.getFilenames()[1]), new File(this.saveDir, this.target.getFilenames()[2])};
                dataLoaded = false;
                if (this.saveFiles[2].exists() && this.saveFiles[2].length() > 0L) {
                    FileInputStream fin = new FileInputStream(this.saveFiles[2]);
                    this.saveTo = fin.read() ^ 1;
                    fin.close();
                    try {
                        if (this.saveFiles[this.saveTo ^ 1].exists()) {
                            DataInputStream din = new DataInputStream(new FileInputStream(this.saveFiles[this.saveTo ^ 1]));
                            this.saveTag = CompressedStreamTools.func_74796_a((InputStream)din);
                            din.close();
                            dataLoaded = true;
                        }
                    }
                    catch (ZipException e) {
                        if (!this.saveFiles[this.saveTo].exists()) break block9;
                        DataInputStream din = new DataInputStream(new FileInputStream(this.saveFiles[this.saveTo]));
                        this.saveTag = CompressedStreamTools.func_74796_a((InputStream)din);
                        din.close();
                        dataLoaded = true;
                    }
                }
            }
            if (!dataLoaded) {
                this.saveTag = new NBTTagCompound();
            }
        }
        catch (Exception e) {
            if (e instanceof ZipException) {
                RPGAdvMod.log.log(Level.SEVERE, "Primary and Backup RPGAdvMod data files have been corrupted.");
            }
            throw new RuntimeException(e);
        }
        this.target.readFromNBT(this.saveTag);
    }
}

