/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.ram.network;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.ArrayList;
import mcp.mobius.ram.client.gui.GuiScreenWaypointList;
import mcp.mobius.ram.common.blocks.TileEntityPole;
import mcp.mobius.ram.network.PacketBase;
import mcp.mobius.ram.network.PacketManager;
import mcp.mobius.ram.server.WaypointManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class Packet0x03WaypointList
extends PacketBase {
    public int dim;
    public int x;
    public int y;
    public int z;
    public boolean highHit;
    public ArrayList<WaypointManager.Waypoint> waypoints;
    public int metadata;
    public int sideHit;

    public Packet0x03WaypointList() {
    }

    public Packet0x03WaypointList(TileEntityPole pole, int sideHit, boolean highHit, int metadata) {
        this.dim = pole.func_145831_w().field_73011_w.field_76574_g;
        this.x = pole.field_145851_c;
        this.y = pole.field_145848_d;
        this.z = pole.field_145849_e;
        this.sideHit = sideHit;
        this.highHit = highHit;
        this.metadata = metadata;
        this.waypoints = new ArrayList<WaypointManager.Waypoint>(WaypointManager.INSTANCE.getWaypoints());
    }

    @Override
    public void encode(ByteArrayDataOutput output) {
        output.writeInt(this.dim);
        output.writeInt(this.x);
        output.writeInt(this.y);
        output.writeInt(this.z);
        output.writeInt(this.sideHit);
        output.writeBoolean(this.highHit);
        output.writeInt(this.metadata);
        output.writeInt(this.waypoints.size());
        for (WaypointManager.Waypoint wp : this.waypoints) {
            try {
                PacketManager.writeNBTTagCompoundToBuffer(output, wp.toNBT());
            }
            catch (IOException e) {}
        }
    }

    @Override
    public void decode(ByteArrayDataInput input) {
        this.dim = input.readInt();
        this.x = input.readInt();
        this.y = input.readInt();
        this.z = input.readInt();
        this.sideHit = input.readInt();
        this.highHit = input.readBoolean();
        this.metadata = input.readInt();
        int nwp = input.readInt();
        this.waypoints = new ArrayList();
        for (int i = 0; i < nwp; ++i) {
            try {
                WaypointManager waypointManager = WaypointManager.INSTANCE;
                waypointManager.getClass();
                this.waypoints.add(new WaypointManager.Waypoint(waypointManager, PacketManager.readNBTTagCompoundFromBuffer(input)));
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void actionClient(World world, EntityPlayer player) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiScreenWaypointList(this.dim, this.x, this.y, this.z, this.sideHit, this.highHit, this.metadata, this.waypoints));
    }
}

