/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.ram.common.blocks;

import java.util.ArrayList;
import mcp.mobius.ram.RPGAdvMod;
import mcp.mobius.ram.client.gui.GuiScreenWaypoint;
import mcp.mobius.ram.client.render.SBRBlocks;
import mcp.mobius.ram.common.Utils;
import mcp.mobius.ram.common.blocks.TileEntityWaySign;
import mcp.mobius.ram.common.items.ItemPoleSign;
import mcp.mobius.ram.common.items.ItemWaySign;
import mcp.mobius.ram.network.Packet0x0CClearFlypath;
import mcp.mobius.ram.network.PacketManager;
import mcp.mobius.ram.server.CoordinateBlock;
import mcp.mobius.ram.server.WaypointManager;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockWaySign
extends Block
implements ITileEntityProvider {
    public BlockWaySign() {
        super(Material.field_151573_f);
        this.func_149663_c("waysign");
        this.func_149711_c(2.0f).func_149752_b(5.0f);
        this.setHarvestLevel("axe", 1, 0);
        this.setHarvestLevel("axe", 1, 1);
        this.setHarvestLevel("pickaxe", 2, 2);
        this.setHarvestLevel("pickaxe", 2, 3);
        this.setHarvestLevel("pickaxe", 1, 4);
    }

    public static int getShiftedMeta(ItemStack sign) {
        if (sign.func_77973_b() instanceof ItemPoleSign) {
            if (sign.func_77960_j() == 1) {
                return 0;
            }
            if (sign.func_77960_j() == 2) {
                return 1;
            }
        } else if (sign.func_77973_b() instanceof ItemWaySign) {
            if (sign.func_77960_j() == 0) {
                return 2;
            }
            if (sign.func_77960_j() == 1) {
                return 3;
            }
            if (sign.func_77960_j() == 2) {
                return 4;
            }
        }
        return -1;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityWaySign(meta);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        TileEntityWaySign waySign = (TileEntityWaySign)world.func_147438_o(x, y, z);
        float minX = 0.0f;
        float maxX = 1.0f;
        float minY = 0.0f;
        float maxY = 1.0f;
        float minZ = 0.0f;
        float maxZ = 1.0f;
        switch (waySign.side) {
            case 0: {
                if (waySign.sign == null || waySign.sign.type != 4) break;
                maxY = 0.5f;
                break;
            }
            case 2: {
                maxZ = 0.0625f;
                break;
            }
            case 3: {
                minZ = 0.9375f;
                break;
            }
            case 4: {
                maxX = 0.0625f;
                break;
            }
            case 5: {
                minX = 0.9375f;
            }
        }
        this.func_149676_a(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        world.func_147438_o(x, y, z);
        if (world.field_72995_K) {
            RPGAdvMod.proxy.openGuiScreenWaypoint(world.field_73011_w.field_76574_g, x, y, z, GuiScreenWaypoint.WaypointType.WaySign, BlockWaySign.getShiftedMeta(stack));
        }
    }

    public void func_149681_a(World world, int x, int y, int z, int par5, EntityPlayer player) {
        if (!world.field_72995_K) {
            WaypointManager.INSTANCE.rmWaypoint(world.field_73011_w.field_76574_g, x, y, z);
            PacketManager.sendToDimension(new Packet0x0CClearFlypath(new CoordinateBlock(world.field_73011_w.field_76574_g, x, y, z)), world.field_73011_w.field_76574_g);
            if (!player.field_71075_bZ.field_75098_d) {
                Utils.dropStack(world, this.getCorrectSignDrop(world, x, y, z), x, y, z);
            }
        }
    }

    public boolean placeWaySign(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side) {
        int targetX = x + Facing.field_71586_b[side];
        int targetY = y + Facing.field_71587_c[side];
        int targetZ = z + Facing.field_71585_d[side];
        Block targetBlock = world.func_147439_a(targetX, targetY, targetZ);
        if (targetBlock.isAir((IBlockAccess)world, targetX, targetY, targetZ) || targetBlock.isReplaceable((IBlockAccess)world, targetX, targetY, targetZ)) {
            world.func_147465_d(targetX, targetY, targetZ, (Block)RPGAdvMod.blockWaySign, side, 3);
            TileEntityWaySign sign = (TileEntityWaySign)world.func_147438_o(targetX, targetY, targetZ);
            sign.side = Facing.field_71588_a[side];
            this.func_149689_a(world, targetX, targetY, targetZ, (EntityLivingBase)player, stack);
            this.func_149714_e(world, targetX, targetY, targetZ, side);
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
            }
            return true;
        }
        return false;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return SBRBlocks.rendererID;
    }

    public MapColor func_149728_f(int meta) {
        switch (meta) {
            case 0: 
            case 1: {
                return MapColor.field_151663_o;
            }
            default: {
                return MapColor.field_151668_h;
            }
            case 4: 
        }
        return MapColor.field_151665_m;
    }

    private ItemStack getCorrectSignDrop(World world, int x, int y, int z) {
        TileEntityWaySign waySign = (TileEntityWaySign)world.func_147438_o(x, y, z);
        if (waySign.sign != null) {
            switch (waySign.sign.type) {
                case 0: 
                case 1: {
                    return new ItemStack((Item)RPGAdvMod.itemPoleSign, 1, waySign.sign.type + 1);
                }
                case 2: 
                case 3: 
                case 4: {
                    return new ItemStack((Item)RPGAdvMod.itemWaySign, 1, waySign.sign.type - 2);
                }
            }
        }
        return new ItemStack((Item)RPGAdvMod.itemWaySign, 1, 2);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return this.getCorrectSignDrop(world, x, y, z);
    }

    public void func_149651_a(IIconRegister iconRegistrar) {
    }

    public IIcon func_149691_a(int side, int meta) {
        return Blocks.field_150348_b.func_149691_a(0, 0);
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityWaySign waySign = (TileEntityWaySign)world.func_147438_o(x, y, z);
        if (waySign.sign != null) {
            switch (waySign.sign.type) {
                default: {
                    return Blocks.field_150344_f.func_149691_a(0, 2);
                }
                case 1: {
                    return Blocks.field_150363_s.func_149691_a(2, 1);
                }
                case 2: 
                case 3: {
                    return Blocks.field_150339_S.func_149691_a(0, 0);
                }
                case 4: 
            }
            return Blocks.field_150347_e.func_149691_a(0, 0);
        }
        return Blocks.field_150348_b.func_149691_a(0, 0);
    }
}

