/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.ram.common;

import java.util.ArrayList;
import mcp.mobius.ram.common.SignModels;
import mcp.mobius.ram.server.CoordinateBlock;
import mcp.mobius.ram.server.WaypointManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class Sign {
    public WaypointManager.Waypoint destination;
    public float angleDegrees;
    public boolean flipped;
    public SignModels.SignOrientation arrowLocation = SignModels.SignOrientation.Right;
    public int type;
    public boolean waysign;
    public float bottomHeight = 0.0f;
    public float[] fontXScales = new float[3];
    public float[] lineXPos = new float[3];
    public String cachedDisplayText = new String();
    public float height = 0.5f;
    public float width = 1.0f;
    public double distToDest = 0.0;
    public String text;

    public Sign(WaypointManager.Waypoint waypoint, int type) {
        this.destination = waypoint;
        this.type = type;
        this.text = this.destination.name;
    }

    public Sign(WaypointManager.Waypoint waypoint, int type, CoordinateBlock poleCoord) {
        this.destination = waypoint;
        this.type = type;
        this.distToDest = Math.sqrt(poleCoord.distanceTo(waypoint.coord));
        this.text = this.destination.name;
    }

    public Sign(WaypointManager.Waypoint waypoint, int type, CoordinateBlock poleCoord, String name) {
        this.destination = waypoint;
        this.type = type;
        this.distToDest = Math.sqrt(poleCoord.distanceTo(waypoint.coord));
        this.text = name;
    }

    public Sign(NBTTagCompound signTag) {
        this.angleDegrees = signTag.func_74760_g("angle");
        this.flipped = signTag.func_74767_n("flipped");
        this.type = signTag.func_74762_e("type");
        this.bottomHeight = signTag.func_74760_g("bottomHeight");
        WaypointManager waypointManager = WaypointManager.INSTANCE;
        waypointManager.getClass();
        this.destination = new WaypointManager.Waypoint(waypointManager, (NBTTagCompound)signTag.func_74781_a("destination"));
        this.distToDest = signTag.func_74769_h("distToDest");
        this.arrowLocation = signTag.func_74767_n("arrowLeft") ? SignModels.SignOrientation.Left : SignModels.SignOrientation.Right;
        this.text = signTag.func_74779_i("text");
        this.waysign = signTag.func_74764_b("wallsign") ? signTag.func_74767_n("wallsign") : signTag.func_74767_n("waysign");
    }

    public void calculateAngleToDestination(CoordinateBlock origin) {
        if (origin.dim == this.destination.coord.dim) {
            int dX = origin.x - this.destination.coord.x;
            int dZ = origin.z - this.destination.coord.z;
            this.angleDegrees = (float)Math.toDegrees(Math.atan2(dZ, dX));
        }
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound signTag = new NBTTagCompound();
        signTag.func_74776_a("angle", this.angleDegrees);
        signTag.func_74757_a("flipped", this.flipped);
        signTag.func_74768_a("type", this.type);
        signTag.func_74776_a("bottomHeight", this.bottomHeight);
        signTag.func_74782_a("destination", (NBTBase)this.destination.toNBT());
        signTag.func_74780_a("distToDest", this.distToDest);
        signTag.func_74757_a("arrowLeft", this.arrowLocation == SignModels.SignOrientation.Left);
        signTag.func_74778_a("text", this.text);
        signTag.func_74757_a("waysign", this.waysign);
        return signTag;
    }

    public ArrayList<ForgeDirection> getSides() {
        ArrayList<ForgeDirection> directions = new ArrayList<ForgeDirection>();
        float angle = this.angleDegrees + 180.0f;
        if ((double)angle >= 135.0 && (double)angle <= 225.0) {
            directions.add(ForgeDirection.SOUTH);
        }
        if ((double)angle >= 225.0 && (double)angle <= 315.0) {
            directions.add(ForgeDirection.WEST);
        }
        if ((double)angle >= 315.0 && (double)angle <= 360.0 || (double)angle >= 0.0 && (double)angle <= 45.0) {
            directions.add(ForgeDirection.NORTH);
        }
        if ((double)angle >= 45.0 && (double)angle <= 135.0) {
            directions.add(ForgeDirection.EAST);
        }
        return directions;
    }
}

