/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.recipe;

import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import vazkii.botania.api.subtile.SubTileEntity;

public class RecipePureDaisy {
    Object input;
    Block output;
    int outputMeta;

    public RecipePureDaisy(Object input, Block output, int outputMeta) {
        this.input = input;
        this.output = output;
        this.outputMeta = outputMeta;
        if (input != null && !(input instanceof String) && !(input instanceof Block)) {
            throw new IllegalArgumentException("input must be an oredict String or a Block.");
        }
    }

    public boolean matches(World world, int x, int y, int z, SubTileEntity pureDaisy) {
        Block block = world.func_147439_a(x, y, z);
        world.func_72805_g(x, y, z);
        if (this.input instanceof Block && block == this.input) {
            return true;
        }
        ItemStack stack = new ItemStack(block, 1, world.func_72805_g(x, y, z));
        String oredict = (String)this.input;
        return this.isOreDict(stack, oredict);
    }

    public boolean isOreDict(ItemStack stack, String entry) {
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        for (ItemStack ostack : OreDictionary.getOres((String)entry)) {
            ItemStack cstack = ostack.func_77946_l();
            if (cstack.func_77960_j() == Short.MAX_VALUE) {
                cstack.func_77964_b(stack.func_77960_j());
            }
            if (!stack.func_77969_a(cstack)) continue;
            return true;
        }
        return false;
    }

    public boolean set(World world, int x, int y, int z, SubTileEntity pureDaisy) {
        if (!world.field_72995_K) {
            world.func_147465_d(x, y, z, this.output, this.outputMeta, 3);
        }
        return true;
    }

    public Object getInput() {
        return this.input;
    }

    public Block getOutput() {
        return this.output;
    }

    public int getOutputMeta() {
        return this.outputMeta;
    }
}

