/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.api_impl;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.FoodStats;
import net.minecraftforge.common.MinecraftForge;
import squeek.applecore.api.AppleCoreAPI;
import squeek.applecore.api.IAppleCoreAccessor;
import squeek.applecore.api.IAppleCoreMutator;
import squeek.applecore.api.food.FoodEvent;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.api.food.IEdible;
import squeek.applecore.api.hunger.ExhaustionEvent;
import squeek.applecore.api.hunger.HealthRegenEvent;
import squeek.applecore.api.hunger.StarvationEvent;

public enum AppleCoreAccessorMutatorImpl implements IAppleCoreAccessor,
IAppleCoreMutator
{
    INSTANCE;

    static final Field foodLevel;
    static final Field foodSaturationLevel;
    static final Field foodExhaustion;
    static final Field foodTimer;
    static final Field starveTimer;

    private AppleCoreAccessorMutatorImpl() {
        AppleCoreAPI.accessor = this;
        AppleCoreAPI.mutator = this;
    }

    @Override
    public boolean isFood(ItemStack food) {
        return this.isEdible(food) && this.getUnmodifiedFoodValues(food) != null;
    }

    private boolean isEdible(ItemStack food) {
        if (food == null || food.func_77973_b() == null) {
            return false;
        }
        if (food.func_77973_b() == Items.field_151105_aU || food.func_77973_b() instanceof ItemBlock) {
            return true;
        }
        EnumAction useAction = food.func_77973_b().func_77661_b(food);
        return useAction == EnumAction.eat || useAction == EnumAction.drink;
    }

    @Override
    public FoodValues getUnmodifiedFoodValues(ItemStack food) {
        if (food != null && food.func_77973_b() != null) {
            if (food.func_77973_b() instanceof IEdible) {
                return ((IEdible)food.func_77973_b()).getFoodValues(food);
            }
            if (food.func_77973_b() instanceof ItemFood) {
                return this.getItemFoodValues((ItemFood)food.func_77973_b(), food);
            }
            if (food.func_77973_b() == Items.field_151105_aU) {
                return new FoodValues(2, 0.1f);
            }
        }
        return null;
    }

    private FoodValues getItemFoodValues(ItemFood itemFood, ItemStack itemStack) {
        return new FoodValues(itemFood.func_150905_g(itemStack), itemFood.func_150906_h(itemStack));
    }

    @Override
    public FoodValues getFoodValues(ItemStack food) {
        FoodValues foodValues = this.getUnmodifiedFoodValues(food);
        if (foodValues != null) {
            FoodEvent.GetFoodValues event = new FoodEvent.GetFoodValues(food, foodValues);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.foodValues;
        }
        return null;
    }

    @Override
    public FoodValues getFoodValuesForPlayer(ItemStack food, EntityPlayer player) {
        FoodValues foodValues = this.getFoodValues(food);
        if (foodValues != null) {
            FoodEvent.GetPlayerFoodValues event = new FoodEvent.GetPlayerFoodValues(player, food, foodValues);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.foodValues;
        }
        return null;
    }

    @Override
    public float getExhaustion(EntityPlayer player) {
        try {
            return foodExhaustion.getFloat(player.func_71024_bL());
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    @Override
    public float getMaxExhaustion(EntityPlayer player) {
        ExhaustionEvent.GetMaxExhaustion event = new ExhaustionEvent.GetMaxExhaustion(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.maxExhaustionLevel;
    }

    @Override
    public int getHealthRegenTickPeriod(EntityPlayer player) {
        HealthRegenEvent.GetRegenTickPeriod event = new HealthRegenEvent.GetRegenTickPeriod(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.regenTickPeriod;
    }

    @Override
    public int getStarveDamageTickPeriod(EntityPlayer player) {
        StarvationEvent.GetStarveTickPeriod event = new StarvationEvent.GetStarveTickPeriod(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.starveTickPeriod;
    }

    @Override
    public void setExhaustion(EntityPlayer player, float exhaustion) {
        try {
            foodExhaustion.setFloat(player.func_71024_bL(), exhaustion);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setHunger(EntityPlayer player, int hunger) {
        try {
            foodLevel.setInt(player.func_71024_bL(), hunger);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setSaturation(EntityPlayer player, float saturation) {
        try {
            foodSaturationLevel.setFloat(player.func_71024_bL(), saturation);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setHealthRegenTickCounter(EntityPlayer player, int tickCounter) {
        try {
            foodTimer.setInt(player.func_71024_bL(), tickCounter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setStarveDamageTickCounter(EntityPlayer player, int tickCounter) {
        try {
            starveTimer.setInt(player.func_71024_bL(), tickCounter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        foodLevel = ReflectionHelper.findField(FoodStats.class, (String[])new String[]{"foodLevel", "field_75127_a", "a"});
        foodSaturationLevel = ReflectionHelper.findField(FoodStats.class, (String[])new String[]{"foodSaturationLevel", "field_75125_b", "b"});
        foodExhaustion = ReflectionHelper.findField(FoodStats.class, (String[])new String[]{"foodExhaustionLevel", "field_75126_c", "c"});
        foodTimer = ReflectionHelper.findField(FoodStats.class, (String[])new String[]{"foodTimer", "field_75123_d", "d"});
        starveTimer = ReflectionHelper.findField(FoodStats.class, (String[])new String[]{"starveTimer"});
        foodLevel.setAccessible(true);
        foodSaturationLevel.setAccessible(true);
        foodExhaustion.setAccessible(true);
        foodTimer.setAccessible(true);
        starveTimer.setAccessible(true);
    }
}

