/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thaumcraft.handlers;

import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.thaumcraft.ThaumcraftHelper;
import modtweaker2.mods.thaumcraft.recipe.MTInfusionRecipe;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.crafting.InfusionEnchantmentRecipe;
import thaumcraft.api.crafting.InfusionRecipe;

@ZenClass(value="mods.thaumcraft.Infusion")
public class Infusion {
    @ZenMethod
    public static void addRecipe(String key, IItemStack input, IItemStack[] recipe, String aspects, IItemStack result, int instability) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new InfusionRecipe(key, (Object)InputHelper.toStack(result), instability, ThaumcraftHelper.parseAspects(aspects), InputHelper.toStack(input), InputHelper.toStacks(recipe))));
    }

    @ZenMethod
    public static void addRecipe(String key, IItemStack input, IItemStack[] recipe, String aspects, IItemStack result, int instability, boolean fuzzyCentre, boolean[] fuzzyRecipe) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new MTInfusionRecipe(key, InputHelper.toStack(result), instability, ThaumcraftHelper.parseAspects(aspects), InputHelper.toStack(input), InputHelper.toStacks(recipe), fuzzyCentre, fuzzyRecipe)));
    }

    @ZenMethod
    public static void addEnchantment(String key, int enchantID, int instability, String aspects, IItemStack[] recipe) {
        MineTweakerAPI.apply((IUndoableAction)new AddEnchant(new InfusionEnchantmentRecipe(key, Enchantment.field_77331_b[enchantID], instability, ThaumcraftHelper.parseAspects(aspects), InputHelper.toStacks(recipe))));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(InputHelper.toStack(output)));
    }

    @ZenMethod
    public static void removeEnchant(int id) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveEnchant(Enchantment.field_77331_b[id]));
    }

    private static class RemoveEnchant
    implements IUndoableAction {
        Enchantment enchant;
        InfusionEnchantmentRecipe removed;

        public RemoveEnchant(Enchantment ench) {
            this.enchant = ench;
        }

        public void apply() {
            for (Object recipe : ThaumcraftApi.getCraftingRecipes()) {
                InfusionEnchantmentRecipe enchRecipe;
                if (!(recipe instanceof InfusionEnchantmentRecipe) || (enchRecipe = (InfusionEnchantmentRecipe)recipe).getEnchantment() != this.enchant) continue;
                this.removed = enchRecipe;
                ThaumcraftApi.getCraftingRecipes().remove(enchRecipe);
            }
        }

        public String describe() {
            return "Removing Infusion Enchantment Recipe: " + this.enchant.func_77320_a();
        }

        public boolean canUndo() {
            return this.removed != null;
        }

        public void undo() {
            ThaumcraftApi.getCraftingRecipes().add(this.removed);
        }

        public String describeUndo() {
            return "Restoring Infusion Enchantment Recipe: " + this.enchant.func_77320_a();
        }

        public String getOverrideKey() {
            return null;
        }
    }

    private static class Remove
    extends BaseListRemoval {
        public Remove(ItemStack stack) {
            super("Thaumcraft Infusion", ThaumcraftApi.getCraftingRecipes(), stack);
        }

        public void apply() {
            for (Object o : ThaumcraftApi.getCraftingRecipes()) {
                InfusionRecipe r;
                if (!(o instanceof InfusionRecipe) || (r = (InfusionRecipe)o).getRecipeOutput() == null || !(r.getRecipeOutput() instanceof ItemStack) || !StackHelper.areEqual((ItemStack)r.getRecipeOutput(), this.stack)) continue;
                this.recipe = r;
                break;
            }
            ThaumcraftApi.getCraftingRecipes().remove(this.recipe);
        }

        @Override
        public String getRecipeInfo() {
            return this.stack.func_82833_r();
        }
    }

    private static class AddEnchant
    implements IUndoableAction {
        InfusionEnchantmentRecipe recipe;

        public AddEnchant(InfusionEnchantmentRecipe inp) {
            this.recipe = inp;
        }

        public void apply() {
            ThaumcraftApi.getCraftingRecipes().add(this.recipe);
        }

        public String describe() {
            return "Adding Infusion Enchantment Recipe: " + this.recipe.enchantment.func_77320_a();
        }

        public boolean canUndo() {
            return this.recipe != null;
        }

        public void undo() {
            ThaumcraftApi.getCraftingRecipes().remove(this.recipe);
        }

        public String describeUndo() {
            return "Removing Infusion Enchantment Recipe: " + this.recipe.enchantment.func_77320_a();
        }

        public String getOverrideKey() {
            return null;
        }
    }

    private static class Add
    extends BaseListAddition {
        public Add(InfusionRecipe recipe) {
            super("Thaumcraft Infusion", ThaumcraftApi.getCraftingRecipes(), recipe);
        }

        @Override
        public String getRecipeInfo() {
            Object out = ((InfusionRecipe)this.recipe).getRecipeOutput();
            if (out instanceof ItemStack) {
                return ((ItemStack)out).func_82833_r();
            }
            return super.getRecipeInfo();
        }
    }
}

