/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thaumcraft.handlers;

import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.thaumcraft.ThaumcraftHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.crafting.CrucibleRecipe;

@ZenClass(value="mods.thaumcraft.Crucible")
public class Crucible {
    @ZenMethod
    public static void addRecipe(String key, IItemStack result, IIngredient catalyst, String aspects) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new CrucibleRecipe(key, InputHelper.toStack(result), InputHelper.toObject(catalyst), ThaumcraftHelper.parseAspects(aspects))));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(InputHelper.toStack(output)));
    }

    private static class Remove
    extends BaseListRemoval {
        public Remove(ItemStack stack) {
            super("Thaumcraft Crucible", ThaumcraftApi.getCraftingRecipes(), stack);
        }

        public void apply() {
            for (Object o : ThaumcraftApi.getCraftingRecipes()) {
                CrucibleRecipe r;
                if (!(o instanceof CrucibleRecipe) || (r = (CrucibleRecipe)o).getRecipeOutput() == null || !StackHelper.areEqual(r.getRecipeOutput(), this.stack)) continue;
                this.recipe = r;
                break;
            }
            ThaumcraftApi.getCraftingRecipes().remove(this.recipe);
        }

        @Override
        public String getRecipeInfo() {
            return this.stack.func_82833_r();
        }
    }

    private static class Add
    extends BaseListAddition {
        public Add(CrucibleRecipe recipe) {
            super("Thaumcraft Crucible", ThaumcraftApi.getCraftingRecipes(), recipe);
        }

        @Override
        public String getRecipeInfo() {
            return ((CrucibleRecipe)this.recipe).getRecipeOutput().func_82833_r();
        }
    }
}

