/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.railcraft.handlers;

import java.util.ArrayList;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import mods.railcraft.api.crafting.IBlastFurnaceRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import modtweaker2.helpers.InputHelper;
import modtweaker2.mods.railcraft.RailcraftHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.railcraft.BlastFurnace")
public class BlastFurnace {
    @ZenMethod
    public static void addRecipe(IItemStack input, boolean matchDamage, boolean matchNBT, int cookTime, IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Add(RailcraftHelper.getBlastFurnaceRecipe(InputHelper.toStack(input), matchDamage, matchNBT, cookTime, InputHelper.toStack(output))));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(InputHelper.toStack(output)));
    }

    private static class Remove
    extends BaseListRemoval {
        public Remove(ItemStack stack) {
            super("Blast Furnace", RailcraftHelper.furnace, stack);
        }

        public void apply() {
            ArrayList<IBlastFurnaceRecipe> recipesToRemove = new ArrayList<IBlastFurnaceRecipe>();
            for (IBlastFurnaceRecipe iBlastFurnaceRecipe : RailcraftHelper.furnace) {
                if (iBlastFurnaceRecipe.getOutput() == null || !this.stack.func_77969_a(iBlastFurnaceRecipe.getOutput())) continue;
                recipesToRemove.add(iBlastFurnaceRecipe);
            }
            for (IBlastFurnaceRecipe iBlastFurnaceRecipe : recipesToRemove) {
                RailcraftCraftingManager.blastFurnace.getRecipes().remove(iBlastFurnaceRecipe);
            }
        }

        @Override
        public String getRecipeInfo() {
            return this.stack.func_82833_r();
        }
    }

    private static class Add
    extends BaseListAddition {
        public Add(IBlastFurnaceRecipe recipe) {
            super("Blast Furnace", RailcraftHelper.furnace, recipe);
        }

        @Override
        public String getRecipeInfo() {
            return ((IBlastFurnaceRecipe)this.recipe).getOutput().func_82833_r();
        }
    }
}

