/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules;

import appeng.api.exceptions.MissingIngredientError;
import appeng.api.exceptions.RegistrationError;
import appeng.api.recipes.IIngredient;
import appeng.integration.IIntegrationModule;
import appeng.recipes.game.ShapedRecipe;
import appeng.recipes.game.ShapelessRecipe;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.Arrays;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import uristqwerty.CraftGuide.CraftGuideLog;
import uristqwerty.CraftGuide.DefaultRecipeTemplate;
import uristqwerty.CraftGuide.RecipeGeneratorImplementation;
import uristqwerty.CraftGuide.api.CraftGuideAPIObject;
import uristqwerty.CraftGuide.api.CraftGuideRecipe;
import uristqwerty.CraftGuide.api.ItemSlot;
import uristqwerty.CraftGuide.api.RecipeGenerator;
import uristqwerty.CraftGuide.api.RecipeProvider;
import uristqwerty.CraftGuide.api.RecipeTemplate;
import uristqwerty.CraftGuide.api.Slot;
import uristqwerty.CraftGuide.api.SlotType;
import uristqwerty.CraftGuide.api.StackInfo;
import uristqwerty.CraftGuide.api.StackInfoSource;
import uristqwerty.gui_craftguide.texture.DynamicTexture;
import uristqwerty.gui_craftguide.texture.Texture;
import uristqwerty.gui_craftguide.texture.TextureClip;

public class CraftGuide
extends CraftGuideAPIObject
implements IIntegrationModule,
RecipeProvider,
StackInfoSource,
RecipeGenerator {
    public static CraftGuide instance;
    private final Slot[] shapelessCraftingSlots = new ItemSlot[]{new ItemSlot(3, 3, 16, 16), new ItemSlot(21, 3, 16, 16), new ItemSlot(39, 3, 16, 16), new ItemSlot(3, 21, 16, 16), new ItemSlot(21, 21, 16, 16), new ItemSlot(39, 21, 16, 16), new ItemSlot(3, 39, 16, 16), new ItemSlot(21, 39, 16, 16), new ItemSlot(39, 39, 16, 16), new ItemSlot(59, 21, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT)};
    private final Slot[] craftingSlotsOwnBackground = new ItemSlot[]{new ItemSlot(3, 3, 16, 16).drawOwnBackground(), new ItemSlot(21, 3, 16, 16).drawOwnBackground(), new ItemSlot(39, 3, 16, 16).drawOwnBackground(), new ItemSlot(3, 21, 16, 16).drawOwnBackground(), new ItemSlot(21, 21, 16, 16).drawOwnBackground(), new ItemSlot(39, 21, 16, 16).drawOwnBackground(), new ItemSlot(3, 39, 16, 16).drawOwnBackground(), new ItemSlot(21, 39, 16, 16).drawOwnBackground(), new ItemSlot(39, 39, 16, 16).drawOwnBackground(), new ItemSlot(59, 21, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT).drawOwnBackground()};
    private final Slot[] smallCraftingSlotsOwnBackground = new ItemSlot[]{new ItemSlot(12, 12, 16, 16).drawOwnBackground(), new ItemSlot(30, 12, 16, 16).drawOwnBackground(), new ItemSlot(12, 30, 16, 16).drawOwnBackground(), new ItemSlot(30, 30, 16, 16).drawOwnBackground(), new ItemSlot(59, 21, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT).drawOwnBackground()};
    private final Slot[] craftingSlots = new ItemSlot[]{new ItemSlot(3, 3, 16, 16), new ItemSlot(21, 3, 16, 16), new ItemSlot(39, 3, 16, 16), new ItemSlot(3, 21, 16, 16), new ItemSlot(21, 21, 16, 16), new ItemSlot(39, 21, 16, 16), new ItemSlot(3, 39, 16, 16), new ItemSlot(21, 39, 16, 16), new ItemSlot(39, 39, 16, 16), new ItemSlot(59, 21, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT)};
    private final Slot[] smallCraftingSlots = new ItemSlot[]{new ItemSlot(12, 12, 16, 16), new ItemSlot(30, 12, 16, 16), new ItemSlot(12, 30, 16, 16), new ItemSlot(30, 30, 16, 16), new ItemSlot(59, 21, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT)};
    private final Slot[] furnaceSlots = new ItemSlot[]{new ItemSlot(13, 21, 16, 16), new ItemSlot(50, 21, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT)};
    RecipeGenerator parent;

    public String getInfo(ItemStack itemStack) {
        return null;
    }

    public void generateRecipes(RecipeGenerator generator) {
        RecipeTemplate smallCraftingTemplate;
        RecipeTemplate craftingTemplate;
        this.parent = generator;
        if (uristqwerty.CraftGuide.CraftGuide.newerBackgroundStyle) {
            craftingTemplate = generator.createRecipeTemplate(this.craftingSlotsOwnBackground, null);
            smallCraftingTemplate = generator.createRecipeTemplate(this.smallCraftingSlotsOwnBackground, null);
        } else {
            craftingTemplate = new DefaultRecipeTemplate(this.craftingSlots, RecipeGeneratorImplementation.workbench, (Texture)new TextureClip(DynamicTexture.instance((String)"recipe_backgrounds"), 1, 1, 79, 58), (Texture)new TextureClip(DynamicTexture.instance((String)"recipe_backgrounds"), 82, 1, 79, 58));
            smallCraftingTemplate = new DefaultRecipeTemplate(this.smallCraftingSlots, RecipeGeneratorImplementation.workbench, (Texture)new TextureClip(DynamicTexture.instance((String)"recipe_backgrounds"), 1, 61, 79, 58), (Texture)new TextureClip(DynamicTexture.instance((String)"recipe_backgrounds"), 82, 61, 79, 58));
        }
        DefaultRecipeTemplate shapelessTemplate = new DefaultRecipeTemplate(this.shapelessCraftingSlots, RecipeGeneratorImplementation.workbench, (Texture)new TextureClip(DynamicTexture.instance((String)"recipe_backgrounds"), 1, 121, 79, 58), (Texture)new TextureClip(DynamicTexture.instance((String)"recipe_backgrounds"), 82, 121, 79, 58));
        DefaultRecipeTemplate furnaceTemplate = new DefaultRecipeTemplate(this.furnaceSlots, new ItemStack(Blocks.field_150460_al), (Texture)new TextureClip(DynamicTexture.instance((String)"recipe_backgrounds"), 1, 181, 79, 58), (Texture)new TextureClip(DynamicTexture.instance((String)"recipe_backgrounds"), 82, 181, 79, 58));
        this.addCraftingRecipes(craftingTemplate, smallCraftingTemplate, (RecipeTemplate)shapelessTemplate, this);
        this.addGrinderRecipes((RecipeTemplate)furnaceTemplate, this);
        this.addInscriberRecipes((RecipeTemplate)furnaceTemplate, this);
    }

    private void addCraftingRecipes(RecipeTemplate template, RecipeTemplate templateSmall, RecipeTemplate templateShapeless, RecipeGenerator generator) {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        int errCount = 0;
        for (Object o : recipes) {
            try {
                IRecipe recipe = (IRecipe)o;
                Object[] items = generator.getCraftingRecipe(recipe, true);
                if (items.length == 5) {
                    generator.addRecipe(templateSmall, items);
                    continue;
                }
                if (recipe instanceof ShapelessRecipe) {
                    generator.addRecipe(templateShapeless, items);
                    continue;
                }
                generator.addRecipe(template, items);
            }
            catch (Exception e) {
                if (errCount >= 5) {
                    CraftGuideLog.log((String)"CraftGuide DefaultRecipeProvider: Stack trace limit reached, further stack traces from this invocation will not be logged to the console. They will still be logged to (.minecraft)/config/CraftGuide/CraftGuide.log", (boolean)true);
                    errCount = -1;
                } else {
                    e.printStackTrace();
                }
                ++errCount;
                CraftGuideLog.log((Throwable)e);
            }
        }
    }

    private void addGrinderRecipes(RecipeTemplate template, RecipeGenerator generator) {
    }

    private void addInscriberRecipes(RecipeTemplate template, RecipeGenerator generator) {
    }

    public RecipeTemplate createRecipeTemplate(Slot[] slots, ItemStack craftingType) {
        return this.parent.createRecipeTemplate(slots, craftingType);
    }

    public RecipeTemplate createRecipeTemplate(Slot[] slots, ItemStack craftingType, String backgroundTexture, int backgroundX, int backgroundY, int backgroundSelectedX, int backgroundSelectedY) {
        return this.parent.createRecipeTemplate(slots, craftingType, backgroundTexture, backgroundX, backgroundY, backgroundSelectedX, backgroundSelectedY);
    }

    public RecipeTemplate createRecipeTemplate(Slot[] slots, ItemStack craftingType, String backgroundTexture, int backgroundX, int backgroundY, String backgroundSelectedTexture, int backgroundSelectedX, int backgroundSelectedY) {
        return this.parent.createRecipeTemplate(slots, craftingType, backgroundTexture, backgroundX, backgroundY, backgroundSelectedTexture, backgroundSelectedX, backgroundSelectedY);
    }

    public void addRecipe(RecipeTemplate template, Object[] crafting) {
        this.parent.addRecipe(template, crafting);
    }

    public void addRecipe(CraftGuideRecipe recipe, ItemStack craftingType) {
        this.parent.addRecipe(recipe, craftingType);
    }

    public void setDefaultTypeVisibility(ItemStack type, boolean visible) {
        this.parent.setDefaultTypeVisibility(type, visible);
    }

    public Object[] getCraftingRecipe(IRecipe recipe) {
        return this.getCraftingRecipe(recipe, true);
    }

    Object[] getCraftingShapelessRecipe(List items, ItemStack recipeOutput) {
        Object[] output = new Object[10];
        for (int i = 0; i < items.size(); ++i) {
            output[i] = items.get(i);
            if (output[i] instanceof ItemStack[]) {
                output[i] = Arrays.asList((ItemStack[])output[i]);
            }
            if (!(output[i] instanceof IIngredient)) continue;
            try {
                output[i] = this.toCG(((IIngredient)output[i]).getItemStackSet());
                continue;
            }
            catch (RegistrationError ignored) {
                continue;
            }
            catch (MissingIngredientError ignored) {
                // empty catch block
            }
        }
        output[9] = recipeOutput;
        return output;
    }

    Object[] getSmallShapedRecipe(int width, int height, Object[] items, ItemStack recipeOutput) {
        Object[] output = new Object[5];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int i = y * 2 + x;
                output[i] = items[y * width + x];
                if (output[i] instanceof ItemStack[]) {
                    output[i] = Arrays.asList((ItemStack[])output[i]);
                }
                if (!(output[i] instanceof IIngredient)) continue;
                try {
                    output[i] = this.toCG(((IIngredient)output[i]).getItemStackSet());
                    continue;
                }
                catch (RegistrationError ignored) {
                    continue;
                }
                catch (MissingIngredientError ignored) {
                    // empty catch block
                }
            }
        }
        output[4] = recipeOutput;
        return output;
    }

    Object[] getCraftingShapedRecipe(int width, int height, Object[] items, ItemStack recipeOutput) {
        Object[] output = new Object[10];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int i = y * 3 + x;
                output[i] = items[y * width + x];
                if (output[i] instanceof ItemStack[]) {
                    output[i] = Arrays.asList((ItemStack[])output[i]);
                }
                if (!(output[i] instanceof IIngredient)) continue;
                try {
                    output[i] = this.toCG(((IIngredient)output[i]).getItemStackSet());
                    continue;
                }
                catch (RegistrationError ignored) {
                    continue;
                }
                catch (MissingIngredientError ignored) {
                    // empty catch block
                }
            }
        }
        output[9] = recipeOutput;
        return output;
    }

    private Object toCG(ItemStack[] itemStackSet) {
        List<ItemStack> list = Arrays.asList(itemStackSet);
        for (int x = 0; x < list.size(); ++x) {
            list.set(x, list.get(x).func_77946_l());
            if (list.get((int)x).field_77994_a != 0) continue;
            list.get((int)x).field_77994_a = 1;
        }
        return list;
    }

    public Object[] getCraftingRecipe(IRecipe recipe, boolean allowSmallGrid) {
        if (recipe instanceof ShapelessRecipe) {
            List items = (List)ReflectionHelper.getPrivateValue(ShapelessRecipe.class, (Object)((ShapelessRecipe)recipe), (String[])new String[]{"input"});
            return this.getCraftingShapelessRecipe(items, recipe.func_77571_b());
        }
        if (recipe instanceof ShapedRecipe) {
            int width = (Integer)ReflectionHelper.getPrivateValue(ShapedRecipe.class, (Object)((ShapedRecipe)recipe), (String[])new String[]{"width"});
            int height = (Integer)ReflectionHelper.getPrivateValue(ShapedRecipe.class, (Object)((ShapedRecipe)recipe), (String[])new String[]{"height"});
            Object[] items = (Object[])ReflectionHelper.getPrivateValue(ShapedRecipe.class, (Object)((ShapedRecipe)recipe), (String[])new String[]{"input"});
            if (allowSmallGrid && width < 3 && height < 3) {
                return this.getSmallShapedRecipe(width, height, items, recipe.func_77571_b());
            }
            return this.getCraftingShapedRecipe(width, height, items, recipe.func_77571_b());
        }
        return null;
    }

    @Override
    public void init() throws Throwable {
        StackInfo.addSource((StackInfoSource)this);
    }

    @Override
    public void postInit() {
    }
}

