/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.config.TunnelType;
import appeng.core.AELog;
import appeng.core.api.IIMCProcessor;
import appeng.core.api.imc.IMCBlackListSpatial;
import appeng.core.api.imc.IMCGrinder;
import appeng.core.api.imc.IMCMatterCannon;
import appeng.core.api.imc.IMCP2PAttunement;
import appeng.core.api.imc.IMCSpatial;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.HashMap;
import java.util.Map;

public class IMCHandler {
    private final Map<String, IIMCProcessor> processors = new HashMap<String, IIMCProcessor>();

    public IMCHandler() {
        this.processors.put("blacklist-block-spatial", new IMCBlackListSpatial());
        this.processors.put("whitelist-spatial", new IMCSpatial());
        this.processors.put("add-grindable", new IMCGrinder());
        this.processors.put("add-mattercannon-ammo", new IMCMatterCannon());
        for (TunnelType type : TunnelType.values()) {
            this.processors.put("add-p2p-attunement-" + type.name().replace('_', '-').toLowerCase(), new IMCP2PAttunement());
        }
    }

    public void handleIMCEvent(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            String key = message.key;
            try {
                IIMCProcessor handler = this.processors.get(key);
                if (handler != null) {
                    handler.process(message);
                    continue;
                }
                throw new IllegalStateException("Invalid IMC Called: " + key);
            }
            catch (Throwable t) {
                AELog.warning("Problem detected when processing IMC " + key + " from " + message.getSender(), new Object[0]);
                AELog.error(t);
            }
        }
    }
}

