/*
 * Decompiled with CFR 0.152.
 */
package squeek.tictooltips.helpers;

import java.text.DecimalFormat;
import java.util.HashMap;
import net.minecraft.util.StatCollector;
import squeek.tictooltips.helpers.RomanNumeralHelper;
import tconstruct.library.util.HarvestLevels;

public class StringHelper {
    private static DecimalFormat df = new DecimalFormat("##.##");
    public static HashMap<String, String> localizationAlternatives = new HashMap();

    public static String getHarvestLevelName(int num) {
        return HarvestLevels.getHarvestLevelName((int)num);
    }

    public static String getReinforcedString(int reinforced) {
        if (reinforced > 9) {
            return StringHelper.getLocalizedString("tool.unbreakable");
        }
        return StringHelper.getLocalizedString("tool.reinforced") + " " + RomanNumeralHelper.toRoman(reinforced);
    }

    public static String getDamageString(int attack) {
        String damageNum = StringHelper.getDamageNumberString(attack);
        String heart = Math.abs(attack) == 2 ? StringHelper.getLocalizedString("gui.partcrafter8") : StringHelper.getLocalizedString("gui.partcrafter9");
        return damageNum + heart;
    }

    public static String getDamageString(float attack) {
        return StringHelper.getDamageString((int)attack);
    }

    public static String getDamageNumberString(int attack) {
        return df.format((float)attack / 2.0f);
    }

    public static String getDamageNumberString(float attack) {
        return StringHelper.getDamageNumberString((int)attack);
    }

    public static String getShoddinessTypeString(float shoddiness) {
        return shoddiness > 0.0f ? StringHelper.getLocalizedString("material.stone.ability") : (shoddiness < 0.0f ? StringHelper.getLocalizedString("material.cactus.ability") : "");
    }

    public static String getShoddinessString(float shoddiness) {
        if ((float)((int)shoddiness) == shoddiness) {
            return Float.toString(Math.abs(shoddiness));
        }
        return df.format(Math.abs(shoddiness));
    }

    public static String getModifierString(float modifier) {
        return df.format(modifier) + "x";
    }

    public static String getSpeedString(int speed) {
        return df.format((float)speed / 100.0f);
    }

    public static String getArrowSpeedString(int speed) {
        return df.format(speed);
    }

    public static String getAccuracyString(float accuracy) {
        return df.format(accuracy - 4.0f) + "%";
    }

    public static String getDrawSpeedString(int drawSpeed) {
        return df.format((float)drawSpeed / 20.0f) + "s";
    }

    public static String getDurabilityString(int durability) {
        return durability != Integer.MAX_VALUE ? Integer.toString(durability) : StatCollector.func_74838_a((String)"tictooltips.infinite");
    }

    public static String getWeightString(float weight) {
        return df.format(weight);
    }

    public static String getArrowSpeedString(float arrowSpeed) {
        return df.format(arrowSpeed);
    }

    public static String getAmmoDamageRangeString(int attack) {
        int minAttack = attack;
        int maxAttack = attack * 2;
        String heart = StringHelper.getLocalizedString("gui.partcrafter9");
        return df.format((float)minAttack / 2.0f) + "-" + df.format((float)maxAttack / 2.0f) + heart;
    }

    public static String getDurationString(double duration) {
        return df.format(duration) + "s";
    }

    public static String getPercentageString(double percent) {
        return df.format(percent * 100.0) + "%";
    }

    public static String getBreakChanceString(float breakChance) {
        return StringHelper.getPercentageString(breakChance);
    }

    public static String getAmmoCountString(int ammo) {
        return StringHelper.getDurabilityString(ammo);
    }

    public static String getKnockbackString(float knockback) {
        return df.format(knockback);
    }

    public static String getAlternativeLocalizedString(String unlocalized) {
        String unlocalizedAlternative = localizationAlternatives.get(unlocalized);
        return unlocalizedAlternative != null ? StatCollector.func_74838_a((String)unlocalizedAlternative) : unlocalized;
    }

    public static String getLocalizedString(String unlocalized) {
        String localized = StatCollector.func_74838_a((String)unlocalized);
        if (localized.equals(unlocalized)) {
            return StringHelper.getAlternativeLocalizedString(unlocalized);
        }
        return localized;
    }

    static {
        localizationAlternatives.put("tool.unbreakable", "tictooltips.unbreakable");
        localizationAlternatives.put("tool.reinforced", "modifier.tool.reinforced");
    }
}

