/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import squeek.applecore.api.food.FoodEvent;
import squeek.spiceoflife.ModConfig;
import squeek.spiceoflife.compat.PacketDispatcher;
import squeek.spiceoflife.foodtracker.FoodEaten;
import squeek.spiceoflife.foodtracker.FoodHistory;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupRegistry;
import squeek.spiceoflife.foodtracker.foodqueue.FixedTimeQueue;
import squeek.spiceoflife.items.ItemFoodJournal;
import squeek.spiceoflife.network.PacketFoodEatenAllTime;
import squeek.spiceoflife.network.PacketFoodHistory;

public class FoodTracker {
    @SubscribeEvent
    public void onFoodEaten(FoodEvent.FoodEaten event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        FoodEaten foodEaten = new FoodEaten(event.food, event.player);
        foodEaten.foodValues = event.foodValues;
        foodEaten.foodGroup = FoodGroupRegistry.getFoodGroupForFood(event.food);
        FoodTracker.addFoodEatenByPlayer(foodEaten, event.player);
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer) {
            FoodHistory.get((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!(event.entityLiving instanceof EntityPlayer)) {
            return;
        }
        FoodHistory foodHistory = FoodHistory.get((EntityPlayer)event.entityLiving);
        foodHistory.deltaTicksActive(1L);
        if (ModConfig.USE_TIME_QUEUE) {
            FixedTimeQueue timeQueue = (FixedTimeQueue)foodHistory.getHistory();
            timeQueue.prune(event.entityLiving.field_70170_p.func_82737_E(), foodHistory.ticksActive);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ModConfig.sync((EntityPlayerMP)event.player);
        FoodGroupRegistry.sync((EntityPlayerMP)event.player);
        FoodHistory foodHistory = FoodHistory.get(event.player);
        foodHistory.validate();
        FoodTracker.syncFoodHistory(foodHistory);
        if (!foodHistory.wasGivenFoodJournal && (ModConfig.GIVE_FOOD_JOURNAL_ON_START || ModConfig.GIVE_FOOD_JOURNAL_ON_DIMINISHING_RETURNS && ModConfig.FOOD_EATEN_THRESHOLD == 0)) {
            ItemFoodJournal.giveToPlayer(event.player);
            foodHistory.wasGivenFoodJournal = true;
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        FoodHistory foodHistory = FoodHistory.get(event.player);
        FoodTracker.syncFoodHistory(foodHistory);
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() || !(event.entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entity;
        FoodHistory foodHistory = FoodHistory.get(player);
        foodHistory.saveNBTData(null);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        FoodHistory foodHistory = FoodHistory.get(event.player);
        foodHistory.loadNBTData(null);
        FoodTracker.syncFoodHistory(foodHistory);
    }

    @SubscribeEvent
    public void onClientConnectedToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            ModConfig.assumeClientOnly();
        }
    }

    public static void syncFoodHistory(FoodHistory foodHistory) {
        PacketDispatcher.get().sendTo(new PacketFoodEatenAllTime(foodHistory.totalFoodsEatenAllTime), (EntityPlayerMP)foodHistory.player);
        PacketDispatcher.get().sendTo(new PacketFoodHistory(foodHistory, true), (EntityPlayerMP)foodHistory.player);
    }

    public static boolean addFoodEatenByPlayer(FoodEaten foodEaten, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayerMP) {
            PacketDispatcher.get().sendTo(new PacketFoodHistory(foodEaten), (EntityPlayerMP)player);
        }
        return FoodHistory.get(player).addFood(foodEaten);
    }

    public static int getFoodHistoryCountOf(ItemStack food, EntityPlayer player) {
        return FoodHistory.get(player).getFoodCount(food);
    }

    public static int getFoodHistoryCountOfLastEatenBy(EntityPlayer player) {
        return FoodHistory.get(player).getFoodCount(FoodTracker.getFoodLastEatenBy(player));
    }

    public static int getFoodHistoryLengthInRelevantUnits(EntityPlayer player) {
        return FoodHistory.get(player).getHistoryLengthInRelevantUnits();
    }

    public static ItemStack getFoodLastEatenBy(EntityPlayer player) {
        return FoodHistory.get((EntityPlayer)player).getLastEatenFood().itemStack;
    }
}

