/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.block;

import cofh.api.core.IInitializer;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.block.ItemBlockStorage;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockStorage
extends Block
implements IInitializer {
    public static final String[] NAMES = new String[]{"copper", "tin", "silver", "lead", "nickel", "platinum", "mithril", "electrum", "invar", "bronze", "signalum", "lumium", "enderium"};
    public static final IIcon[] TEXTURES = new IIcon[NAMES.length];
    public static final int[] LIGHT = new int[]{0, 0, 4, 0, 0, 4, 8, 0, 0, 0, 7, 15, 4};
    public static final float[] HARDNESS = new float[]{5.0f, 5.0f, 5.0f, 4.0f, 10.0f, 5.0f, 30.0f, 4.0f, 20.0f, 5.0f, 5.0f, 5.0f, 40.0f};
    public static final float[] RESISTANCE = new float[]{6.0f, 6.0f, 6.0f, 12.0f, 6.0f, 6.0f, 120.0f, 6.0f, 12.0f, 6.0f, 9.0f, 9.0f, 120.0f};
    public static final int[] RARITY = new int[]{0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 1, 1, 2};
    public static ItemStack blockCopper;
    public static ItemStack blockTin;
    public static ItemStack blockSilver;
    public static ItemStack blockLead;
    public static ItemStack blockNickel;
    public static ItemStack blockPlatinum;
    public static ItemStack blockMithril;
    public static ItemStack blockElectrum;
    public static ItemStack blockInvar;
    public static ItemStack blockBronze;
    public static ItemStack blockSignalum;
    public static ItemStack blockLumium;
    public static ItemStack blockEnderium;

    public BlockStorage() {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149647_a(ThermalFoundation.tabCommon);
        this.func_149663_c("thermalfoundation.storage");
        this.setHarvestLevel("pickaxe", 2);
        this.setHarvestLevel("pickaxe", 1, 0);
        this.setHarvestLevel("pickaxe", 1, 1);
        this.setHarvestLevel("pickaxe", 3, 6);
        this.setHarvestLevel("pickaxe", 3, 12);
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < NAMES.length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public int getLightValue(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return LIGHT[iBlockAccess.func_72805_g(n, n2, n3)];
    }

    public int func_149709_b(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        return iBlockAccess.func_72805_g(n, n2, n3) == 10 ? 15 : 0;
    }

    public float func_149712_f(World world, int n, int n2, int n3) {
        return HARDNESS[world.func_72805_g(n, n2, n3)];
    }

    public float getExplosionResistance(Entity entity, World world, int n, int n2, int n3, double d, double d2, double d3) {
        return RESISTANCE[world.func_72805_g(n, n2, n3)];
    }

    public int func_149692_a(int n) {
        return n;
    }

    public boolean canCreatureSpawn(EnumCreatureType enumCreatureType, IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return false;
    }

    public boolean func_149744_f() {
        return true;
    }

    public boolean isBeaconBase(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4, int n5, int n6) {
        return true;
    }

    public IIcon func_149691_a(int n, int n2) {
        return TEXTURES[n2];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        for (int i = 0; i < NAMES.length; ++i) {
            BlockStorage.TEXTURES[i] = iIconRegister.func_94245_a("thermalfoundation:storage/Block_" + StringHelper.titleCase((String)NAMES[i]));
        }
    }

    public boolean preInit() {
        GameRegistry.registerBlock((Block)this, ItemBlockStorage.class, (String)"Storage");
        blockCopper = new ItemStack((Block)this, 1, 0);
        blockTin = new ItemStack((Block)this, 1, 1);
        blockSilver = new ItemStack((Block)this, 1, 2);
        blockLead = new ItemStack((Block)this, 1, 3);
        blockNickel = new ItemStack((Block)this, 1, 4);
        blockPlatinum = new ItemStack((Block)this, 1, 5);
        blockMithril = new ItemStack((Block)this, 1, 6);
        blockElectrum = new ItemStack((Block)this, 1, 7);
        blockInvar = new ItemStack((Block)this, 1, 8);
        blockBronze = new ItemStack((Block)this, 1, 9);
        blockSignalum = new ItemStack((Block)this, 1, 10);
        blockLumium = new ItemStack((Block)this, 1, 11);
        blockEnderium = new ItemStack((Block)this, 1, 12);
        ItemHelper.registerWithHandlers((String)"blockCopper", (ItemStack)blockCopper);
        ItemHelper.registerWithHandlers((String)"blockTin", (ItemStack)blockTin);
        ItemHelper.registerWithHandlers((String)"blockSilver", (ItemStack)blockSilver);
        ItemHelper.registerWithHandlers((String)"blockLead", (ItemStack)blockLead);
        ItemHelper.registerWithHandlers((String)"blockNickel", (ItemStack)blockNickel);
        ItemHelper.registerWithHandlers((String)"blockPlatinum", (ItemStack)blockPlatinum);
        ItemHelper.registerWithHandlers((String)"blockMithril", (ItemStack)blockMithril);
        ItemHelper.registerWithHandlers((String)"blockElectrum", (ItemStack)blockElectrum);
        ItemHelper.registerWithHandlers((String)"blockInvar", (ItemStack)blockInvar);
        ItemHelper.registerWithHandlers((String)"blockBronze", (ItemStack)blockBronze);
        ItemHelper.registerWithHandlers((String)"blockSignalum", (ItemStack)blockSignalum);
        ItemHelper.registerWithHandlers((String)"blockLumium", (ItemStack)blockLumium);
        ItemHelper.registerWithHandlers((String)"blockEnderium", (ItemStack)blockEnderium);
        return true;
    }

    public boolean initialize() {
        return true;
    }

    public boolean postInit() {
        ItemHelper.addStorageRecipe((ItemStack)blockCopper, (String)"ingotCopper");
        ItemHelper.addStorageRecipe((ItemStack)blockTin, (String)"ingotTin");
        ItemHelper.addStorageRecipe((ItemStack)blockSilver, (String)"ingotSilver");
        ItemHelper.addStorageRecipe((ItemStack)blockLead, (String)"ingotLead");
        ItemHelper.addStorageRecipe((ItemStack)blockNickel, (String)"ingotNickel");
        ItemHelper.addStorageRecipe((ItemStack)blockPlatinum, (String)"ingotPlatinum");
        ItemHelper.addStorageRecipe((ItemStack)blockMithril, (String)"ingotMithril");
        ItemHelper.addStorageRecipe((ItemStack)blockElectrum, (String)"ingotElectrum");
        ItemHelper.addStorageRecipe((ItemStack)blockInvar, (String)"ingotInvar");
        ItemHelper.addStorageRecipe((ItemStack)blockBronze, (String)"ingotBronze");
        ItemHelper.addStorageRecipe((ItemStack)blockSignalum, (String)"ingotSignalum");
        ItemHelper.addStorageRecipe((ItemStack)blockLumium, (String)"ingotLumium");
        ItemHelper.addStorageRecipe((ItemStack)blockEnderium, (String)"ingotEnderium");
        return true;
    }
}

