/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.fluid;

import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.repack.codechicken.lib.raytracer.IndexedCuboid6;
import cofh.repack.codechicken.lib.vec.Cuboid6;
import cofh.repack.codechicken.lib.vec.Vector3;
import cofh.thermaldynamics.duct.fluid.FluidGrid;
import cofh.thermaldynamics.duct.fluid.TileFluidDuct;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileFluidDuctFragile
extends TileFluidDuct {
    public static final int ROOM_TEMPERATURE = FluidRegistry.WATER.getTemperature();
    public static final int FREEZING_TEMPERATURE = 274;
    public static final int MELTING_TEMPERATURE = 800;
    public float internalTemperature = ROOM_TEMPERATURE;
    int prevTemperature = 0;

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74776_a("temp", this.internalTemperature);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.internalTemperature = nBTTagCompound.func_74760_g("temp");
    }

    @Override
    public void updateFluid() {
        if (!this.getDuctType().opaque) {
            this.sendRenderPacket();
        } else {
            this.sendOpaqueTempPacket();
        }
    }

    public void sendOpaqueTempPacket() {
        if (this.fluidGrid == null) {
            return;
        }
        int n = TileFluidDuctFragile.getTemperature(this.fluidGrid.getRenderFluid());
        if (n != this.prevTemperature) {
            n = this.prevTemperature;
            PacketTileInfo packetTileInfo = PacketTileInfo.newPacket((TileEntity)this);
            packetTileInfo.addByte(0);
            packetTileInfo.addByte((byte)4);
            packetTileInfo.addInt(n);
            PacketHandler.sendToAllAround((PacketBase)packetTileInfo, (TileEntity)this);
        }
    }

    @Override
    public void handleTileInfoPacketType(PacketCoFHBase packetCoFHBase, byte by) {
        if (by == 4) {
            this.internalTemperature = packetCoFHBase.getInt();
        } else {
            super.handleTileInfoPacketType(packetCoFHBase, by);
        }
    }

    @Override
    public MultiBlockGrid getNewGrid() {
        FluidGrid fluidGrid = new FluidGrid(((TileEntity)this).field_145850_b);
        fluidGrid.doesPassiveTicking = true;
        return fluidGrid;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick() {
        if (this.getDuctType().opaque ? this.internalTemperature > 800.0f : this.myRenderFluid != null && this.myRenderFluid.amount > 0 && TileFluidDuctFragile.getTemperature(this.myRenderFluid) > 800) {
            LinkedList<IndexedCuboid6> linkedList = new LinkedList<IndexedCuboid6>();
            this.addTraceableCuboids(linkedList);
            if (linkedList.size() == 0) {
                return;
            }
            Random random = ((TileEntity)this).field_145850_b.field_73012_v;
            Cuboid6 cuboid6 = (Cuboid6)linkedList.get(random.nextInt(linkedList.size()));
            Vector3 vector3 = cuboid6.max.sub(cuboid6.min).multiply(random.nextDouble(), random.nextDouble(), random.nextDouble()).add(cuboid6.min);
            ((TileEntity)this).field_145850_b.func_72869_a("smoke", vector3.x, vector3.y, vector3.z, 0.0, 0.0, 0.0);
        }
        super.randomDisplayTick();
    }

    @Override
    public boolean tickPass(int n) {
        if (!super.tickPass(n)) {
            return false;
        }
        if (n == 2) {
            FluidStack fluidStack = this.fluidGrid.getFluid();
            int n2 = TileFluidDuctFragile.getTemperature(fluidStack);
            this.internalTemperature += ((float)n2 - this.internalTemperature) * 5.0E-4f;
            if ((this.internalTemperature < 274.0f || this.internalTemperature > 800.0f) && ((TileEntity)this).field_145850_b.field_73012_v.nextInt(50) == 0) {
                if (fluidStack != null && fluidStack.amount > 0) {
                    fluidStack = fluidStack.copy();
                    if (fluidStack.amount < 100 || ((TileEntity)this).field_145850_b.field_73012_v.nextInt(5) == 0) {
                        this.fluidGrid.myTank.setFluid(null);
                    } else {
                        this.fluidGrid.myTank.drain(((TileEntity)this).field_145850_b.field_73012_v.nextInt(fluidStack.amount), false);
                    }
                }
                this.breakAndSpill(fluidStack);
                return false;
            }
        }
        return true;
    }

    public static int getTemperature(FluidStack fluidStack) {
        Fluid fluid;
        if (fluidStack != null && (fluid = fluidStack.getFluid()) != null) {
            return fluid.getTemperature(fluidStack);
        }
        return ROOM_TEMPERATURE;
    }

    public void breakAndSpill(FluidStack fluidStack) {
        ArrayList arrayList = this.func_145838_q().getDrops(this.world(), ((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e, this.func_145832_p(), 0);
        for (ItemStack itemStack : arrayList) {
            float f = 0.3f;
            double d = (double)(((TileEntity)this).field_145850_b.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(((TileEntity)this).field_145850_b.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d3 = (double)(((TileEntity)this).field_145850_b.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityItem = new EntityItem(((TileEntity)this).field_145850_b, (double)((TileEntity)this).field_145851_c + d, (double)((TileEntity)this).field_145848_d + d2, (double)((TileEntity)this).field_145849_e + d3, itemStack);
            entityItem.field_145804_b = 10;
            ((TileEntity)this).field_145850_b.func_72838_d((Entity)entityItem);
        }
        ((TileEntity)this).field_145850_b.func_147468_f(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        ((TileEntity)this).field_145850_b.func_72876_a(null, (double)((TileEntity)this).field_145851_c + 0.5, (double)((TileEntity)this).field_145848_d + 0.5, (double)((TileEntity)this).field_145849_e + 0.5, 0.5f, false);
        if (fluidStack != null && fluidStack.getFluid().canBePlacedInWorld()) {
            boolean bl;
            ItemStack itemStack;
            Fluid fluid = fluidStack.getFluid();
            itemStack = fluid.getBlock();
            boolean bl2 = bl = fluidStack.amount >= 1000 && ((TileEntity)this).field_145850_b.field_73012_v.nextInt(6) == 0;
            if ("water".equals(fluid.getName())) {
                itemStack = Blocks.field_150358_i;
            } else if ("lava".equals(fluid.getName())) {
                itemStack = Blocks.field_150356_k;
            }
            if (!"water".equals(fluid.getName()) || !((TileEntity)this).field_145850_b.func_72807_a((int)(((TileEntity)this).field_145851_c / 16), (int)(((TileEntity)this).field_145849_e / 16)).field_76791_y.toLowerCase().equals("hell")) {
                if (itemStack == Blocks.field_150358_i || itemStack == Blocks.field_150356_k) {
                    ((TileEntity)this).field_145850_b.func_147465_d(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e, (Block)itemStack, bl ? 0 : ((TileEntity)this).field_145850_b.field_73012_v.nextInt(6) + 1, 3);
                    ((TileEntity)this).field_145850_b.func_147464_a(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e, (Block)itemStack, ((TileEntity)this).field_145850_b.field_73012_v.nextInt(30) + 10);
                } else if (itemStack instanceof BlockFluidClassic) {
                    ((TileEntity)this).field_145850_b.func_147465_d(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e, (Block)itemStack, bl ? 0 : 1, 3);
                    ((TileEntity)this).field_145850_b.func_147464_a(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e, (Block)itemStack, ((TileEntity)this).field_145850_b.field_73012_v.nextInt(30) + 10);
                } else if (itemStack instanceof BlockFluidFinite && bl) {
                    ((TileEntity)this).field_145850_b.func_147465_d(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e, (Block)itemStack, 0, 3);
                    ((TileEntity)this).field_145850_b.func_147464_a(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e, (Block)itemStack, ((TileEntity)this).field_145850_b.field_73012_v.nextInt(30) + 10);
                }
                ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
            }
        }
    }
}

