/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.fluid;

import cofh.core.CoFHProps;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.attachments.filter.IFilterAttachment;
import cofh.thermaldynamics.duct.attachments.filter.IFilterFluid;
import cofh.thermaldynamics.duct.fluid.FluidGrid;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileFluidDuct
extends TileTDBase
implements IFluidHandler {
    public IFluidHandler[] cache;
    public IFilterFluid[] filterCache;
    IFluidHandler[] importantCache = new IFluidHandler[6];
    public FluidStack mySavedFluid;
    public FluidStack myRenderFluid = new FluidStack(0, 0);
    public FluidStack fluidForGrid;
    public FluidStack myConnectionFluid;
    public FluidGrid fluidGrid;

    @Override
    public MultiBlockGrid getNewGrid() {
        return new FluidGrid(((TileEntity)this).field_145850_b);
    }

    @Override
    public boolean isSignificantTile(TileEntity tileEntity, int n) {
        return FluidHelper.isFluidHandler((TileEntity)tileEntity) && !(tileEntity instanceof IMultiBlock);
    }

    @Override
    public boolean tickPass(int n) {
        if (!super.tickPass(n)) {
            return false;
        }
        if (this.fluidGrid == null || !this.cachesExist()) {
            return true;
        }
        if (n == 0) {
            int n2;
            int n3 = this.fluidGrid.toDistribute;
            int n4 = 0;
            for (n2 = this.internalSideCounter; n2 < this.neighborTypes.length && n4 < n3; ++n2) {
                if ((n4 += this.transfer(n2, n3 - n4)) < n3) continue;
                this.tickInternalSideCounter(n2 + 1);
                break;
            }
            for (n2 = 0; n2 < this.internalSideCounter && n4 < n3; ++n2) {
                if ((n4 += this.transfer(n2, n3 - n4)) < n3) continue;
                this.tickInternalSideCounter(n2 + 1);
                break;
            }
        }
        return true;
    }

    public int transfer(int n, int n2) {
        if (this.neighborTypes[n] != TileTDBase.NeighborTypes.OUTPUT || this.connectionTypes[n] == TileTDBase.ConnectionTypes.BLOCKED) {
            return 0;
        }
        if (this.cache[n] == null || this.fluidGrid.myTank.getFluid() == null) {
            return 0;
        }
        if (!this.filterCache[n].allowFluid(this.fluidGrid.myTank.getFluid())) {
            return 0;
        }
        FluidStack fluidStack = this.fluidGrid.myTank.getFluid().copy();
        fluidStack.amount = n2;
        int n3 = this.cache[n].fill(ForgeDirection.VALID_DIRECTIONS[n ^ 1], fluidStack, false);
        if (n3 > 0) {
            return this.cache[n].fill(ForgeDirection.VALID_DIRECTIONS[n ^ 1], this.fluidGrid.myTank.drain(n3, true), true);
        }
        return 0;
    }

    public int getLightValue() {
        if (this.getDuctType().opaque) {
            return 0;
        }
        if (ServerHelper.isClientWorld((World)this.world())) {
            return FluidHelper.getFluidLuminosity((FluidStack)this.myRenderFluid);
        }
        if (this.fluidGrid != null) {
            return FluidHelper.getFluidLuminosity((FluidStack)this.fluidGrid.getFluid());
        }
        return super.getLightValue();
    }

    public void updateFluid() {
        if (!this.getDuctType().opaque) {
            this.sendRenderPacket();
        }
    }

    public boolean shouldRenderInPass(int n) {
        return !this.getDuctType().opaque && this.myRenderFluid != null && super.shouldRenderInPass(n);
    }

    @Override
    public boolean isConnectable(TileEntity tileEntity, int n) {
        return tileEntity instanceof TileFluidDuct;
    }

    public FluidStack getConnectionFluid() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return this.myRenderFluid;
        }
        return this.fluidGrid == null ? this.myConnectionFluid : this.fluidGrid.getFluid();
    }

    @Override
    public void setGrid(MultiBlockGrid multiBlockGrid) {
        super.setGrid(multiBlockGrid);
        this.fluidGrid = (FluidGrid)multiBlockGrid;
    }

    @Override
    public void handleInfoPacket(PacketCoFHBase packetCoFHBase, boolean bl, EntityPlayer entityPlayer) {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            byte by = packetCoFHBase.getByte();
            this.handleTileInfoPacketType(packetCoFHBase, by);
        }
    }

    @Override
    public boolean cachesExist() {
        return this.cache != null;
    }

    @Override
    public void createCaches() {
        this.cache = new IFluidHandler[6];
        this.filterCache = new IFilterFluid[]{IFilterFluid.nullFilter, IFilterFluid.nullFilter, IFilterFluid.nullFilter, IFilterFluid.nullFilter, IFilterFluid.nullFilter, IFilterFluid.nullFilter};
    }

    @Override
    public void cacheImportant(TileEntity tileEntity, int n) {
        if (this.attachments[n] instanceof IFilterAttachment) {
            this.filterCache[n] = ((IFilterAttachment)((Object)this.attachments[n])).getFluidFilter();
        }
        this.cache[n] = (IFluidHandler)tileEntity;
    }

    @Override
    public void clearCache(int n) {
        this.filterCache[n] = IFilterFluid.nullFilter;
        this.cache[n] = null;
    }

    public void handleTileInfoPacketType(PacketCoFHBase packetCoFHBase, byte by) {
        if (by == 3) {
            this.myRenderFluid = packetCoFHBase.getFluidStack();
            ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
            ((TileEntity)this).field_145850_b.func_147451_t(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        }
    }

    @Override
    public void tileUnloading() {
        if (this.mySavedFluid != null && this.fluidGrid != null) {
            this.fluidGrid.myTank.drain(this.mySavedFluid.amount, true);
        }
    }

    public int getRenderFluidLevel() {
        return this.myRenderFluid == null ? 0 : this.myRenderFluid.amount;
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        if (this.fluidGrid != null) {
            packetCoFHBase.addFluidStack(this.fluidGrid.getRenderFluid());
        } else {
            packetCoFHBase.addFluidStack(this.myConnectionFluid != null ? this.myConnectionFluid : new FluidStack(0, 0));
        }
        return packetCoFHBase;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        this.myRenderFluid = packetCoFHBase.getFluidStack();
        if (((TileEntity)this).field_145850_b != null) {
            ((TileEntity)this).field_145850_b.func_147451_t(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        }
    }

    public void sendRenderPacket() {
        if (this.fluidGrid == null) {
            return;
        }
        if (!this.getDuctType().opaque) {
            PacketTileInfo packetTileInfo = PacketTileInfo.newPacket((TileEntity)this);
            packetTileInfo.addByte(0);
            packetTileInfo.addByte((byte)3);
            packetTileInfo.addFluidStack(this.fluidGrid.getRenderFluid());
            PacketHandler.sendToAllAround((PacketBase)packetTileInfo, (TileEntity)this);
        }
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (this.isOpen(forgeDirection)) {
            return this.fluidGrid.myTank.fill(fluidStack, bl);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (this.isOpen(forgeDirection)) {
            return this.fluidGrid.myTank.drain(fluidStack, bl);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        if (this.isOpen(forgeDirection)) {
            return this.fluidGrid.myTank.drain(n, bl);
        }
        return null;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return this.isOpen(forgeDirection);
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return this.isOpen(forgeDirection);
    }

    public boolean isOpen(ForgeDirection forgeDirection) {
        return this.fluidGrid != null && (forgeDirection == ForgeDirection.UNKNOWN || (this.neighborTypes[forgeDirection.ordinal()] == TileTDBase.NeighborTypes.OUTPUT || this.neighborTypes[forgeDirection.ordinal()] == TileTDBase.NeighborTypes.INPUT) && this.connectionTypes[forgeDirection.ordinal()] != TileTDBase.ConnectionTypes.BLOCKED);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        FluidTankInfo[] fluidTankInfoArray;
        if (this.fluidGrid != null) {
            FluidTankInfo[] fluidTankInfoArray2 = new FluidTankInfo[1];
            fluidTankInfoArray = fluidTankInfoArray2;
            fluidTankInfoArray2[0] = this.fluidGrid.myTank.getInfo();
        } else {
            fluidTankInfoArray = CoFHProps.EMPTY_TANK_INFO;
        }
        return fluidTankInfoArray;
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        if (this.fluidGrid != null && this.fluidGrid.hasValidFluid()) {
            this.mySavedFluid = this.fluidGrid.getNodeShare(this);
            this.mySavedFluid.writeToNBT(nBTTagCompound);
            nBTTagCompound.func_74782_a("ConnFluid", (NBTBase)new NBTTagCompound());
            this.myConnectionFluid = this.fluidGrid.getFluid().copy();
            this.myConnectionFluid.writeToNBT(nBTTagCompound.func_74775_l("ConnFluid"));
        } else {
            this.mySavedFluid = null;
            this.myConnectionFluid = null;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.fluidForGrid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nBTTagCompound);
        if (nBTTagCompound.func_74764_b("ConnFluid")) {
            this.myConnectionFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nBTTagCompound.func_74775_l("ConnFluid"));
        }
        if (this.fluidForGrid != null && this.fluidForGrid.fluidID == 0) {
            this.fluidForGrid = null;
        }
    }

    public class TileFluidPackets {
        public static final byte GUI_BUTTON = 0;
        public static final byte SET_FILTER = 1;
        public static final byte FILTERS = 2;
        public static final byte UPDATE_RENDER = 3;
        public static final byte TEMPERATURE = 4;
    }
}

