/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.fluid;

import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermaldynamics.duct.fluid.FluidGrid;
import gnu.trove.map.hash.TObjectIntHashMap;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidTankGrid
extends FluidTankAdv {
    public int fluidThroughput = 120;
    public int fluidPerConduit = 3000;
    public FluidGrid myMaster;
    static TObjectIntHashMap<String> fluidFlowrate = new TObjectIntHashMap();

    public FluidTankGrid(int n, FluidGrid fluidGrid) {
        super(n);
        this.myMaster = fluidGrid;
    }

    public void setFluid(FluidStack fluidStack) {
        if (fluidStack != null) {
            this.setFluidData(fluidStack);
        }
        super.setFluid(fluidStack);
    }

    public int fill(FluidStack fluidStack, boolean bl) {
        if (this.fluid == null && fluidStack != null) {
            this.setFluidData(fluidStack);
        }
        return super.fill(fluidStack, bl);
    }

    public void setFluidData(FluidStack fluidStack) {
        int n = 0;
        if (fluidStack != null) {
            n = FluidRegistry.getFluid((int)fluidStack.fluidID).getViscosity();
            this.fluidThroughput = MathHelper.clampI((int)(120000 / n), (int)80, (int)400);
            if (fluidFlowrate.containsKey((Object)fluidStack.getFluid().getName())) {
                this.fluidThroughput = fluidFlowrate.get((Object)fluidStack.getFluid().getName());
            }
            this.fluidThroughput = (int)((float)this.fluidThroughput * this.myMaster.getThroughPutModifier());
            this.fluidPerConduit = Math.min(25 * this.fluidThroughput, this.myMaster.getMaxFluidPerConduit());
        }
        this.myMaster.fluidChanged();
    }

    static {
        fluidFlowrate.put((Object)"steam", 360);
    }
}

