/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.servo;

import cofh.api.tileentity.IRedstoneControl;
import cofh.core.network.PacketCoFHBase;
import cofh.core.render.RenderUtils;
import cofh.lib.util.helpers.StringHelper;
import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.repack.codechicken.lib.vec.Translation;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.attachments.ConnectionBase;
import cofh.thermaldynamics.render.RenderDuct;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;

public abstract class ServoBase
extends ConnectionBase {
    public static final String[] NAMES = new String[]{"basic", "hardened", "reinforced", "signalum", "resonant"};
    static boolean[] redstoneControl = new boolean[]{true, true, true, true, true};

    public static void initialize() {
        String string = "Attachment.Servo.";
        for (int i = 0; i < NAMES.length; ++i) {
            ServoBase.redstoneControl[i] = ThermalDynamics.config.get(string + StringHelper.titleCase((String)NAMES[i]), "RedstoneControl", redstoneControl[i]);
        }
    }

    public ServoBase(TileTDBase tileTDBase, byte by) {
        super(tileTDBase, by);
    }

    public ServoBase(TileTDBase tileTDBase, byte by, int n) {
        super(tileTDBase, by, n);
    }

    @Override
    public String getName() {
        return "item.thermaldynamics.servo." + this.type + ".name";
    }

    @Override
    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        super.writeToNBT(nBTTagCompound);
        nBTTagCompound.func_74757_a("power", this.isPowered);
        if (this.canAlterRS()) {
            nBTTagCompound.func_74774_a("rsMode", (byte)this.rsMode.ordinal());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        super.readFromNBT(nBTTagCompound);
        this.isPowered = nBTTagCompound.func_74767_n("power");
        if (this.canAlterRS()) {
            this.rsMode = IRedstoneControl.ControlMode.values()[nBTTagCompound.func_74771_c("rsMode")];
        }
    }

    @Override
    public void addDescriptionToPacket(PacketCoFHBase packetCoFHBase) {
        super.addDescriptionToPacket(packetCoFHBase);
        packetCoFHBase.addBool(this.isPowered);
        if (this.canAlterRS()) {
            packetCoFHBase.addByte(this.rsMode.ordinal());
        }
    }

    @Override
    public void getDescriptionFromPacket(PacketCoFHBase packetCoFHBase) {
        super.getDescriptionFromPacket(packetCoFHBase);
        this.isPowered = packetCoFHBase.getBool();
        if (this.canAlterRS()) {
            this.rsMode = IRedstoneControl.ControlMode.values()[packetCoFHBase.getByte()];
        }
    }

    @Override
    public ItemStack getPickBlock() {
        return new ItemStack((Item)ThermalDynamics.itemServo, 1, this.type);
    }

    @Override
    public boolean canAlterRS() {
        return ServoBase.canAlterRS(this.type);
    }

    public static boolean canAlterRS(int n) {
        return redstoneControl[n % redstoneControl.length];
    }

    @Override
    public void onNeighborChange() {
        super.onNeighborChange();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean render(int n, RenderBlocks renderBlocks) {
        if (n == 1) {
            return false;
        }
        Translation translation = RenderUtils.getRenderVector((double)((double)((TileEntity)this.tile).field_145851_c + 0.5), (double)((double)((TileEntity)this.tile).field_145848_d + 0.5), (double)((double)((TileEntity)this.tile).field_145849_e + 0.5)).translation();
        RenderDuct.modelConnection[this.isPowered ? 1 : 2][this.side].render(new CCRenderState.IVertexOperation[]{translation, RenderUtils.getIconTransformation((IIcon)RenderDuct.servoTexture[this.type * 2 + (this.stuffed ? 1 : 0)])});
        return true;
    }

    @Override
    public boolean doesTick() {
        return true;
    }
}

