/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.debughelper;

import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class NoComodSet<E>
extends AbstractSet<E> {
    public final Set<E> set;
    int modCount = 0;

    public NoComodSet() {
        this(new HashSet());
    }

    public NoComodSet(Set<E> set) {
        this.set = set;
    }

    @Override
    public boolean add(E e) {
        this.updateModCount();
        return this.set.add(e);
    }

    public void updateModCount() {
        ++this.modCount;
    }

    @Override
    public void clear() {
        this.updateModCount();
        this.set.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.set.contains(object);
    }

    @Override
    public boolean remove(Object object) {
        this.updateModCount();
        return this.set.remove(object);
    }

    @Override
    public Iterator<E> iterator() {
        return new NoComodIterator(this.set.iterator());
    }

    @Override
    public int size() {
        return this.set.size();
    }

    public class NoComodIterator
    implements Iterator<E> {
        private final Iterator<E> iterator;
        int expectedModCount;

        public NoComodIterator(Iterator<E> iterator) {
            this.iterator = iterator;
            this.expectedModCount = NoComodSet.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.expectedModCount == NoComodSet.this.modCount && this.iterator.hasNext();
        }

        @Override
        public E next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

