/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.block;

import cofh.lib.util.helpers.ServerHelper;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.core.TickHandler;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import cofh.thermaldynamics.multiblock.MultiBlockFormer;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class SubTileMultiBlock
implements IMultiBlock {
    public MultiBlockGrid grid;
    private boolean isValid = true;
    public TileTDBase parent;
    public static final IMultiBlock[] BLANK = new IMultiBlock[0];

    public SubTileMultiBlock(TileTDBase tileTDBase) {
        this.parent = tileTDBase;
    }

    @Override
    public World world() {
        return this.parent.world();
    }

    @Override
    public int x() {
        return ((TileEntity)this.parent).field_145851_c;
    }

    @Override
    public int y() {
        return ((TileEntity)this.parent).field_145848_d + 1;
    }

    @Override
    public int z() {
        return ((TileEntity)this.parent).field_145849_e;
    }

    @Override
    public void setInvalidForForming() {
        this.isValid = false;
    }

    @Override
    public void setValidForForming() {
        this.isValid = true;
    }

    @Override
    public boolean isValidForForming() {
        return this.isValid;
    }

    @Override
    public abstract MultiBlockGrid getNewGrid();

    @Override
    public void setGrid(MultiBlockGrid multiBlockGrid) {
        this.grid = multiBlockGrid;
    }

    @Override
    public MultiBlockGrid getGrid() {
        return this.grid;
    }

    @Override
    public IMultiBlock getConnectedSide(byte by) {
        IMultiBlock iMultiBlock = this.parent.getConnectedSide(by);
        if (iMultiBlock.getClass() != this.parent.getClass()) {
            return null;
        }
        IMultiBlock[] iMultiBlockArray = iMultiBlock.getSubTiles();
        if (iMultiBlockArray != null) {
            for (IMultiBlock iMultiBlock2 : iMultiBlockArray) {
                if (!this.sameType(iMultiBlock2)) continue;
                return iMultiBlock2;
            }
        }
        return null;
    }

    @Override
    public boolean isBlockedSide(int n) {
        return this.parent.isBlockedSide(n);
    }

    public boolean sameType(IMultiBlock iMultiBlock) {
        return iMultiBlock.getClass() == this.getClass();
    }

    @Override
    public boolean isSideConnected(byte by) {
        return this.parent.isSideConnected(by) && this.getConnectedSide(by) != null;
    }

    @Override
    public void setNotConnected(byte by) {
    }

    @Override
    public void tickMultiBlock() {
        if (!this.parent.func_145837_r() && this.grid == null && ServerHelper.isServerWorld((World)this.parent.world())) {
            this.onNeighbourChange();
            this.formGrid();
        }
    }

    public void formGrid() {
        if (this.grid == null && ServerHelper.isServerWorld((World)this.parent.world())) {
            new MultiBlockFormer().formGrid(this);
        }
    }

    @Override
    public boolean tickPass(int n) {
        return false;
    }

    @Override
    public boolean isNode() {
        return false;
    }

    public void tileUnloading() {
    }

    @Override
    public boolean existsYet() {
        return this.parent.existsYet();
    }

    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        TickHandler.addMultiBlockToCalculate(this);
    }

    public void writeToNBT(NBTTagCompound nBTTagCompound) {
    }

    @Override
    public final IMultiBlock[] getSubTiles() {
        return BLANK;
    }

    public void onChunkUnload() {
        if (this.grid != null) {
            this.tileUnloading();
            this.grid.removeBlock(this);
        }
    }

    public void invalidate() {
        if (this.grid != null) {
            this.grid.removeBlock(this);
        }
    }

    public void onNeighbourChange() {
    }

    public void destroyAndRecreate() {
        if (this.grid != null) {
            this.grid.destroyAndRecreate();
        }
    }
}

