/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoaderException;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class Fluid {
    protected final String fluidName;
    protected String unlocalizedName;
    protected rf stillIcon;
    protected rf flowingIcon;
    protected int luminosity = 0;
    protected int density = 1000;
    protected int temperature = 295;
    protected int viscosity = 1000;
    protected boolean isGaseous;
    protected adq rarity = adq.a;
    protected aji block = null;
    private static Map<String, String> legacyNames = Maps.newHashMap();

    public Fluid(String fluidName) {
        this.fluidName = fluidName.toLowerCase(Locale.ENGLISH);
        this.unlocalizedName = fluidName;
    }

    public Fluid setUnlocalizedName(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
        return this;
    }

    public Fluid setBlock(aji block) {
        if (this.block == null || this.block == block) {
            this.block = block;
        } else if (!ForgeModContainer.forceDuplicateFluidBlockCrash) {
            FMLLog.warning("A mod has attempted to assign Block " + block + " to the Fluid '" + this.fluidName + "' but this Fluid has already been linked to BlockID " + this.block + ". Configure your mods to prevent this from happening.", new Object[0]);
        } else {
            FMLLog.severe("A mod has attempted to assign BlockID " + block + " to the Fluid '" + this.fluidName + "' but this Fluid has already been linked to BlockID " + this.block + ". Configure your mods to prevent this from happening.", new Object[0]);
            throw new LoaderException(new RuntimeException("A mod has attempted to assign BlockID " + block + " to the Fluid '" + this.fluidName + "' but this Fluid has already been linked to BlockID " + this.block + ". Configure your mods to prevent this from happening."));
        }
        return this;
    }

    public Fluid setLuminosity(int luminosity) {
        this.luminosity = luminosity;
        return this;
    }

    public Fluid setDensity(int density) {
        this.density = density;
        return this;
    }

    public Fluid setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public Fluid setViscosity(int viscosity) {
        this.viscosity = viscosity;
        return this;
    }

    public Fluid setGaseous(boolean isGaseous) {
        this.isGaseous = isGaseous;
        return this;
    }

    public Fluid setRarity(adq rarity) {
        this.rarity = rarity;
        return this;
    }

    public final String getName() {
        return this.fluidName;
    }

    public final int getID() {
        return FluidRegistry.getFluidID(this.fluidName);
    }

    public final aji getBlock() {
        return this.block;
    }

    public final boolean canBePlacedInWorld() {
        return this.block != null;
    }

    public String getLocalizedName(FluidStack stack) {
        return this.getLocalizedName();
    }

    @Deprecated
    public String getLocalizedName() {
        String s = this.getUnlocalizedName();
        return s == null ? "" : dd.a((String)s);
    }

    public String getUnlocalizedName(FluidStack stack) {
        return this.getUnlocalizedName();
    }

    public String getUnlocalizedName() {
        return "fluid." + this.unlocalizedName;
    }

    public final int getSpriteNumber() {
        return 0;
    }

    public final int getLuminosity() {
        return this.luminosity;
    }

    public final int getDensity() {
        return this.density;
    }

    public final int getTemperature() {
        return this.temperature;
    }

    public final int getViscosity() {
        return this.viscosity;
    }

    public final boolean isGaseous() {
        return this.isGaseous;
    }

    public adq getRarity() {
        return this.rarity;
    }

    public int getColor() {
        return 0xFFFFFF;
    }

    public final Fluid setStillIcon(rf stillIcon) {
        this.stillIcon = stillIcon;
        return this;
    }

    public final Fluid setFlowingIcon(rf flowingIcon) {
        this.flowingIcon = flowingIcon;
        return this;
    }

    public final Fluid setIcons(rf stillIcon, rf flowingIcon) {
        return this.setStillIcon(stillIcon).setFlowingIcon(flowingIcon);
    }

    public final Fluid setIcons(rf commonIcon) {
        return this.setStillIcon(commonIcon).setFlowingIcon(commonIcon);
    }

    public rf getIcon() {
        return this.getStillIcon();
    }

    public rf getStillIcon() {
        return this.stillIcon;
    }

    public rf getFlowingIcon() {
        return this.flowingIcon;
    }

    public int getLuminosity(FluidStack stack) {
        return this.getLuminosity();
    }

    public int getDensity(FluidStack stack) {
        return this.getDensity();
    }

    public int getTemperature(FluidStack stack) {
        return this.getTemperature();
    }

    public int getViscosity(FluidStack stack) {
        return this.getViscosity();
    }

    public boolean isGaseous(FluidStack stack) {
        return this.isGaseous();
    }

    public adq getRarity(FluidStack stack) {
        return this.getRarity();
    }

    public int getColor(FluidStack stack) {
        return this.getColor();
    }

    public rf getIcon(FluidStack stack) {
        return this.getIcon();
    }

    public int getLuminosity(ahb world, int x, int y2, int z2) {
        return this.getLuminosity();
    }

    public int getDensity(ahb world, int x, int y2, int z2) {
        return this.getDensity();
    }

    public int getTemperature(ahb world, int x, int y2, int z2) {
        return this.getTemperature();
    }

    public int getViscosity(ahb world, int x, int y2, int z2) {
        return this.getViscosity();
    }

    public boolean isGaseous(ahb world, int x, int y2, int z2) {
        return this.isGaseous();
    }

    public adq getRarity(ahb world, int x, int y2, int z2) {
        return this.getRarity();
    }

    public int getColor(ahb world, int x, int y2, int z2) {
        return this.getColor();
    }

    public rf getIcon(ahb world, int x, int y2, int z2) {
        return this.getIcon();
    }

    static String convertLegacyName(String fluidName) {
        return fluidName != null && legacyNames.containsKey(fluidName) ? legacyNames.get(fluidName) : fluidName;
    }

    public static void registerLegacyName(String legacyName, String canonicalName) {
        legacyNames.put(legacyName.toLowerCase(Locale.ENGLISH), canonicalName);
    }
}

