/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thaumcraft.api.wands.IWandable;
import tuhljin.automagy.codechicken.lib.vec.BlockCoord;
import tuhljin.automagy.items.ModItems;
import tuhljin.automagy.lib.AutomagyConfig;
import tuhljin.automagy.lib.RedstoneCalc;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.compat.CompatibilityManager;
import tuhljin.automagy.network.MessageFloatXYZ;
import tuhljin.automagy.network.MessageParticles;
import tuhljin.automagy.renderers.BlockThirstyTankRenderer;
import tuhljin.automagy.tiles.ITileWithTank;
import tuhljin.automagy.tiles.ModTileEntity;

public class TileEntityThirstyTank
extends ModTileEntity
implements ITileWithTank,
IWandable {
    public static final int MAX_STEPS = 32;
    public static final int CAPACITY_IN_BUCKETS_DEFAULT = 16;
    public static int CAPACITY_IN_BUCKETS_PER_UPGRADE = 16;
    public static int DRINK_FREQUENCY_DEFAULT = 30;
    public static float DRINK_FREQUENCY_UPGRADE_MULTIPLIER = 0.65f;
    public static int DRINK_EXTRA_COOLDOWN_OVER_TICK = 600;
    public static int DRINK_FREQUENCY_LONG = 80;
    public static int CONSUME_RATE = 5;
    public static int CONSUME_AMT_PER_UPGRADE = 100;
    public static int SIPHON_RATE = 5;
    public static int SIPHON_AMT_MAX = 150;
    public static int DRINK_FREQUENCY_RAIN = 5;
    public static int DRINK_FREQUENCY_RAIN_SOUND = 80;
    public static FluidStack rainwater = new FluidStack(FluidRegistry.WATER, 10);
    public static int MILKING_RANGE = 2;
    public static String KEY_TIME_MILKED = "timeMilked";
    public static FluidStack milk = new FluidStack(CompatibilityManager.milkBlock.getFluid(), 1000);
    public static FluidStack mushroomSoup = new FluidStack(CompatibilityManager.mushroomSoupBlock.getFluid(), 1000);
    public FluidTank tank;
    public boolean receivingSignal = false;
    protected int cooldown = DRINK_FREQUENCY_DEFAULT;
    protected int lastDirTry = 0;
    protected int rainTicks = 0;
    protected int cooldownConsume = 0;
    protected int cooldownSiphon = 0;
    protected int ticksSinceDrink = 0;
    public int[] glyphs = new int[6];
    public double liquidRenderHeight = -1.0;
    public boolean voids;
    public boolean redstoneControlled;
    public boolean preserves;
    public boolean siphons;
    public boolean milks;
    public int drinkFrequency = DRINK_FREQUENCY_DEFAULT;
    public int consumeAmt = 0;
    private long nextZap;

    public TileEntityThirstyTank() {
        this.tank = new FluidTank(16000);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.voids) {
            return this.fillVoiding(from, resource, doFill);
        }
        int i = this.tank.fill(resource, doFill);
        if (doFill && i != 0) {
            this.func_70296_d();
        }
        return i;
    }

    public int fillVoiding(ForgeDirection from, FluidStack resource, boolean doFill) {
        FluidStack fluid = this.tank.getFluid();
        int prevAmount = 0;
        if (fluid != null) {
            prevAmount = fluid.amount;
            fluid.amount = 0;
        }
        int i = this.tank.fill(resource, doFill);
        if (fluid != null) {
            fluid.amount = Math.min(fluid.amount + prevAmount, this.tank.getCapacity());
        }
        if (i == 0) {
            return 0;
        }
        if (doFill && (fluid == null || fluid.amount != prevAmount)) {
            this.func_70296_d();
        }
        return resource.amount;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        int amount;
        if (this.preserves && (amount = this.tank.getFluidAmount()) > 0) {
            maxDrain = Math.min(maxDrain, amount - 1);
        }
        FluidStack fluid = this.tank.drain(maxDrain, doDrain);
        if (doDrain && fluid != null) {
            this.func_70296_d();
        }
        return fluid;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.func_74764_b("Empty")) {
            this.tank.setFluid(null);
        } else {
            this.tank.readFromNBT(nbttagcompound);
        }
        this.glyphs = TileEntityThirstyTank.getIntArrayFromNbtOrDefault(nbttagcompound, "glyphs", 0, 6);
        this.updateGlyphEffects();
        this.receivingSignal = nbttagcompound.func_74767_n("receivingSignal");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        this.tank.writeToNBT(nbttagcompound);
        nbttagcompound.func_74783_a("glyphs", this.glyphs);
        nbttagcompound.func_74757_a("receivingSignal", this.receivingSignal);
    }

    public void updateGlyphEffects() {
        int capacity = 16;
        this.consumeAmt = 0;
        this.voids = false;
        this.redstoneControlled = false;
        this.preserves = false;
        this.siphons = false;
        this.milks = false;
        float drinkRate = DRINK_FREQUENCY_DEFAULT;
        block10: for (int i = 0; i < this.glyphs.length; ++i) {
            switch (this.glyphs[i]) {
                case 8: {
                    capacity += CAPACITY_IN_BUCKETS_PER_UPGRADE;
                    continue block10;
                }
                case 7: {
                    drinkRate *= DRINK_FREQUENCY_UPGRADE_MULTIPLIER;
                    continue block10;
                }
                case 1: {
                    this.voids = true;
                    continue block10;
                }
                case 2: {
                    this.consumeAmt += CONSUME_AMT_PER_UPGRADE;
                    continue block10;
                }
                case 5: {
                    this.redstoneControlled = true;
                    continue block10;
                }
                case 6: {
                    this.preserves = true;
                    continue block10;
                }
                case 3: {
                    this.siphons = true;
                    continue block10;
                }
                case 9: {
                    this.milks = true;
                }
            }
        }
        this.tank.setCapacity(1000 * capacity);
        this.drinkFrequency = Math.round(drinkRate);
    }

    public double getFractionFull() {
        return (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
    }

    public int getComparatorStrength() {
        return RedstoneCalc.getRedstoneSignalStrengthFromValues(this.tank.getFluidAmount(), this.tank.getCapacity());
    }

    public void setFluid(FluidStack fluidStack) {
        this.tank.setFluid(fluidStack);
        this.func_70296_d();
    }

    public void setGlyphs(int[] glyphs) {
        if (glyphs == null || glyphs.length != 6) {
            throw new IllegalArgumentException("Argument must be an array of length 6.");
        }
        this.glyphs = glyphs;
        if (this.field_145850_b != null) {
            this.updateGlyphEffects();
            this.func_70296_d();
        }
    }

    public boolean installGlyph(int glyph, int side) {
        if (side < 0 || side >= this.glyphs.length) {
            throw new IllegalArgumentException("Invalid side given as argument. Expected 0-" + this.glyphs.length + ". Got " + side + ".");
        }
        if (glyph != 0 && this.glyphs[side] == 0) {
            this.glyphs[side] = glyph;
            this.updateGlyphEffects();
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public int removeGlyph(int side) {
        if (side < 0 || side >= this.glyphs.length) {
            throw new IllegalArgumentException("Invalid side given as argument. Expected 0-" + this.glyphs.length + ". Got " + side + ".");
        }
        int drop = this.glyphs[side];
        if (drop != 0) {
            int newCapacity;
            if (drop == 8 && (newCapacity = this.tank.getCapacity() - 1000 * CAPACITY_IN_BUCKETS_PER_UPGRADE) < this.tank.getFluidAmount()) {
                return -1;
            }
            this.glyphs[side] = 0;
            this.updateGlyphEffects();
            this.func_70296_d();
        }
        return drop;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.consumeAmt > 0) {
                --this.cooldownConsume;
                if (this.cooldownConsume < 1) {
                    this.cooldownConsume = CONSUME_RATE;
                    int amtLeft = this.tank.getFluidAmount();
                    if (amtLeft > (this.preserves ? 1 : 0)) {
                        int toConsume = this.preserves ? Math.min(this.consumeAmt, amtLeft - 1) : this.consumeAmt;
                        this.drain(ForgeDirection.UNKNOWN, toConsume, true);
                    }
                }
            }
            if (this.siphons) {
                --this.cooldownSiphon;
                if (this.cooldownSiphon < 1) {
                    this.cooldownSiphon = SIPHON_RATE;
                    int available = this.tank.getFluidAmount();
                    if (this.preserves) {
                        --available;
                    }
                    if (available > 0) {
                        HashSet<ForgeDirection> siphonDirs = new HashSet<ForgeDirection>();
                        for (int i = 0; i < this.glyphs.length; ++i) {
                            ForgeDirection dir;
                            if (this.glyphs[i] != 3 || this.siphonInto(dir = ForgeDirection.getOrientation((int)i), 1, false) <= 0) continue;
                            siphonDirs.add(dir);
                        }
                        if (siphonDirs.size() > 0) {
                            int amtTaken = 0;
                            int share = Math.min(available, SIPHON_AMT_MAX) / siphonDirs.size();
                            if (share > 0) {
                                for (ForgeDirection dir : siphonDirs) {
                                    amtTaken += this.siphonInto(dir, share, true);
                                }
                                this.drain(ForgeDirection.UNKNOWN, amtTaken, true);
                            }
                        }
                    }
                }
            }
            if (this.redstoneControlled && !this.receivingSignal) {
                if (this.cooldown > 0) {
                    --this.cooldown;
                }
                return;
            }
            --this.cooldown;
            ++this.ticksSinceDrink;
            if (this.cooldown < 1) {
                int dirTry;
                if (this.milks) {
                    if (this.canMilk()) {
                        dirTry = this.lastDirTry;
                        do {
                            if (++dirTry > 5) {
                                dirTry = 0;
                            }
                            if (this.glyphs[dirTry] != 9) continue;
                            if (!this.doMilking(dirTry)) break;
                            this.ticksSinceDrink = 0;
                            break;
                        } while (dirTry != this.lastDirTry);
                        this.lastDirTry = dirTry;
                    }
                } else if (this.voids || this.tank.getCapacity() - this.tank.getFluidAmount() >= 1000) {
                    dirTry = this.lastDirTry;
                    Fluid fluidFound = null;
                    ForgeDirection dir = null;
                    int x = 0;
                    int y = 0;
                    int z = 0;
                    do {
                        if (++dirTry > 5) {
                            dirTry = 0;
                        }
                        if (this.glyphs[dirTry] == 3) continue;
                        dir = ForgeDirection.getOrientation((int)dirTry);
                        x = this.field_145851_c + dir.offsetX;
                        y = this.field_145848_d + dir.offsetY;
                        z = this.field_145849_e + dir.offsetZ;
                        if (this.glyphs[dirTry] == 4) {
                            TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
                            if (!(te instanceof IFluidHandler)) continue;
                            if (!this.pilferFluid((IFluidHandler)te, dir)) break;
                            this.ticksSinceDrink = 0;
                            break;
                        }
                        Block block = this.field_145850_b.func_147439_a(x, y, z);
                        fluidFound = this.getFluidIfValidBlock(block);
                    } while (fluidFound == null && dirTry != this.lastDirTry);
                    this.lastDirTry = dirTry;
                    if (fluidFound != null) {
                        boolean ok = false;
                        int added = 1000;
                        if (AutomagyConfig.thirstyTankPreserveInfiniteWater && fluidFound.getBlock() == Blocks.field_150355_j && this.field_145850_b.func_72805_g(x, y, z) == 0) {
                            if (!this.voids || this.tank.getFluidAmount() < this.tank.getCapacity()) {
                                ok = true;
                                MessageParticles.sendToClients(this.field_145850_b, x, y, z, 0, 0, 0, (short)7);
                            }
                        } else {
                            SourceLiquidResult result = this.findSourceLiquid(x, y, z, dir);
                            if (result != null) {
                                Block source = this.field_145850_b.func_147439_a(result.x, result.y, result.z);
                                if (source instanceof BlockFluidBase) {
                                    ((BlockFluidBase)source).drain(this.field_145850_b, result.x, result.y, result.z, true);
                                } else {
                                    this.field_145850_b.func_147468_f(result.x, result.y, result.z);
                                }
                                ok = true;
                                added = result.amount;
                                this.field_145850_b.func_72908_a((double)result.x, (double)result.y, (double)result.z, "random.drink", 0.2f, this.field_145850_b.field_73012_v.nextFloat() * 0.5f + this.field_145850_b.field_73012_v.nextFloat() * 0.25f + 0.5f);
                                MessageParticles.sendToClients(this.field_145850_b, result.x, result.y, result.z, 0, 0, 0, (short)7);
                            }
                        }
                        if (ok) {
                            this.fill(null, new FluidStack(fluidFound, added), true);
                            this.ticksSinceDrink = 0;
                            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "random.drink", 0.2f, this.field_145850_b.field_73012_v.nextFloat() * 0.25f + this.field_145850_b.field_73012_v.nextFloat() * 0.25f + 0.3f);
                        }
                    }
                }
                int n = this.cooldown = this.ticksSinceDrink > DRINK_EXTRA_COOLDOWN_OVER_TICK ? DRINK_FREQUENCY_LONG : this.drinkFrequency;
            }
            if (!this.milks && AutomagyConfig.thirstyTankDrinksRain && TjUtil.isPrecipitationAt(this.field_145850_b, this.field_145851_c, this.field_145849_e) && this.field_145850_b.func_72874_g(this.field_145851_c, this.field_145849_e) == this.field_145848_d + 1) {
                ++this.rainTicks;
                if (this.rainTicks % DRINK_FREQUENCY_RAIN == 0) {
                    int filled = this.fill(null, rainwater, true);
                    if (filled != 0 && this.rainTicks % DRINK_FREQUENCY_RAIN_SOUND == 0) {
                        this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "random.drink", 0.2f, this.field_145850_b.field_73012_v.nextFloat() * 0.25f + this.field_145850_b.field_73012_v.nextFloat() * 0.25f + 0.3f);
                    }
                    if (this.drinkFrequency < DRINK_FREQUENCY_DEFAULT && this.glyphs[this.field_145850_b.field_73012_v.nextInt(this.glyphs.length)] == 7) {
                        this.rainTicks = (int)((float)this.rainTicks + (float)DRINK_FREQUENCY_RAIN * 0.6666667f);
                    }
                }
            }
        }
    }

    public boolean canMilk() {
        if (this.voids ? this.tank.getFluidAmount() >= this.tank.getCapacity() : this.tank.getFluidAmount() + 1000 > this.tank.getCapacity()) {
            return false;
        }
        FluidStack fluid = this.tank.getFluid();
        return fluid == null || fluid.getFluid() == milk.getFluid() || fluid.getFluid() == mushroomSoup.getFluid();
    }

    public boolean doMilking(int dir) {
        double minx = (double)this.field_145851_c + 0.5 - ((double)MILKING_RANGE + 0.5);
        double miny = (double)this.field_145848_d + 0.5 - ((double)MILKING_RANGE + 0.5);
        double minz = (double)this.field_145849_e + 0.5 - ((double)MILKING_RANGE + 0.5);
        double maxx = (double)this.field_145851_c + 0.5 + ((double)MILKING_RANGE + 0.5);
        double maxy = (double)this.field_145848_d + 0.5 + ((double)MILKING_RANGE + 0.5);
        double maxz = (double)this.field_145849_e + 0.5 + ((double)MILKING_RANGE + 0.5);
        switch (dir) {
            case 0: {
                maxy = this.field_145848_d;
                miny = this.field_145848_d - 1 - MILKING_RANGE * 2;
                break;
            }
            case 1: {
                miny = this.field_145848_d + 1;
                maxy = this.field_145848_d + 2 + MILKING_RANGE * 2;
                break;
            }
            case 2: {
                maxz = this.field_145849_e;
                minz = this.field_145849_e - 1 - MILKING_RANGE * 2;
                break;
            }
            case 3: {
                minz = this.field_145849_e + 1;
                maxz = this.field_145849_e + 2 + MILKING_RANGE * 2;
                break;
            }
            case 4: {
                maxx = this.field_145851_c;
                minx = this.field_145851_c - 1 - MILKING_RANGE * 2;
                break;
            }
            case 5: {
                minx = this.field_145851_c + 1;
                maxx = this.field_145851_c + 2 + MILKING_RANGE * 2;
            }
        }
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)minx, (double)miny, (double)minz, (double)maxx, (double)maxy, (double)maxz);
        List entities = this.field_145850_b.func_72872_a(EntityCow.class, box);
        if (entities.size() > 0) {
            Long t = this.field_145850_b.func_82737_E();
            for (EntityCow cow : entities) {
                int amt;
                NBTTagCompound data = cow.getEntityData();
                if (t - data.func_74763_f(KEY_TIME_MILKED) < (long)AutomagyConfig.milkingCooldownPerCow || (amt = this.fill(ForgeDirection.UNKNOWN, cow instanceof EntityMooshroom ? mushroomSoup : milk, true)) <= 0) continue;
                data.func_74772_a(KEY_TIME_MILKED, t.longValue());
                cow.func_85030_a("mob.cow.hurt", 0.4f, (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                MessageFloatXYZ.sendToClients(this.field_145850_b, cow.field_70165_t - (double)cow.field_70130_N / 2.0, cow.field_70163_u + (double)cow.field_70131_O / 2.0, cow.field_70161_v - (double)cow.field_70130_N / 2.0, (short)1);
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "random.drink", 0.2f, this.field_145850_b.field_73012_v.nextFloat() * 0.25f + this.field_145850_b.field_73012_v.nextFloat() * 0.25f + 0.3f);
                return true;
            }
        }
        return false;
    }

    public boolean pilferFluid(IFluidHandler otherTank, ForgeDirection dir) {
        FluidStack gained;
        Fluid drainable;
        int amount = 1000;
        if (!this.voids) {
            amount = Math.min(amount, this.tank.getCapacity() - this.tank.getFluidAmount());
        }
        if (amount > 0 && (drainable = TjUtil.canDrainTank(otherTank, dir.getOpposite(), this.tank.getFluid())) != null && (gained = otherTank.drain(dir.getOpposite(), new FluidStack(drainable, amount), true)) != null && gained.amount > 0) {
            this.fill(dir, gained, true);
            MessageParticles.sendToClients(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, 0, 0, 0, (short)7);
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "random.drink", 0.2f, this.field_145850_b.field_73012_v.nextFloat() * 0.25f + this.field_145850_b.field_73012_v.nextFloat() * 0.25f + 0.3f);
            return true;
        }
        return false;
    }

    protected int siphonInto(ForgeDirection dir, int amount, boolean doFill) {
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
        if (te instanceof IFluidHandler) {
            FluidStack fluid = this.tank.getFluid();
            if (fluid == null) {
                return 0;
            }
            IFluidHandler otherTank = (IFluidHandler)te;
            if (!otherTank.canFill(dir.getOpposite(), fluid.getFluid())) {
                return 0;
            }
            fluid = fluid.copy();
            fluid.amount = amount;
            return otherTank.fill(dir.getOpposite(), fluid, doFill);
        }
        if (CompatibilityManager.fillBotaniaPetalApothecary(te, doFill)) {
            return amount;
        }
        return 0;
    }

    public Fluid getFluidIfValidBlock(Block block) {
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
        if (fluid != null) {
            FluidStack tankFluid = this.tank.getFluid();
            if (tankFluid == null) {
                return fluid;
            }
            return tankFluid.fluidID == fluid.getID() ? fluid : null;
        }
        return null;
    }

    public SourceLiquidResult findSourceLiquid(int x, int y, int z, ForgeDirection dir) {
        ArrayList<ForgeDirection> list = new ArrayList<ForgeDirection>();
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            if (d == dir || d == ForgeDirection.UP) continue;
            list.add(d);
        }
        Collections.shuffle(list);
        list.add(0, dir);
        if (dir != ForgeDirection.UP) {
            list.add(1, ForgeDirection.UP);
        }
        return this.findSourceLiquid(x, y, z, list, dir, 1, new HashSet<BlockCoord>());
    }

    private SourceLiquidResult findSourceLiquid(int x, int y, int z, ArrayList<ForgeDirection> dirs, ForgeDirection nextDir, int steps, HashSet<BlockCoord> seen) {
        BlockCoord coord = new BlockCoord(x, y, z);
        if (seen.contains(coord)) {
            return null;
        }
        seen.add(coord);
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        if (this.getFluidIfValidBlock(block) != null) {
            double distFurthest = TjUtil.getDistanceBetweenPoints_squared(this.field_145851_c, this.field_145848_d, this.field_145849_e, x, y, z);
            if (steps < 32) {
                SourceLiquidResult bestResult = null;
                SourceLiquidResult result = this.findSourceLiquid(x + nextDir.offsetX, y + nextDir.offsetY, z + nextDir.offsetZ, dirs, nextDir, steps + 1, seen);
                if (result != null && (bestResult == null || result.distance > distFurthest)) {
                    distFurthest = result.distance;
                    bestResult = result;
                }
                for (ForgeDirection dir : dirs) {
                    if (dir == nextDir || (result = this.findSourceLiquid(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dirs, dir, steps + 1, seen)) == null || bestResult != null && !(result.distance > distFurthest)) continue;
                    distFurthest = result.distance;
                    bestResult = result;
                }
                if (bestResult != null) {
                    return bestResult;
                }
            }
            if (this.field_145850_b.func_72805_g(x, y, z) == 0) {
                int added = 1000;
                if (block instanceof BlockFluidBase) {
                    if (!((BlockFluidBase)block).canDrain(this.field_145850_b, x, y, z)) {
                        return null;
                    }
                    FluidStack amt = ((BlockFluidBase)block).drain(this.field_145850_b, x, y, z, false);
                    added = amt.amount;
                    if (added < 1) {
                        return null;
                    }
                }
                return new SourceLiquidResult(block, x, y, z, distFurthest, added);
            }
        }
        return null;
    }

    @Override
    public boolean drainExactAmount(int amount, boolean doDrain) {
        FluidStack drained = this.drain(ForgeDirection.UNKNOWN, amount, false);
        if (drained.amount == amount) {
            if (doDrain) {
                this.drain(ForgeDirection.UNKNOWN, amount, true);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean fillExactAmount(FluidStack resource) {
        int amount = this.fill(ForgeDirection.UNKNOWN, resource, false);
        if (amount == resource.amount) {
            this.fill(ForgeDirection.UNKNOWN, resource, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean fillExactAmount(BlockFluidBase fluidBlock) {
        return this.fillExactAmount(new FluidStack(fluidBlock.getFluid(), 1000));
    }

    @Override
    public FluidTank getTank() {
        return this.tank;
    }

    public int onWandRightClick(World world, ItemStack wandstack, EntityPlayer player, int x, int y, int z, int side, int md) {
        if (!world.field_72995_K && player.func_70093_af()) {
            long currentTime;
            int glyph = this.removeGlyph(side);
            if (glyph > 0) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)side);
                TjUtil.dropItemIntoWorldSimple(new ItemStack((Item)ModItems.tankGlyph, 1, glyph), world, (double)x + 0.5 + (double)dir.offsetX * 0.6, (double)y + 0.5 + (double)dir.offsetY * 0.6, (double)z + 0.5 + (double)dir.offsetZ * 0.6);
                world.func_72956_a((Entity)player, "thaumcraft:zap", 0.5f, 1.0f);
            } else if (glyph == -1 && (currentTime = System.currentTimeMillis()) >= this.nextZap) {
                this.nextZap = currentTime + 1000L;
                ForgeDirection dir = ForgeDirection.getOrientation((int)side);
                player.func_70097_a(DamageSource.field_76376_m, 1.0f);
                ThaumcraftExtension.zapLocation(this.field_145850_b, (float)x + 0.5f + (float)dir.offsetX * 0.1f, (float)y + 0.5f + (float)dir.offsetY * 0.1f, (float)z + 0.5f + (float)dir.offsetZ * 0.1f, (float)player.field_70165_t, (float)player.field_70121_D.field_72338_b + player.eyeHeight, (float)player.field_70161_v);
            }
        }
        return 0;
    }

    public ItemStack onWandRightClick(World world, ItemStack wandstack, EntityPlayer player) {
        return null;
    }

    public void onUsingWandTick(ItemStack wandstack, EntityPlayer player, int count) {
    }

    public void onWandStoppedUsing(ItemStack wandstack, World world, EntityPlayer player, int count) {
    }

    public void updateRedstoneInput(boolean newSignal) {
        if (this.receivingSignal) {
            if (!newSignal) {
                this.receivingSignal = false;
                this.markDirty(false);
            }
        } else if (newSignal) {
            this.receivingSignal = true;
            this.markDirty(false);
        }
    }

    public boolean shouldRenderInPass(int pass) {
        BlockThirstyTankRenderer.renderPass = pass;
        return true;
    }

    public class SourceLiquidResult {
        Block block;
        int x;
        int y;
        int z;
        double distance;
        int amount;

        public SourceLiquidResult(Block block, int x, int y, int z, double distance, int amount) {
            this.block = block;
            this.x = x;
            this.y = y;
            this.z = z;
            this.distance = distance;
            this.amount = amount;
        }
    }
}

