/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.ItemApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.BlockCrystal;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.entities.EntityAspectOrb;
import thaumcraft.common.entities.golems.EntityGolemBase;
import tuhljin.automagy.api.AutomagyAPI;
import tuhljin.automagy.api.inventarium.IInventariumContentsProvider;
import tuhljin.automagy.blocks.IInventariumSlotUpgrade;
import tuhljin.automagy.blocks.ModBlocks;
import tuhljin.automagy.codechicken.lib.vec.BlockCoord;
import tuhljin.automagy.entities.GolemTaskData;
import tuhljin.automagy.gui.GUIScribe;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.inventory.FilteringItemList;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;
import tuhljin.automagy.lib.inventory.MappedItemsOrderedByTimeAdded;
import tuhljin.automagy.network.MessageParticles;
import tuhljin.automagy.tiles.IHasItemList;
import tuhljin.automagy.tiles.IInventariumMemoryUser;
import tuhljin.automagy.tiles.IReceivesItemListPacket;
import tuhljin.automagy.tiles.ModTileEntity;
import tuhljin.automagy.tiles.TileEntityUnseenScribe;

public class TileEntityInventarium
extends ModTileEntity
implements IHasItemList,
IReceivesItemListPacket {
    public static int MAX_INVNODES_START = 1;
    public static int MAX_INVNODES_INC_CLUSTER = 1;
    public static int MAXDISTANCE_START = 10;
    public static int MAXDISTANCE_INC_CLUSTER = 8;
    public static int STANDARD_SLOTS_PER_SHELF = 81;
    public static int MEMORYUSERS_PER_PROVIDER = 1;
    public static int RELATIVEMAX_Y_FOR_MEMORYBLOCK = -2;
    public static final String TAG_ITEMS_REQUESTED = "ItemsRequested";
    public static final String TAG_ITEMS_ENROUTE = "ItemsEnRoute";
    public static int REFRESH_RATE = 400;
    public static int MAX_PREFERRED_TIME = 12000;
    public static HashMap<Integer, HashSet<BlockCoord>> coreLocations = new HashMap();
    public int refreshCountdown = REFRESH_RATE;
    public int maxInvNodes;
    public int maxMemoryUsers;
    public int maxDistance;
    public int maxSlotsRead;
    public int usedSlots = 0;
    public int activeNodes = 0;
    private FilteringItemList itemList = null;
    private HashSet<BlockCoord> nodes = new HashSet();
    private HashSet<BlockCoord> memoryUsers = new HashSet();
    public static int VALIDITY_CHECK_FREQUENCY = 80;
    private int ticksSinceValidityCheck;
    private boolean addedToMap = false;
    protected static int getContentsIdentifier = 0;
    protected MappedItemsOrderedByTimeAdded requestedItems = new MappedItemsOrderedByTimeAdded("ItemsRequested");
    protected MappedItemsOrderedByTimeAdded requestedItemsEnRoute = new MappedItemsOrderedByTimeAdded("ItemsEnRoute");
    protected int lastTaskID = 0;
    protected Map<Integer, ItemStack> stacksEnRouteByTaskID = new HashMap<Integer, ItemStack>();
    protected Map<Integer, Boolean> taskReturning = new HashMap<Integer, Boolean>();
    private Map<HashableItemWithoutSize, Integer> requestsClaimedThisTick = new HashMap<HashableItemWithoutSize, Integer>();
    private boolean constructStrikeOne = false;
    private long timeMarkedAsPreferredLink = 0L;
    public int ticksToAnim = 0;
    private Object beam = null;
    public static int rotationSpeedFactor = 3240;
    public static double clientRenderFloatingTop = 0.1;
    public static double clientRenderFloatingBtm = -0.3;
    public int clientRenderRotationHelper = 0;
    public double clientRenderFloatingDistance = clientRenderFloatingTop;
    public boolean clientRenderGoingUp = false;

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.addedToMap) {
                HashSet<Object> bcs;
                int dimension = this.field_145850_b.field_73011_w.field_76574_g;
                if (coreLocations.containsKey(dimension)) {
                    bcs = coreLocations.get(dimension);
                } else {
                    bcs = new HashSet();
                    coreLocations.put(dimension, bcs);
                }
                bcs.add(new BlockCoord(this));
                this.addedToMap = true;
                this.checkMaxes();
            }
            this.itemList = null;
            this.requestsClaimedThisTick.clear();
            if (this.ticksSinceValidityCheck >= VALIDITY_CHECK_FREQUENCY) {
                this.ticksSinceValidityCheck = 0;
                if (!TileEntityInventarium.checkValidity((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false)) {
                    if (this.constructStrikeOne) {
                        this.func_145838_q().func_149697_b(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 0);
                        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    } else {
                        this.constructStrikeOne = true;
                        this.ticksSinceValidityCheck = VALIDITY_CHECK_FREQUENCY / 2;
                    }
                    return;
                }
                this.checkMaxes();
                this.constructStrikeOne = false;
            } else {
                ++this.ticksSinceValidityCheck;
            }
            if (this.field_145850_b.field_73012_v.nextInt(1500) == 0) {
                EntityAspectOrb orb = new EntityAspectOrb(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d - 0.5, (double)this.field_145849_e + 0.5, Aspect.ORDER, 1);
                this.field_145850_b.func_72838_d((Entity)orb);
            }
            --this.refreshCountdown;
            if (this.refreshCountdown < 1 && this.refreshCountdown == 0) {
                this.getItemList();
                this.refreshCountdown = REFRESH_RATE;
            }
        } else {
            if (this.ticksToAnim > 0) {
                --this.ticksToAnim;
                this.beam = Thaumcraft.proxy.beamBore(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.7, (double)this.field_145849_e + 0.5, (double)this.field_145851_c + 0.5, (double)(this.field_145848_d - 2), (double)this.field_145849_e + 0.5, 10, 0x9966FF, true, 10.0f, this.beam, 0);
            }
            this.clientRenderRotationHelper += 3;
            if (this.clientRenderRotationHelper >= rotationSpeedFactor) {
                this.clientRenderRotationHelper -= rotationSpeedFactor;
            }
            double adj = 0.0;
            if (this.clientRenderFloatingDistance < clientRenderFloatingBtm) {
                this.clientRenderGoingUp = true;
            } else if (this.clientRenderFloatingDistance > clientRenderFloatingTop) {
                this.clientRenderGoingUp = false;
            }
            this.clientRenderFloatingDistance += (adj += this.clientRenderGoingUp ? 0.002 : -0.002);
        }
    }

    public void checkMaxes() {
        int clusters = 0;
        int memoryProviders = 0;
        this.maxSlotsRead = 0;
        for (int x = -3; x < 4; ++x) {
            for (int y = -3; y < 4; ++y) {
                for (int z = -3; z < 4; ++z) {
                    Block block = this.field_145850_b.func_147439_a(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
                    int slots = TileEntityInventarium.getBookshelfSlotsProvidedAt(block, (IBlockAccess)this.field_145850_b, this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
                    if (slots > 0) {
                        this.maxSlotsRead += slots;
                        continue;
                    }
                    if (block instanceof BlockCrystal && this.field_145850_b.func_72805_g(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z) == 4) {
                        ++clusters;
                        continue;
                    }
                    if (y > RELATIVEMAX_Y_FOR_MEMORYBLOCK || block != ModBlocks.metalGlow) continue;
                    int md = this.field_145850_b.func_72805_g(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
                    if (md == 0) {
                        if (!TileEntityInventarium.neighborIsAmber((IBlockAccess)this.field_145850_b, this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z)) continue;
                        ++memoryProviders;
                        this.field_145850_b.func_72921_c(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z, 1, 3);
                        continue;
                    }
                    if (md != 1) continue;
                    if (TileEntityInventarium.neighborIsAmber((IBlockAccess)this.field_145850_b, this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z)) {
                        ++memoryProviders;
                        continue;
                    }
                    this.field_145850_b.func_72921_c(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z, 0, 3);
                }
            }
        }
        int oldDistance = this.maxDistance;
        this.maxDistance = MAXDISTANCE_START + MAXDISTANCE_INC_CLUSTER * clusters;
        int oldInvNodes = this.maxInvNodes;
        this.maxInvNodes = clusters + 1;
        if (this.maxInvNodes != oldInvNodes) {
            Iterator<BlockCoord> iter = this.nodes.iterator();
            while (iter.hasNext()) {
                BlockCoord entry = iter.next();
                if (this.getDistanceIfInRange(entry.x, entry.y, entry.z) != -1.0) continue;
                iter.remove();
                TileEntity te = this.field_145850_b.func_147438_o(entry.x, entry.y, entry.z);
                if (!(te instanceof TileEntityUnseenScribe)) continue;
                ((TileEntityUnseenScribe)te).breakLink();
            }
            if (this.nodes.size() > this.maxInvNodes) {
                int c = 0;
                HashSet<BlockCoord> newNodes = new HashSet<BlockCoord>();
                for (BlockCoord bc : this.nodes) {
                    if (++c <= this.maxInvNodes) {
                        newNodes.add(bc);
                        continue;
                    }
                    TileEntity te = this.field_145850_b.func_147438_o(bc.x, bc.y, bc.z);
                    if (!(te instanceof TileEntityUnseenScribe)) continue;
                    ((TileEntityUnseenScribe)te).breakLink();
                }
                this.nodes = newNodes;
            }
        }
        int oldMemoryUsers = this.maxMemoryUsers;
        this.maxMemoryUsers = memoryProviders * MEMORYUSERS_PER_PROVIDER;
        if (this.maxMemoryUsers != oldMemoryUsers || this.maxDistance != oldDistance) {
            Iterator<BlockCoord> iter = this.memoryUsers.iterator();
            while (iter.hasNext()) {
                BlockCoord entry = iter.next();
                if (this.getDistanceIfInRange(entry.x, entry.y, entry.z) != -1.0) continue;
                iter.remove();
                TileEntity te = this.field_145850_b.func_147438_o(entry.x, entry.y, entry.z);
                if (!(te instanceof IInventariumMemoryUser)) continue;
                ((IInventariumMemoryUser)te).breakLink();
            }
            if (this.memoryUsers.size() > this.maxMemoryUsers) {
                int c = 0;
                HashSet<BlockCoord> newNodes = new HashSet<BlockCoord>();
                for (BlockCoord bc : this.memoryUsers) {
                    if (++c <= this.maxMemoryUsers) {
                        newNodes.add(bc);
                        continue;
                    }
                    TileEntity te = this.field_145850_b.func_147438_o(bc.x, bc.y, bc.z);
                    if (!(te instanceof IInventariumMemoryUser)) continue;
                    ((IInventariumMemoryUser)te).breakLink();
                }
                this.memoryUsers = newNodes;
            }
            this.func_70296_d();
        }
    }

    public static boolean checkValidity(IBlockAccess blockaccess, int x, int y, int z, boolean placementCheck) {
        if (placementCheck) {
            ItemStack crystal = ItemApi.getBlock((String)"blockCrystal", (int)4);
            if (blockaccess.func_147439_a(x, y - 1, z) != Block.func_149634_a((Item)crystal.func_77973_b()) || blockaccess.func_72805_g(x, y - 1, z) != 4) {
                return false;
            }
        } else if (!blockaccess.func_147437_c(x, y - 1, z)) {
            return false;
        }
        if (!(blockaccess.func_147437_c(x - 1, y - 1, z - 1) && blockaccess.func_147437_c(x - 1, y - 1, z) && blockaccess.func_147437_c(x - 1, y - 1, z + 1) && blockaccess.func_147437_c(x, y - 1, z - 1) && blockaccess.func_147437_c(x, y - 1, z + 1) && blockaccess.func_147437_c(x + 1, y - 1, z - 1) && blockaccess.func_147437_c(x + 1, y - 1, z) && blockaccess.func_147437_c(x + 1, y - 1, z + 1) && blockaccess.func_147437_c(x - 1, y, z - 1) && blockaccess.func_147437_c(x - 1, y, z) && blockaccess.func_147437_c(x - 1, y, z + 1) && blockaccess.func_147437_c(x, y, z - 1) && blockaccess.func_147437_c(x, y, z + 1) && blockaccess.func_147437_c(x + 1, y, z - 1) && blockaccess.func_147437_c(x + 1, y, z) && blockaccess.func_147437_c(x + 1, y, z + 1))) {
            return false;
        }
        if (!TileEntityInventarium.blockIsAmber(blockaccess, x, y - 2, z)) {
            return false;
        }
        return TileEntityInventarium.blockIsBookshelf(blockaccess, x - 2, y - 1, z - 1) && TileEntityInventarium.blockIsBookshelf(blockaccess, x - 2, y - 1, z + 1) && TileEntityInventarium.blockIsBookshelf(blockaccess, x + 2, y - 1, z - 1) && TileEntityInventarium.blockIsBookshelf(blockaccess, x + 2, y - 1, z + 1) && TileEntityInventarium.blockIsBookshelf(blockaccess, x - 1, y - 1, z - 2) && TileEntityInventarium.blockIsBookshelf(blockaccess, x + 1, y - 1, z - 2) && TileEntityInventarium.blockIsBookshelf(blockaccess, x - 1, y - 1, z + 2) && TileEntityInventarium.blockIsBookshelf(blockaccess, x + 1, y - 1, z + 2);
    }

    public static boolean blockIsBookshelf(IBlockAccess blockaccess, int x, int y, int z) {
        return TileEntityInventarium.getBookshelfSlotsProvidedAt(blockaccess, x, y, z) > 0;
    }

    public static int getBookshelfSlotsProvidedAt(IBlockAccess blockaccess, int x, int y, int z) {
        return TileEntityInventarium.getBookshelfSlotsProvidedAt(blockaccess.func_147439_a(x, y, z), blockaccess, x, y, z);
    }

    private static int getBookshelfSlotsProvidedAt(Block block, IBlockAccess blockaccess, int x, int y, int z) {
        if (block == Blocks.field_150342_X) {
            return STANDARD_SLOTS_PER_SHELF;
        }
        if (block instanceof IInventariumSlotUpgrade) {
            return ((IInventariumSlotUpgrade)block).getInventariumSlotAllowance(blockaccess, x, y, z);
        }
        return 0;
    }

    public static boolean blockIsAmber(IBlockAccess blockaccess, int x, int y, int z) {
        int md;
        Block block = blockaccess.func_147439_a(x, y, z);
        return block == ConfigBlocks.blockCosmeticOpaque ? (md = blockaccess.func_72805_g(x, y, z)) == 0 || md == 1 : block == ModBlocks.translucent;
    }

    public static boolean neighborIsAmber(IBlockAccess blockaccess, int x, int y, int z) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!TileEntityInventarium.blockIsAmber(blockaccess, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)) continue;
            return true;
        }
        return false;
    }

    public void beginPlacementProcess() {
        ItemStack crystal = ItemApi.getBlock((String)"blockCrystal", (int)4);
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) != Block.func_149634_a((Item)crystal.func_77973_b()) || this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) != 4) {
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            TjUtil.dropItemIntoWorld(new ItemStack((Block)ModBlocks.inventariumCore), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return;
        }
        MessageParticles.sendToClients(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, (short)4);
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
    }

    @Override
    public FilteringItemList getItemList() {
        this.usedSlots = 0;
        if (this.field_145850_b.field_72995_K) {
            return this.itemList == null ? new FilteringItemList() : this.itemList;
        }
        if (this.itemList == null) {
            ++getContentsIdentifier;
            this.activeNodes = 0;
            int slotCount = 0;
            ArrayList<PairedContentsProvider> invs = new ArrayList<PairedContentsProvider>();
            HashSet<BlockCoord> invPos = new HashSet<BlockCoord>();
            Iterator<BlockCoord> iter = this.nodes.iterator();
            while (iter.hasNext()) {
                BlockCoord entry = iter.next();
                if (!TjUtil.isChunkLoaded(this.field_145850_b, entry.x, entry.z)) continue;
                TileEntity te = this.field_145850_b.func_147438_o(entry.x, entry.y, entry.z);
                if (!(te instanceof TileEntityUnseenScribe)) {
                    iter.remove();
                    continue;
                }
                TileEntityUnseenScribe scribe = (TileEntityUnseenScribe)te;
                if (scribe.linkX != this.field_145851_c && scribe.linkY != this.field_145848_d && scribe.linkZ != this.field_145849_e) {
                    iter.remove();
                    continue;
                }
                ArrayList<BlockCoord> bcs = scribe.getInventoryCoords();
                if (bcs == null) continue;
                ++this.activeNodes;
                boolean anyOmitted = false;
                for (BlockCoord bc : bcs) {
                    int slots;
                    IInventariumContentsProvider provider;
                    if (invPos.contains(bc)) continue;
                    invPos.add(bc);
                    TileEntity te2 = this.field_145850_b.func_147438_o(bc.x, bc.y, bc.z);
                    if (te2 == null || (provider = TileEntityInventarium.getContentsProvider(te2)) == null || (slots = provider.getSlotCount(te2, getContentsIdentifier)) <= 0) continue;
                    if (slotCount + slots <= this.maxSlotsRead) {
                        invs.add(new PairedContentsProvider(provider, te2));
                        slotCount += slots;
                        continue;
                    }
                    anyOmitted = true;
                }
                if (anyOmitted) {
                    if (!scribe.someSlotsOmitted) {
                        scribe.flagSlotsOmitted(true);
                    }
                } else if (scribe.someSlotsOmitted) {
                    scribe.flagSlotsOmitted(false);
                }
                if (this.activeNodes < this.maxInvNodes) continue;
                break;
            }
            this.itemList = new FilteringItemList().populateFromInventariumContentsProviders(invs, getContentsIdentifier);
            this.usedSlots = slotCount;
        }
        return this.activeNodes > 0 ? this.itemList : null;
    }

    public void verifyMemoryUsers() {
        Iterator<BlockCoord> iter = this.memoryUsers.iterator();
        while (iter.hasNext()) {
            BlockCoord entry = iter.next();
            if (!TjUtil.isChunkLoaded(this.field_145850_b, entry.x, entry.z)) continue;
            TileEntity te = this.field_145850_b.func_147438_o(entry.x, entry.y, entry.z);
            if (!(te instanceof IInventariumMemoryUser)) {
                iter.remove();
                continue;
            }
            if (((IInventariumMemoryUser)te).isLinkedTo(this)) continue;
            iter.remove();
        }
    }

    @Override
    public void receiveItemListPacket(ArrayList<ItemStack> list, boolean partial) {
        if (!partial || this.itemList == null) {
            this.itemList = new FilteringItemList(list, false);
        } else {
            for (ItemStack stack : list) {
                this.itemList.set(new HashableItemWithoutSize(stack), stack.field_77994_a > 0 ? stack.field_77994_a : 0);
            }
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui instanceof GUIScribe) {
                ((GUIScribe)gui).setStacks(this.getItemList(), false);
            }
        }
    }

    public void receiveItemsRequestedListPacket(ArrayList<ItemStack> list, boolean partial) {
        if (!partial) {
            this.requestedItems.setAll(list);
        } else {
            boolean needUpdate = false;
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            GUIScribe guiScribe = gui instanceof GUIScribe ? (GUIScribe)gui : null;
            for (ItemStack stack : list) {
                int amt;
                HashableItemWithoutSize item = new HashableItemWithoutSize(stack);
                this.requestedItems.set(item, stack.field_77994_a);
                if (guiScribe == null || (amt = guiScribe.getDisplayedRequestAmount(item)) != 0 && amt == stack.field_77994_a) continue;
                needUpdate = true;
            }
            if (needUpdate) {
                guiScribe.updateRequestedItems(this.getRequestedItems());
            }
        }
    }

    public void receiveRequestFromClient(ItemStack stack, boolean rearrange) {
        if (stack != null) {
            if (stack.field_77994_a > 0) {
                this.requestedItems.add(stack, rearrange);
                this.markDirty(false);
            } else if (stack.field_77994_a < 0) {
                stack.field_77994_a *= -1;
                this.requestedItems.subtract(stack);
                this.markDirty(false);
            }
        }
    }

    public MappedItemsOrderedByTimeAdded getRequestedItems() {
        return this.requestedItems;
    }

    public int getRequestedAmountEnRoute(HashableItemWithoutSize item) {
        return this.requestedItemsEnRoute.get(item);
    }

    public void markRequestEnRoute(EntityGolemBase golem, ItemStack stack) {
        ++this.lastTaskID;
        while (this.lastTaskID == 0 || this.stacksEnRouteByTaskID.containsKey(this.lastTaskID)) {
            ++this.lastTaskID;
        }
        this.requestedItemsEnRoute.add(stack, false);
        this.stacksEnRouteByTaskID.put(this.lastTaskID, stack);
        GolemTaskData.setTaskID(golem, this.lastTaskID);
        this.markDirty(false);
    }

    public boolean markRequestPhaseTwo(EntityGolemBase golem) {
        int id = GolemTaskData.get(golem).getTaskID();
        ItemStack claimStack = this.stacksEnRouteByTaskID.get(id);
        if (claimStack != null) {
            ItemStack carriedStack = golem.getCarried();
            if (TjUtil.areItemsEqualIgnoringSize(claimStack, carriedStack) && carriedStack.field_77994_a > 0) {
                if (claimStack.field_77994_a > carriedStack.field_77994_a) {
                    ItemStack sub = claimStack.func_77946_l();
                    sub.field_77994_a = claimStack.field_77994_a - carriedStack.field_77994_a;
                    this.requestedItemsEnRoute.subtract(sub);
                    this.stacksEnRouteByTaskID.put(id, carriedStack.func_77946_l());
                } else if (claimStack.field_77994_a < carriedStack.field_77994_a) {
                    ThaumcraftExtension.limitGolemCarrying(golem, claimStack.field_77994_a);
                }
                this.taskReturning.put(id, true);
                return true;
            }
            this.requestFailedByGolem(golem);
            ThaumcraftExtension.limitGolemCarrying(golem, 0);
        }
        return false;
    }

    public void requestFulfilledByGolem(EntityGolemBase golem) {
        int id = GolemTaskData.get(golem).getTaskID();
        ItemStack stack = this.stacksEnRouteByTaskID.get(id);
        if (stack != null) {
            this.requestedItems.subtract(stack);
            this.requestedItemsEnRoute.subtract(stack);
            this.stacksEnRouteByTaskID.remove(id);
            this.taskReturning.remove(id);
            GolemTaskData.clearTaskID(golem);
            ThaumcraftExtension.clearGolemItemFilter(golem);
            this.markDirty(false);
        }
    }

    public void requestFailedByGolem(EntityGolemBase golem) {
        int id = GolemTaskData.get(golem).getTaskID();
        ItemStack stack = this.stacksEnRouteByTaskID.get(id);
        if (stack != null) {
            this.requestedItemsEnRoute.subtract(stack);
            this.stacksEnRouteByTaskID.remove(id);
            this.taskReturning.remove(id);
            GolemTaskData.clearTaskID(golem);
            ThaumcraftExtension.clearGolemItemFilter(golem);
            this.markDirty(false);
        }
    }

    public void golemContinueClaim(EntityGolemBase golem, int taskID) {
        ItemStack claimStack = this.stacksEnRouteByTaskID.get(taskID);
        if (claimStack == null) {
            GolemTaskData.clearTaskID(golem);
            ThaumcraftExtension.clearGolemItemFilter(golem);
            ThaumcraftExtension.limitGolemCarrying(golem, 0);
        } else {
            int available;
            HashableItemWithoutSize item = new HashableItemWithoutSize(claimStack);
            Integer claimedThisTick = this.requestsClaimedThisTick.get(item);
            if (claimedThisTick == null) {
                claimedThisTick = 0;
            }
            if ((available = this.requestedItems.get(item) - claimedThisTick) < 1) {
                this.requestFailedByGolem(golem);
                ThaumcraftExtension.limitGolemCarrying(golem, 0);
            } else {
                if (available < claimStack.field_77994_a) {
                    ItemStack sub = claimStack.func_77946_l();
                    sub.field_77994_a = claimStack.field_77994_a - available;
                    this.requestedItemsEnRoute.subtract(sub);
                    claimStack.field_77994_a = available;
                    this.stacksEnRouteByTaskID.put(taskID, claimStack);
                    ThaumcraftExtension.setGolemItemFilter(golem, claimStack);
                    ThaumcraftExtension.limitGolemCarrying(golem, available);
                }
                this.requestsClaimedThisTick.put(item, claimedThisTick + claimStack.field_77994_a);
            }
        }
    }

    public boolean isTaskInPhaseTwo(int taskID) {
        Boolean returning = this.taskReturning.get(taskID);
        if (returning == null) {
            return false;
        }
        return returning;
    }

    public static boolean isGolemEnRoute(EntityGolemBase golem) {
        return GolemTaskData.get(golem).getTaskID() != 0;
    }

    public void func_145843_s() {
        int dimension;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && coreLocations.containsKey(dimension = this.field_145850_b.field_73011_w.field_76574_g)) {
            HashSet<BlockCoord> bcs = coreLocations.get(dimension);
            bcs.remove(new BlockCoord(this));
        }
        super.func_145843_s();
    }

    public static TileEntityInventarium getCoreNear(World world, int x, int y, int z) {
        int dimension = world.field_73011_w.field_76574_g;
        if (!coreLocations.containsKey(dimension)) {
            return null;
        }
        HashSet<BlockCoord> bcs = coreLocations.get(dimension);
        TileEntityInventarium closest = null;
        double closestDistance = Double.MAX_VALUE;
        long currentWorldTime = world.func_82737_E();
        long mostPreferredLinkTime = 0L;
        for (BlockCoord bc : bcs) {
            TileEntity te;
            if (!TjUtil.isChunkLoaded(world, bc.x, bc.z) || !((te = world.func_147438_o(bc.x, bc.y, bc.z)) instanceof TileEntityInventarium)) continue;
            TileEntityInventarium teI = (TileEntityInventarium)te;
            double d = teI.getDistanceIfInRange(x, y, z);
            if (teI.timeMarkedAsPreferredLink < currentWorldTime - (long)MAX_PREFERRED_TIME) {
                teI.timeMarkedAsPreferredLink = 0L;
            }
            if (d == -1.0 || mostPreferredLinkTime >= teI.timeMarkedAsPreferredLink && (mostPreferredLinkTime != teI.timeMarkedAsPreferredLink || !(d < closestDistance))) continue;
            closest = teI;
            closestDistance = d;
            mostPreferredLinkTime = teI.timeMarkedAsPreferredLink;
        }
        return closest;
    }

    public double getDistanceIfInRange(int x, int y, int z) {
        double d = TjUtil.getDistanceBetweenPoints_squared(this.field_145851_c, this.field_145848_d, this.field_145849_e, x, y, z);
        return d <= (double)(this.maxDistance * this.maxDistance) ? d : -1.0;
    }

    public boolean addNode(int x, int y, int z) {
        if (this.nodes.size() >= this.maxInvNodes) {
            return false;
        }
        this.nodes.add(new BlockCoord(x, y, z));
        this.markDirty(false);
        if (this.refreshCountdown == 0 || this.refreshCountdown > 5) {
            this.refreshCountdown = 5;
        }
        return true;
    }

    public boolean addMemoryUser(int x, int y, int z) {
        if (this.memoryUsers.size() >= this.maxMemoryUsers) {
            return false;
        }
        this.memoryUsers.add(new BlockCoord(x, y, z));
        this.markDirty(false);
        return true;
    }

    public void breakAllLinks() {
        TileEntity te;
        for (BlockCoord bc : this.nodes) {
            te = this.field_145850_b.func_147438_o(bc.x, bc.y, bc.z);
            if (!(te instanceof TileEntityUnseenScribe)) continue;
            ((TileEntityUnseenScribe)te).breakLink();
        }
        for (BlockCoord bc : this.memoryUsers) {
            te = this.field_145850_b.func_147438_o(bc.x, bc.y, bc.z);
            if (!(te instanceof IInventariumMemoryUser)) continue;
            ((IInventariumMemoryUser)te).breakLink();
        }
        for (int x = -3; x < 4; ++x) {
            for (int y = -3; y <= RELATIVEMAX_Y_FOR_MEMORYBLOCK; ++y) {
                for (int z = -3; z < 4; ++z) {
                    Block block = this.field_145850_b.func_147439_a(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
                    if (block != ModBlocks.metalGlow || this.field_145850_b.func_72805_g(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z) != 1) continue;
                    this.field_145850_b.func_72921_c(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z, 0, 3);
                }
            }
        }
    }

    public int getNumScribes() {
        return this.nodes.size();
    }

    public int getNumMemoryUsers() {
        return this.memoryUsers.size();
    }

    public void markAsPreferredLink() {
        this.timeMarkedAsPreferredLink = this.field_145850_b.func_82737_E();
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        nbttagcompound.func_74768_a("maxInvNodes", this.maxInvNodes);
        nbttagcompound.func_74768_a("maxDistance", this.maxDistance);
        nbttagcompound.func_74768_a("maxSlotsRead", this.maxSlotsRead);
        NBTTagList nbttaglistNodes = new NBTTagList();
        for (BlockCoord blockCoord : this.nodes) {
            NBTTagCompound tagList = new NBTTagCompound();
            tagList.func_74783_a("pos", new int[]{blockCoord.x, blockCoord.y, blockCoord.z});
            nbttaglistNodes.func_74742_a((NBTBase)tagList);
        }
        nbttagcompound.func_74782_a("Nodes", (NBTBase)nbttaglistNodes);
        NBTTagList nbttaglistTM = new NBTTagList();
        for (BlockCoord pos : this.memoryUsers) {
            NBTTagCompound tagList = new NBTTagCompound();
            tagList.func_74783_a("pos", new int[]{pos.x, pos.y, pos.z});
            nbttaglistTM.func_74742_a((NBTBase)tagList);
        }
        nbttagcompound.func_74782_a("MemoryUsers", (NBTBase)nbttaglistTM);
        nbttagcompound.func_74768_a("maxMemoryUsers", this.maxMemoryUsers);
        this.requestedItems.writeToNBT(nbttagcompound);
        this.requestedItemsEnRoute.writeToNBT(nbttagcompound);
        NBTTagList nBTTagList = new NBTTagList();
        for (Map.Entry<Integer, ItemStack> entry : this.stacksEnRouteByTaskID.entrySet()) {
            NBTTagCompound nbtcomp = new NBTTagCompound();
            int id = entry.getKey();
            ItemStack stack = entry.getValue();
            boolean returning = this.isTaskInPhaseTwo(id);
            nbtcomp.func_74768_a("TaskID", id);
            stack.func_77955_b(nbtcomp);
            nbtcomp.func_74757_a("TaskReturn", returning);
            nBTTagList.func_74742_a((NBTBase)nbtcomp);
        }
        nbttagcompound.func_74782_a("StackTasks", (NBTBase)nBTTagList);
        nbttagcompound.func_74768_a("lastTaskID", this.lastTaskID);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        this.maxInvNodes = nbttagcompound.func_74762_e("maxInvNodes");
        this.maxDistance = nbttagcompound.func_74762_e("maxDistance");
        this.maxSlotsRead = nbttagcompound.func_74762_e("maxSlotsRead");
        this.nodes.clear();
        int errors = 0;
        NBTTagList nodesList = nbttagcompound.func_150295_c("Nodes", 10);
        int count = nodesList.func_74745_c();
        for (int i = 0; i < count; ++i) {
            NBTTagCompound compound = nodesList.func_150305_b(i);
            int[] arr = compound.func_74759_k("pos");
            if (arr.length != 3) {
                ++errors;
                continue;
            }
            this.nodes.add(new BlockCoord(arr));
        }
        if (errors > 0) {
            FMLLog.warning((String)("[Automagy] Inventarium: Malformed scribe data detected. Failed to load " + errors + " positions."), (Object[])new Object[0]);
        }
        this.memoryUsers.clear();
        errors = 0;
        NBTTagList memoryUsersList = nbttagcompound.func_150295_c("MemoryUsers", 10);
        count = memoryUsersList.func_74745_c();
        for (int i = 0; i < count; ++i) {
            NBTTagCompound compound = memoryUsersList.func_150305_b(i);
            int[] arr = compound.func_74759_k("pos");
            if (arr.length != 3) {
                ++errors;
                continue;
            }
            this.memoryUsers.add(new BlockCoord(arr));
        }
        if (errors > 0) {
            FMLLog.warning((String)("[Automagy] Inventarium: Malformed MemoryUser data detected. Failed to load " + errors + " positions."), (Object[])new Object[0]);
        }
        this.maxMemoryUsers = nbttagcompound.func_74762_e("maxMemoryUsers");
        this.requestedItems.readFromNBT(nbttagcompound);
        if (this.requestedItems.size() > 0) {
            this.requestedItemsEnRoute.readFromNBT(nbttagcompound);
            NBTTagList stacksTagList = nbttagcompound.func_150295_c("StackTasks", 10);
            this.stacksEnRouteByTaskID.clear();
            this.taskReturning.clear();
            for (int i = 0; i < stacksTagList.func_74745_c(); ++i) {
                ItemStack stack;
                NBTTagCompound nbtcomp = stacksTagList.func_150305_b(i);
                int id = nbtcomp.func_74762_e("TaskID");
                if (id == 0 || (stack = TjUtil.readLargeItemStackFromNBT(nbtcomp)) == null || stack.field_77994_a <= 0) continue;
                this.stacksEnRouteByTaskID.put(id, stack);
                boolean returning = nbtcomp.func_74767_n("TaskReturn");
                if (!returning) continue;
                this.taskReturning.put(id, true);
            }
            this.lastTaskID = nbttagcompound.func_74762_e("lastTaskID");
        } else {
            this.requestedItemsEnRoute.clear();
            this.stacksEnRouteByTaskID.clear();
            this.taskReturning.clear();
            this.lastTaskID = 0;
        }
    }

    public static IInventariumContentsProvider getContentsProvider(TileEntity te) {
        for (List<IInventariumContentsProvider> list : AutomagyAPI.invContentsProviders.values()) {
            for (IInventariumContentsProvider provider : list) {
                if (!provider.canHandleTile(te)) continue;
                return provider;
            }
        }
        return null;
    }

    public static class PairedContentsProvider {
        public IInventariumContentsProvider provider;
        public TileEntity te;

        public PairedContentsProvider(IInventariumContentsProvider provider, TileEntity te) {
            this.provider = provider;
            this.te = te;
        }
    }
}

