/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import cpw.mods.fml.common.FMLLog;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;
import tuhljin.automagy.gui.ContainerGreedyChest;
import tuhljin.automagy.items.InventoryWithFilterOptions;
import tuhljin.automagy.items.ItemEnchantedPaper;
import tuhljin.automagy.lib.IRestrictedInventoryAccess;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.inventory.FilteringItemList;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;
import tuhljin.automagy.network.MessageGreedyChestStole;
import tuhljin.automagy.tiles.IChestWithFilter;
import tuhljin.automagy.tiles.InventoryObjectFilter;
import tuhljin.automagy.tiles.ModTileEntityWithInventory;

public class TileEntityGreedyChest
extends ModTileEntityWithInventory
implements IChestWithFilter,
IRestrictedInventoryAccess {
    private static int IGNORE_OVER_SIZE = 999;
    private int ticksSinceSync = -1;
    public float lidAngle;
    public float prevLidAngle;
    private int numUsingPlayers;
    public InventoryObjectFilter filterContainingInventory;
    public int modePilfer = 0;
    public float fractionWanted = 0.5f;
    public int amountWanted = 64;
    public boolean[] directions = new boolean[]{true, true, true, true, true, true};
    public int litRunesTime = 0;
    private static final int MAX_LIT_RUNES_TICKS = 5;
    private int[] countdownPilferFromNeighbor = new int[]{0, 1, 2, 3, 4, 5};
    private FilteringItemList[] neighborInv = new FilteringItemList[6];
    private boolean[] skipNextTheft = new boolean[]{true, true, true, true, true, true};
    private static final int PACKET_COOLDOWN = 4;
    private int ticksSincePacket = 4;
    private Map<HashableItemWithoutSize, Float> partialItemTracker = new HashMap<HashableItemWithoutSize, Float>();
    protected boolean doingInventoryUpdate = false;
    private Map<HashableItemWithoutSize, String> itemsRemoved = null;
    private int itemsRemovedChanged = -1;
    private InventoryWithFilterOptions filter = null;
    private boolean filterIsBlacklist;
    private Pattern filterNamePattern;

    public TileEntityGreedyChest() {
        super("blockGreedyChest", 27);
        this.notifyOnInventoryChanged = true;
        this.filterContainingInventory = new InventoryObjectFilter(this, "Greedy Chest Filter", 1);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        float f;
        if (this.field_145850_b == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.numUsingPlayers != 0 && (this.ticksSinceSync + this.field_145851_c + this.field_145848_d + this.field_145849_e) % 200 == 0) {
            this.numUsingPlayers = 0;
            f = 5.0f;
            List players = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - f), (double)((float)this.field_145848_d - f), (double)((float)this.field_145849_e - f), (double)((float)(this.field_145851_c + 1) + f), (double)((float)(this.field_145848_d + 1) + f), (double)((float)(this.field_145849_e + 1) + f)));
            for (EntityPlayer p : players) {
                if (!(p.field_71070_bA instanceof ContainerGreedyChest) || ((ContainerGreedyChest)p.field_71070_bA).getTileEntity() != this) continue;
                ++this.numUsingPlayers;
            }
        }
        ++this.ticksSinceSync;
        this.prevLidAngle = this.lidAngle;
        f = 0.1f;
        if (this.numUsingPlayers > 0 && this.lidAngle == 0.0f) {
            double d = (double)this.field_145851_c + 0.5;
            double d1 = (double)this.field_145849_e + 0.5;
            this.field_145850_b.func_72908_a(d, (double)this.field_145848_d + 0.5, d1, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numUsingPlayers == 0 && this.lidAngle > 0.0f || this.numUsingPlayers > 0 && this.lidAngle < 1.0f) {
            float f2;
            float f1 = this.lidAngle;
            this.lidAngle = this.numUsingPlayers > 0 ? (this.lidAngle += f) : (this.lidAngle -= f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f2 = 0.5f) && f1 >= f2) {
                double d2 = (double)this.field_145851_c + 0.5;
                double d3 = (double)this.field_145849_e + 0.5;
                this.field_145850_b.func_72908_a(d2, (double)this.field_145848_d + 0.5, d3, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.ticksSincePacket < 4) {
                ++this.ticksSincePacket;
            }
            this.doingInventoryUpdate = true;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                int d = dir.ordinal();
                if (this.countdownPilferFromNeighbor[d] < 1) {
                    this.countdownPilferFromNeighbor[d] = 5;
                    if (!this.directions[d]) continue;
                    this.checkThenPilferFromNeighbor(dir);
                    continue;
                }
                int n = d;
                this.countdownPilferFromNeighbor[n] = this.countdownPilferFromNeighbor[n] - 1;
            }
            this.doingInventoryUpdate = false;
            if (this.itemsRemovedChanged != -1 && Math.abs(this.ticksSinceSync - this.itemsRemovedChanged) > 100) {
                this.itemsRemoved = null;
                this.itemsRemovedChanged = -1;
            }
        }
        if (this.litRunesTime > 0) {
            --this.litRunesTime;
        }
    }

    public boolean func_145842_c(int eventNum, int arg) {
        if (eventNum == 1) {
            this.numUsingPlayers = arg;
            return true;
        }
        return super.func_145842_c(eventNum, arg);
    }

    @Override
    public void func_70295_k_() {
        if (this.field_145850_b != null) {
            ++this.numUsingPlayers;
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numUsingPlayers);
        }
    }

    @Override
    public void func_70305_f() {
        if (this.field_145850_b != null) {
            --this.numUsingPlayers;
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numUsingPlayers);
        }
    }

    @Override
    public ItemStack func_70304_b(int par1) {
        if (this.inventorySlots[par1] != null) {
            ItemStack var2 = this.inventorySlots[par1];
            this.inventorySlots[par1] = null;
            return var2;
        }
        return null;
    }

    protected void checkThenPilferFromNeighbor(ForgeDirection dir) {
        int d = dir.ordinal();
        int x = this.field_145851_c + dir.offsetX;
        int y = this.field_145848_d + dir.offsetY;
        int z = this.field_145849_e + dir.offsetZ;
        TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
        if (te == null || !this.field_145850_b.func_72899_e(x, y, z)) {
            return;
        }
        if (this.modePilfer == 0 ? !this.isPercentageShareBoss(x, y, z, te) : !this.canTakeFromNeighbor(te, dir)) {
            return;
        }
        int extractionSide = dir.getOpposite().ordinal();
        FilteringItemList newContents = null;
        if (te instanceof IInventory) {
            newContents = new FilteringItemList().populateFromInventory((IInventory)te, extractionSide, true);
        }
        if (newContents == null || newContents.size() == 0) {
            this.neighborInv[d] = null;
            this.skipNextTheft[d] = false;
            return;
        }
        if (this.skipNextTheft[d]) {
            this.neighborInv[d] = newContents;
            this.skipNextTheft[d] = false;
            return;
        }
        FilteringItemList oldContents = this.neighborInv[d];
        FilteringItemList additions = oldContents == null ? new FilteringItemList(newContents) : newContents.getDifferences(oldContents);
        if (this.itemsRemoved != null) {
            boolean copiedKeys = false;
            Iterator<Map.Entry<HashableItemWithoutSize, String>> iter = this.itemsRemoved.entrySet().iterator();
            while (iter.hasNext()) {
                String ds;
                Map.Entry<HashableItemWithoutSize, String> entry = iter.next();
                String s = entry.getValue();
                if (s.indexOf(ds = String.valueOf(d)) == -1) {
                    HashableItemWithoutSize key = entry.getKey();
                    if (!copiedKeys) {
                        copiedKeys = true;
                        Iterator<Map.Entry<HashableItemWithoutSize, Integer>> subIter = newContents.getIterator();
                        while (subIter.hasNext()) {
                            Map.Entry<HashableItemWithoutSize, Integer> subEntry = subIter.next();
                            HashableItemWithoutSize item = subEntry.getKey();
                            if (additions.containsKey(item)) continue;
                            additions.setZero(item);
                        }
                    }
                    this.itemsRemoved.put(key, s + ds);
                    continue;
                }
                iter.remove();
            }
            if (this.itemsRemoved.size() == 0) {
                this.itemsRemoved = null;
                this.itemsRemovedChanged = -1;
            }
        }
        if (additions.size() > 0) {
            boolean didTeleport = this.pilferFromNeighbor((IInventory)te, x, y, z, dir, extractionSide, additions, newContents, -1);
            if (this.modePilfer == 0) {
                return;
            }
            if (didTeleport && this.ticksSincePacket >= 4) {
                this.ticksSincePacket = 0;
                MessageGreedyChestStole.sendToClients(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, d);
            }
        }
        this.neighborInv[d] = newContents.size() == 0 ? null : newContents;
    }

    private boolean pilferFromNeighbor(IInventory inv, int x, int y, int z, ForgeDirection dir, int extractionSide, FilteringItemList additions, FilteringItemList newContents, int overrideTakeAmt) {
        ForgeDirection oppDir = dir.getOpposite();
        ISidedInventory sidedInv = null;
        if (inv instanceof ISidedInventory) {
            sidedInv = (ISidedInventory)inv;
        }
        boolean didTeleport = false;
        boolean ignoreMetadata = this.filter != null && this.filter.ignoreMetadata;
        boolean ignoreNBT = this.filter != null && this.filter.ignoreNBT;
        Iterator<Map.Entry<HashableItemWithoutSize, Integer>> iter = additions.getIterator();
        while (iter.hasNext()) {
            int toTake;
            Map.Entry<HashableItemWithoutSize, Integer> entry = iter.next();
            HashableItemWithoutSize key = entry.getKey();
            if (overrideTakeAmt == -1) {
                int qtyAdded = entry.getValue();
                int qtyTotal = newContents.get(key);
                int qtyNbrFilterAdjusted = newContents.get(key, ignoreMetadata, ignoreNBT);
                toTake = this.getPilferAmount(key, qtyAdded, qtyTotal, qtyNbrFilterAdjusted, inv, newContents, x, y, z);
            } else {
                toTake = overrideTakeAmt;
            }
            if (toTake <= 0) continue;
            int took = 0;
            for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
                ItemStack stack = inv.func_70301_a(slot);
                if (stack != null && stack.field_77994_a > 0 && this.filterSensitiveIsSameItem(key, stack) && (sidedInv == null || sidedInv.func_102008_b(slot, stack, extractionSide)) && (stack = inv.func_70298_a(slot, Math.min(toTake - took, stack.field_77994_a))) != null && stack.field_77994_a > 0) {
                    took += stack.field_77994_a;
                    this.addToInventory(stack);
                    didTeleport = true;
                }
                if (toTake - took < 1) break;
            }
            if (took == 0 || overrideTakeAmt != -1) continue;
            int val = newContents.get(key) - took;
            newContents.set(key, val);
        }
        return didTeleport;
    }

    protected boolean filterSensitiveIsSameItem(HashableItemWithoutSize item, ItemStack stack) {
        boolean ignoreMetadata = this.filter != null && this.filter.ignoreMetadata;
        boolean ignoreNBT = this.filter != null && this.filter.ignoreNBT;
        return item.isSameItem(stack, ignoreMetadata, ignoreNBT);
    }

    protected HashableItemWithoutSize getFilterSensitiveItem(HashableItemWithoutSize item) {
        boolean ignoreMetadata = this.filter != null && this.filter.ignoreMetadata;
        boolean ignoreNBT = this.filter != null && this.filter.ignoreNBT;
        return new HashableItemWithoutSize(item, ignoreMetadata, ignoreNBT);
    }

    public void addToInventory(ItemStack stack) {
        ItemStack slottedStack;
        int slot;
        int stacksTo = Math.min(stack.func_77976_d(), this.func_70297_j_());
        if (stacksTo > 1 && stack.func_77985_e()) {
            for (slot = 0; slot < this.func_70302_i_(); ++slot) {
                slottedStack = this.func_70301_a(slot);
                if (slottedStack == null || !TjUtil.canItemsStack(stack, slottedStack)) continue;
                int newSize = stack.field_77994_a + slottedStack.field_77994_a;
                if (newSize <= stacksTo) {
                    slottedStack.field_77994_a = newSize;
                    this.func_70299_a(slot, slottedStack);
                    return;
                }
                if (slottedStack.field_77994_a >= stacksTo) continue;
                stack.field_77994_a = newSize - stacksTo;
                slottedStack.field_77994_a = stacksTo;
                this.func_70299_a(slot, slottedStack);
            }
        }
        for (slot = 0; slot < this.func_70302_i_(); ++slot) {
            slottedStack = this.func_70301_a(slot);
            if (slottedStack != null) continue;
            if (stack.field_77994_a <= stacksTo) {
                this.func_70299_a(slot, stack);
                return;
            }
            ItemStack copy = stack.func_77946_l();
            copy.field_77994_a = stacksTo;
            stack.field_77994_a -= stacksTo;
            this.func_70299_a(slot, copy);
        }
        if (stack.field_77994_a > 0) {
            TjUtil.dropItemIntoWorld(stack, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private int getPilferAmount(HashableItemWithoutSize item, int qtyAdded, int qtyNeighborTotal, int qtyNbrFilterAdjusted, IInventory inv, FilteringItemList source, int x, int y, int z) {
        int qtyHere = -1;
        int filteredMax = Integer.MAX_VALUE;
        int filterOverridesMode = -1;
        int wanted = -1;
        if (this.modePilfer == 0) {
            this.bossHandlePercentageShare(x, y, z, inv, source, item, qtyAdded, qtyNeighborTotal);
            return 0;
        }
        if (wanted == -1) {
            int[] result;
            if (this.filter != null && (result = this.getMaxAllowedAfterFilter(item, source)) != null) {
                filteredMax = result[0];
                if (filteredMax < 1) {
                    return 0;
                }
                filterOverridesMode = result[1];
                if (result.length >= 3) {
                    qtyHere = result[2];
                }
            }
            if (this.modePilfer == filterOverridesMode) {
                wanted = filteredMax;
            } else if (this.modePilfer == 2) {
                wanted = qtyNbrFilterAdjusted - this.amountWanted;
            } else {
                if (qtyHere == -1) {
                    FilteringItemList dest = new FilteringItemList().populateFromInventory((IInventory)this, false);
                    qtyHere = dest.get(item, this.filter == null ? false : this.filter.ignoreMetadata, this.filter == null ? false : this.filter.ignoreNBT);
                }
                if (this.modePilfer == 1) {
                    int total = qtyNbrFilterAdjusted + qtyHere;
                    int needed = MathHelper.func_76123_f((float)((float)total * this.fractionWanted));
                    wanted = needed - qtyHere;
                } else if (this.modePilfer == 3) {
                    wanted = this.amountWanted - qtyHere;
                } else {
                    return 0;
                }
            }
            wanted = Math.min(wanted, filteredMax);
            if (wanted > 0) {
                int available = this.getAvailableSpaceForItem(item, wanted);
                wanted = Math.min(wanted, available);
            }
        }
        return (wanted = Math.min(wanted, qtyNeighborTotal)) < 1 ? 0 : wanted;
    }

    private int getAvailableSpaceForItem(HashableItemWithoutSize item, int wanted) {
        ItemStack stack = item.getItemStack(1);
        int maxStack = stack.func_77985_e() ? Math.min(stack.func_77976_d(), this.func_70297_j_()) : 1;
        int available = 0;
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            ItemStack slottedStack = this.func_70301_a(slot);
            if (slottedStack == null) {
                available += maxStack;
            } else if (maxStack > 1 && TjUtil.canItemsStack(stack, slottedStack) && slottedStack.field_77994_a < maxStack) {
                available += maxStack - slottedStack.field_77994_a;
            }
            if (wanted != -1 && available >= wanted) break;
        }
        return available;
    }

    private void bossHandlePercentageShare(int x, int y, int z, IInventory inv, FilteringItemList source, HashableItemWithoutSize item, int qtyAdded, int qtyNeighborTotal) {
        TileEntityGreedyChest[] chests = new TileEntityGreedyChest[6];
        float totalFraction = 0.0f;
        int numChests = 0;
        int[] available = new int[6];
        HashMap<TileEntityGreedyChest, Integer> otherGreedyNeighbors = new HashMap<TileEntityGreedyChest, Integer>();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int[] result;
            int x2 = x + dir.offsetX;
            int y2 = y + dir.offsetY;
            int z2 = z + dir.offsetZ;
            TileEntity te = this.field_145850_b.func_147438_o(x2, y2, z2);
            if (!(te instanceof TileEntityGreedyChest)) continue;
            TileEntityGreedyChest chest = (TileEntityGreedyChest)te;
            ForgeDirection opp = dir.getOpposite();
            if (chest != this && (chest.modePilfer != 0 || !chest.directions[opp.ordinal()] || !chest.canTakeFromNeighbor(inv, opp))) continue;
            int a = chest.getAvailableSpaceForItem(item, -1);
            if (a > 0 && chest.filter != null && (result = chest.getMaxAllowedAfterFilter(item, source)) != null) {
                a = Math.min(a, result[0]);
            }
            if (a > 0) {
                int d = dir.ordinal();
                chests[d] = chest;
                available[d] = a;
                ++numChests;
                totalFraction += chest.fractionWanted;
                continue;
            }
            otherGreedyNeighbors.put(chest, opp.ordinal());
        }
        if (numChests < 1) {
            return;
        }
        boolean fractionsOK = totalFraction < 1.0f || TjUtil.areFloatsAlmostEqual_lowprec(1.0f, totalFraction);
        float[] priority = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        int[] wantedArr = new int[6];
        HashableItemWithoutSize filterSensitiveItem = this.getFilterSensitiveItem(item);
        for (int d = 0; d < 6; ++d) {
            int wanted;
            float frac;
            TileEntityGreedyChest chest = chests[d];
            if (chest == null) continue;
            float f = frac = fractionsOK ? chest.fractionWanted : chest.fractionWanted / totalFraction;
            if (frac >= 1.0f) {
                wanted = qtyAdded;
            } else {
                float f2 = (float)qtyAdded * frac;
                if ((float)available[d] >= f2) {
                    wanted = MathHelper.func_76141_d((float)f2);
                    if (f2 > (float)wanted) {
                        float val;
                        f2 -= (float)wanted;
                        if (chest.partialItemTracker.containsKey(filterSensitiveItem) && (f2 += (val = chest.partialItemTracker.get(filterSensitiveItem).floatValue())) >= 1.0f) {
                            f2 -= 1.0f;
                            ++wanted;
                            if (f2 <= 0.0f) {
                                chest.partialItemTracker.remove(filterSensitiveItem);
                            }
                            int n = d;
                            priority[n] = priority[n] + 1.0f;
                        }
                        if (f2 > 0.0f) {
                            chest.partialItemTracker.put(filterSensitiveItem, Float.valueOf(f2));
                            int n = d;
                            priority[n] = priority[n] + f2;
                        }
                    }
                } else {
                    wanted = available[d];
                }
            }
            wantedArr[d] = Math.min(wanted, available[d]);
        }
        float[] sortedPriority = (float[])priority.clone();
        Arrays.sort(sortedPriority);
        int amtShouldBeLeft = qtyNeighborTotal;
        for (int d = 0; d < 6; ++d) {
            if (chests[d] == null) continue;
            amtShouldBeLeft -= wantedArr[d];
        }
        if (amtShouldBeLeft < 0) {
            amtShouldBeLeft = 0;
        }
        int[] chestIndex = this.getShuffledArray(new int[]{0, 1, 2, 3, 4, 5});
        block3: for (int num = 5; num >= 0; --num) {
            float currentPriority = sortedPriority[num];
            for (int i = 0; i < 6; ++i) {
                int d = chestIndex[i];
                if (chests[d] == null || wantedArr[d] <= 0 || !TjUtil.areFloatsAlmostEqual_lowprec(priority[d], currentPriority)) continue;
                chests[d].triggerTakeAmount(inv, ForgeDirection.getOrientation((int)d).getOpposite(), item, wantedArr[d], amtShouldBeLeft);
                wantedArr[d] = 0;
                continue block3;
            }
        }
        int amtReallyLeft = this.countItemsOfTypeInInv(item, inv);
        for (int d = 0; d < 6; ++d) {
            if (chests[d] == null) continue;
            int opp = ForgeDirection.getOrientation((int)d).getOpposite().ordinal();
            FilteringItemList map = chests[d].neighborInv[opp];
            if (amtReallyLeft > 0) {
                if (map == null) {
                    chests[d].neighborInv[opp] = map = new FilteringItemList();
                }
                map.set(item, amtReallyLeft);
                continue;
            }
            if (map == null) continue;
            map.set(item, 0);
            if (map.size() >= 1) continue;
            chests[d].neighborInv[opp] = null;
        }
        for (Map.Entry entry : otherGreedyNeighbors.entrySet()) {
            TileEntityGreedyChest gc = (TileEntityGreedyChest)entry.getKey();
            int opp = (Integer)entry.getValue();
            FilteringItemList map = gc.neighborInv[opp];
            if (amtReallyLeft > 0) {
                if (map == null) {
                    gc.neighborInv[opp] = map = new FilteringItemList();
                }
                map.set(item, amtReallyLeft);
                continue;
            }
            if (map == null) continue;
            map.set(item, 0);
            if (map.size() >= 1) continue;
            gc.neighborInv[opp] = null;
        }
    }

    private int[] getShuffledArray(int[] arr) {
        Random rand = new Random();
        for (int i = arr.length - 1; i > 0; --i) {
            int index = rand.nextInt(i + 1);
            int a = arr[index];
            arr[index] = arr[i];
            arr[i] = a;
        }
        return arr;
    }

    protected void triggerTakeAmount(IInventory inv, ForgeDirection dir, HashableItemWithoutSize item, int amount, int amtShouldBeLeft) {
        int d = dir.ordinal();
        boolean ignoreMetadata = this.filter != null && this.filter.ignoreMetadata;
        boolean ignoreNBT = this.filter != null && this.filter.ignoreNBT;
        FilteringItemList additions = new FilteringItemList();
        additions.set(item, amount);
        boolean didTeleport = this.pilferFromNeighbor(inv, 0, -1, 0, dir, d, additions, null, amount);
        if (didTeleport && this.ticksSincePacket >= 4) {
            this.ticksSincePacket = 0;
            MessageGreedyChestStole.sendToClients(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, d);
        }
    }

    private int[] getMaxAllowedAfterFilter(HashableItemWithoutSize item, FilteringItemList source) {
        ItemStack keyStack = null;
        ItemStack stack = null;
        boolean found = false;
        for (int i = 0; i < this.filter.func_70302_i_(); ++i) {
            stack = this.filter.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != item.getItem() || !this.filter.ignoreMetadata && stack.func_77960_j() != item.damage) continue;
            if (this.filter.ignoreNBT) {
                found = true;
                break;
            }
            if (keyStack == null) {
                keyStack = item.getItemStack(1);
            }
            if (!ItemStack.func_77970_a((ItemStack)stack, (ItemStack)keyStack)) continue;
            found = true;
            break;
        }
        if (!found) {
            if (this.filterNamePattern != null) {
                String name;
                Matcher m;
                if (keyStack == null) {
                    keyStack = item.getItemStack(1);
                }
                if ((m = this.filterNamePattern.matcher(name = keyStack.func_82833_r().toLowerCase())).matches()) {
                    return new int[]{this.filterIsBlacklist ? 0 : Integer.MAX_VALUE, -1};
                }
            }
            return new int[]{this.filterIsBlacklist ? Integer.MAX_VALUE : 0, -1};
        }
        if (!this.filter.useItemCount) {
            return new int[]{this.filterIsBlacklist ? 0 : Integer.MAX_VALUE, -1};
        }
        if (this.filterIsBlacklist) {
            int qtyNeighborTotal = source.get(item, this.filter.ignoreMetadata, this.filter.ignoreNBT);
            return new int[]{qtyNeighborTotal - stack.field_77994_a, 2};
        }
        FilteringItemList dest = new FilteringItemList().populateFromInventory((IInventory)this, false);
        int qtyHere = dest.get(item, this.filter.ignoreMetadata, this.filter.ignoreNBT);
        return new int[]{stack.field_77994_a - qtyHere, 3, qtyHere};
    }

    private boolean isPercentageShareBoss(int x, int y, int z, TileEntity teInv) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int x2 = x + dir.offsetX;
            int y2 = y + dir.offsetY;
            int z2 = z + dir.offsetZ;
            TileEntity te = this.field_145850_b.func_147438_o(x2, y2, z2);
            if (!(te instanceof TileEntityGreedyChest)) continue;
            TileEntityGreedyChest tegc = (TileEntityGreedyChest)te;
            ForgeDirection opp = dir.getOpposite();
            if (tegc.directions[opp.ordinal()] && tegc.canTakeFromNeighbor(teInv, opp)) {
                return tegc == this;
            }
            if (tegc != this) continue;
            return false;
        }
        return false;
    }

    protected int countItemsOfType(HashableItemWithoutSize item) {
        return this.countItemsOfTypeInInv(item, (IInventory)this);
    }

    protected int countItemsOfTypeInInv(HashableItemWithoutSize item, IInventory inv) {
        int count = 0;
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack stack = inv.func_70301_a(slot);
            if (stack == null || !item.isSameItem(stack)) continue;
            count += stack.field_77994_a;
        }
        return count;
    }

    @Override
    public void onInventoryChanged(int slot, ItemStack prevStack) {
        ItemStack stack;
        if (!(this.doingInventoryUpdate || prevStack == null || this.modePilfer != 1 && this.modePilfer != 3 || (stack = this.inventorySlots[slot]) != null && TjUtil.areItemsEqualIgnoringSize(stack, prevStack) && stack.field_77994_a >= prevStack.field_77994_a)) {
            boolean foundValidDir = false;
            for (int i = 0; i < this.directions.length; ++i) {
                if (!this.directions[i]) continue;
                foundValidDir = true;
                break;
            }
            if (foundValidDir) {
                if (this.itemsRemoved == null) {
                    this.itemsRemoved = new HashMap<HashableItemWithoutSize, String>();
                }
                this.itemsRemoved.put(new HashableItemWithoutSize(prevStack), "");
                this.itemsRemovedChanged = this.ticksSinceSync;
            }
        }
    }

    @Override
    public void onFilterInventoryChanged(int slot, ItemStack prevStack) {
        ItemStack stack = this.filterContainingInventory.func_70301_a(slot);
        boolean changed = false;
        if (stack == null) {
            if (this.filter != null) {
                this.filter = null;
                changed = true;
            }
        } else {
            boolean hadFilter = this.filter != null;
            this.filter = ItemEnchantedPaper.getFilterInventory(stack);
            if (this.filter != null) {
                this.filterIsBlacklist = ItemEnchantedPaper.stackIsBlacklist(stack);
                this.filterNamePattern = this.filter.nameFilter.isEmpty() ? null : TjUtil.getSafePatternUsingAsteriskForWildcard(this.filter.nameFilter.toLowerCase());
                changed = true;
            } else if (hadFilter) {
                changed = true;
            }
        }
        if (changed) {
            for (int d = 0; d < 6; ++d) {
                this.skipNextTheft[d] = true;
                this.neighborInv[d] = null;
            }
            this.partialItemTracker.clear();
        }
    }

    public void receiveActionStateFromServer(int side) {
        this.litRunesTime = 5;
        if (this.lidAngle < 0.01f) {
            this.lidAngle = 0.01f;
        }
        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[side];
        int x = this.field_145851_c + dir.offsetX;
        int y = this.field_145848_d + dir.offsetY;
        int z = this.field_145849_e + dir.offsetZ;
        for (int i = 0; i < 2; ++i) {
            this.field_145850_b.func_72869_a("portal", (double)x + 0.5, (double)y + this.field_145850_b.field_73012_v.nextDouble() * 2.0 - 1.0, (double)z + 0.5, this.field_145850_b.field_73012_v.nextGaussian(), 0.0, this.field_145850_b.field_73012_v.nextGaussian());
            this.field_145850_b.func_72869_a("portal", (double)this.field_145851_c + 0.5, (double)this.field_145848_d + this.field_145850_b.field_73012_v.nextDouble() * 2.0 - 1.0, (double)this.field_145849_e + 0.5, this.field_145850_b.field_73012_v.nextGaussian(), 0.0, this.field_145850_b.field_73012_v.nextGaussian());
        }
        this.field_145850_b.func_72980_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "mob.endermen.portal", 0.15f, 1.1f + this.field_145850_b.field_73012_v.nextFloat() / 4.0f, false);
    }

    public void receiveGUIMessage(int type, float data) {
        switch (type) {
            case 6: {
                this.modePilfer = Math.round(data);
                break;
            }
            case 7: {
                if (TjUtil.areFloatsAlmostEqual_lowprec(this.fractionWanted, data)) break;
                this.fractionWanted = TjUtil.areFloatsAlmostEqual_lowprec(data, 0.3333f) ? 0.33333334f : (TjUtil.areFloatsAlmostEqual_lowprec(data, 0.166f) ? 0.16666667f : data);
                this.partialItemTracker.clear();
                break;
            }
            case 8: {
                this.amountWanted = Math.round(data);
                break;
            }
            default: {
                if (type < 0 || type > 5) {
                    FMLLog.warning((String)("[Automagy] TileEntityGreedyChest received invalid packet data. Ignoring. (type=" + type + ")"), (Object[])new Object[0]);
                    return;
                }
                boolean b = Math.round(data) == 1;
                boolean oldB = this.directions[type];
                this.directions[type] = b;
                if (b) {
                    if (oldB) break;
                    this.skipNextTheft[type] = true;
                    break;
                }
                this.neighborInv[type] = null;
            }
        }
        this.markDirty(false);
    }

    public boolean canTakeFromNeighbor(Object inv, ForgeDirection dir) {
        if (inv instanceof TileEntityHopper && dir == ForgeDirection.DOWN) {
            return false;
        }
        if (inv instanceof IRestrictedInventoryAccess) {
            return ((IRestrictedInventoryAccess)inv).greedyChestCanSteal(this, dir.getOpposite());
        }
        return true;
    }

    @Override
    public boolean greedyChestCanSteal(TileEntity greedyChest, ForgeDirection fromSide) {
        int d = fromSide.ordinal();
        return !this.directions[d];
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        nbttagcompound.func_74777_a("modePilfer", (short)this.modePilfer);
        nbttagcompound.func_74776_a("fractionWanted", this.fractionWanted);
        nbttagcompound.func_74768_a("amountWanted", this.amountWanted);
        TileEntityGreedyChest.setBooleanArrayInNbt(nbttagcompound, "directions", this.directions);
        this.filterContainingInventory.writeCustomNBT(nbttagcompound);
        if (this.field_145850_b == null || !this.field_145850_b.field_72995_K) {
            NBTTagList nbttaglist = new NBTTagList();
            for (Map.Entry<HashableItemWithoutSize, Float> entry : this.partialItemTracker.entrySet()) {
                ItemStack stack = entry.getKey().getItemStack(1);
                if (stack == null) continue;
                NBTTagCompound tagList = new NBTTagCompound();
                stack.func_77955_b(tagList);
                tagList.func_74776_a("Value", entry.getValue().floatValue());
                nbttaglist.func_74742_a((NBTBase)tagList);
            }
            nbttagcompound.func_74782_a("GreedPartialItems", (NBTBase)nbttaglist);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        this.modePilfer = nbttagcompound.func_74765_d("modePilfer");
        this.fractionWanted = nbttagcompound.func_74760_g("fractionWanted");
        this.amountWanted = nbttagcompound.func_74762_e("amountWanted");
        this.directions = TileEntityGreedyChest.getBooleanArrayFromNbtOrDefault(nbttagcompound, "directions", true, 6);
        this.filterContainingInventory.readCustomNBT(nbttagcompound);
        ItemStack filterStack = this.filterContainingInventory.func_70301_a(0);
        if (filterStack == null) {
            this.filter = null;
        } else {
            this.filter = ItemEnchantedPaper.getFilterInventory(filterStack);
            if (this.filter != null) {
                this.filterIsBlacklist = ItemEnchantedPaper.stackIsBlacklist(filterStack);
                this.filterNamePattern = this.filter.nameFilter.isEmpty() ? null : TjUtil.getSafePatternUsingAsteriskForWildcard(this.filter.nameFilter.toLowerCase());
            }
        }
        if (!(this.field_145850_b != null && this.field_145850_b.field_72995_K || this.modePilfer != 0)) {
            NBTTagList nbttaglist = nbttagcompound.func_150295_c("GreedPartialItems", 10);
            this.partialItemTracker = new HashMap<HashableItemWithoutSize, Float>();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                ItemStack stack;
                NBTTagCompound tagList = nbttaglist.func_150305_b(i);
                float val = tagList.func_74760_g("Value");
                if (!(val > 0.0f) || (stack = ItemStack.func_77949_a((NBTTagCompound)tagList)) == null) continue;
                this.partialItemTracker.put(new HashableItemWithoutSize(stack), Float.valueOf(val));
            }
        }
    }

    @Override
    public int getFacing() {
        return this.func_145832_p();
    }

    @Override
    public float getLidAngle() {
        return this.lidAngle;
    }

    @Override
    public float getPrevLidAngle() {
        return this.prevLidAngle;
    }
}

