/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.AspectSourceHelper;
import tuhljin.automagy.api.nethermind.INetherRuneCreature;
import tuhljin.automagy.blocks.ModBlocks;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.network.MessageParticles;
import tuhljin.automagy.tiles.ModTileEntityWithBasicAspectContainer;
import tuhljin.automagy.tiles.TileEntityNethermind;

public class TileEntityDimensionLure
extends ModTileEntityWithBasicAspectContainer {
    public static int PILLAR_MAX_HEIGHT = 4;
    public static int VALIDITY_CHECK_FREQUENCY = 60;
    private int ticksSinceValidityCheck = VALIDITY_CHECK_FREQUENCY;
    public int stability = -1;
    protected Map<String, Integer> baitLeft = new HashMap<String, Integer>();
    private int nethermindY = -1;
    public long lastNoise;

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.isEnabled()) {
            if (this.ticksSinceValidityCheck >= VALIDITY_CHECK_FREQUENCY) {
                this.ticksSinceValidityCheck = 0;
                this.stability = -1;
                if (this.getNethermind() == null || !this.isStructureValid()) {
                    this.disable(true);
                    return;
                }
            } else {
                ++this.ticksSinceValidityCheck;
            }
        }
    }

    public boolean isEnabled() {
        return this.func_145832_p() == 1;
    }

    public boolean isStructureValid() {
        return this.checkRuneAtOffset(-1, -3) && this.checkRuneAtOffset(0, -3) && this.checkRuneAtOffset(1, -3) && this.checkRuneAtOffset(-1, 3) && this.checkRuneAtOffset(0, 3) && this.checkRuneAtOffset(1, 3) && this.checkRuneAtOffset(-3, -1) && this.checkRuneAtOffset(-3, 0) && this.checkRuneAtOffset(-3, 1) && this.checkRuneAtOffset(3, -1) && this.checkRuneAtOffset(3, 0) && this.checkRuneAtOffset(3, 1) && this.checkRuneAtOffset(-2, -2) && this.checkRuneAtOffset(-2, 2) && this.checkRuneAtOffset(2, -2) && this.checkRuneAtOffset(2, 2);
    }

    private boolean checkRuneAtOffset(int x, int z) {
        return this.field_145850_b.func_147439_a(this.field_145851_c + x, this.field_145848_d, this.field_145849_e + z) == ModBlocks.runedObsidian;
    }

    public boolean tryEnable() {
        if (this.getNethermind() != null && this.isStructureValid()) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 3);
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "thaumcraft:brain", 0.8f, this.field_145850_b.field_73012_v.nextFloat() * 0.3f + 0.2f);
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, "mob.ghast.fireball", 1.0f, 0.5f);
            MessageParticles.sendToClients(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 500, 0, 0, (short)2);
            this.doEffectAtOffset(-1, -3);
            this.doEffectAtOffset(0, -3);
            this.doEffectAtOffset(1, -3);
            this.doEffectAtOffset(-1, 3);
            this.doEffectAtOffset(0, 3);
            this.doEffectAtOffset(1, 3);
            this.doEffectAtOffset(-3, -1);
            this.doEffectAtOffset(-3, 0);
            this.doEffectAtOffset(-3, 1);
            this.doEffectAtOffset(3, -1);
            this.doEffectAtOffset(3, 0);
            this.doEffectAtOffset(3, 1);
            this.doEffectAtOffset(-2, -2);
            this.doEffectAtOffset(-2, 2);
            this.doEffectAtOffset(2, -2);
            this.doEffectAtOffset(2, 2);
            return true;
        }
        return false;
    }

    private void doEffectAtOffset(int x, int z) {
        MessageParticles.sendToClients(this.field_145850_b, x += this.field_145851_c, this.field_145848_d, z += this.field_145849_e, 0, 0, 0, (short)10);
        if (this.field_145850_b.field_73012_v.nextInt(3) > 0 && this.field_145850_b.func_147437_c(x, this.field_145848_d + 1, z)) {
            this.field_145850_b.func_147449_b(x, this.field_145848_d + 1, z, (Block)Blocks.field_150480_ab);
        }
    }

    public void disable(boolean replaceBlock) {
        TileEntityNethermind nethermind = this.getNethermind();
        this.nethermindY = -1;
        if (replaceBlock) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 3);
            this.clearActiveRune();
        }
        this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "thaumcraft:craftfail", 1.0f, 1.0f);
        if (nethermind != null) {
            nethermind.requireValidityCheck();
        }
    }

    public TileEntityNethermind getNethermind() {
        if (this.nethermindY != -1) {
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.nethermindY, this.field_145849_e);
            if (te instanceof TileEntityNethermind) {
                return (TileEntityNethermind)te;
            }
            this.nethermindY = -1;
        }
        for (int yOffset = TileEntityNethermind.MIN_LURE_DISTANCE; yOffset <= TileEntityNethermind.MAX_LURE_DISTANCE; ++yOffset) {
            int y = this.field_145848_d + yOffset;
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, y, this.field_145849_e);
            if (!(te instanceof TileEntityNethermind)) continue;
            this.nethermindY = y;
            return (TileEntityNethermind)te;
        }
        return null;
    }

    public boolean isConjuring() {
        TileEntityNethermind nethermind = this.getNethermind();
        return nethermind == null ? false : nethermind.isConjuring();
    }

    public double getMidPoint() {
        if (this.nethermindY == -1) {
            this.getNethermind();
        }
        if (this.nethermindY == -1) {
            return (double)this.field_145848_d + 0.5;
        }
        return (double)(this.field_145848_d + (this.nethermindY + 1)) / 2.0;
    }

    public boolean consumeEssentia() {
        for (Aspect a : this.aspects.getAspects()) {
            int amt = this.aspects.getAmount(a);
            if (amt <= 0 || !AspectSourceHelper.drainEssentia((TileEntity)this, (Aspect)a, (ForgeDirection)ForgeDirection.UNKNOWN, (int)12)) continue;
            this.aspects.reduce(a, 1);
            this.func_70296_d();
            return amt == 1 && this.aspects.visSize() == 0;
        }
        return false;
    }

    public void setActiveRune(INetherRuneCreature rune, int runeType) {
        String mob = rune.getEntityIdentifier(runeType);
        if (mob != null) {
            AspectList aspectsCost = rune.secondaryEssentiaCost(runeType);
            aspectsCost = aspectsCost == null ? new AspectList() : aspectsCost.copy();
            Integer bait = this.baitLeft.get(mob);
            if (bait != null && bait > 0) {
                this.aspects = new AspectList();
                for (Aspect a : aspectsCost.getAspects()) {
                    this.aspects.add(a, 0);
                }
            } else {
                this.aspects = aspectsCost;
            }
            this.func_70296_d();
        }
    }

    public void clearActiveRune() {
        this.aspects.aspects.clear();
        this.func_70296_d();
        this.ticksSinceValidityCheck = VALIDITY_CHECK_FREQUENCY;
    }

    public void consumeBait(INetherRuneCreature rune, int runeType) {
        Integer bait;
        String mob = rune.getEntityIdentifier(runeType);
        if (mob != null && (bait = this.baitLeft.get(mob)) != null) {
            Integer n = bait;
            Integer n2 = bait = Integer.valueOf(bait - 1);
            if (bait < 1) {
                this.baitLeft.remove(mob);
            } else {
                this.baitLeft.put(mob, bait);
            }
            this.markDirty(false);
        }
    }

    public void addBait(INetherRuneCreature rune, int runeType) {
        String mob = rune.getEntityIdentifier(runeType);
        if (mob != null) {
            int uses = rune.secondaryEssentiaCostUses(runeType);
            Integer prevBait = this.baitLeft.get(mob);
            if (prevBait != null) {
                uses += prevBait.intValue();
            }
            this.baitLeft.put(mob, uses);
            this.markDirty(false);
        }
    }

    public int getStabilityModifiers() {
        if (this.stability == -1) {
            int p1 = this.getPillarHeight(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e - 3);
            int p2 = this.getPillarHeight(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e - 3);
            int p3 = this.getPillarHeight(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e + 3);
            int p4 = this.getPillarHeight(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e + 3);
            this.stability = p1 + p2 + p3 + p4;
            if (p1 > 0 && p1 == p2 && p1 == p3 && p1 == p4) {
                this.stability += 3;
            }
            int nitor = 0;
            if (p1 > 0 && ThaumcraftExtension.blockIsNitor((IBlockAccess)this.field_145850_b, this.field_145851_c - 3, this.field_145848_d + p1, this.field_145849_e - 3)) {
                ++nitor;
            }
            if (p2 > 0 && ThaumcraftExtension.blockIsNitor((IBlockAccess)this.field_145850_b, this.field_145851_c + 3, this.field_145848_d + p2, this.field_145849_e - 3)) {
                ++nitor;
            }
            if (p3 > 0 && ThaumcraftExtension.blockIsNitor((IBlockAccess)this.field_145850_b, this.field_145851_c - 3, this.field_145848_d + p3, this.field_145849_e + 3)) {
                ++nitor;
            }
            if (p4 > 0 && ThaumcraftExtension.blockIsNitor((IBlockAccess)this.field_145850_b, this.field_145851_c + 3, this.field_145848_d + p4, this.field_145849_e + 3)) {
                ++nitor;
            }
            if (this.nethermindY > 0) {
                if (ThaumcraftExtension.blockIsNitor((IBlockAccess)this.field_145850_b, this.field_145851_c - 3, this.nethermindY - 2, this.field_145849_e)) {
                    ++nitor;
                }
                if (ThaumcraftExtension.blockIsNitor((IBlockAccess)this.field_145850_b, this.field_145851_c + 3, this.nethermindY - 2, this.field_145849_e)) {
                    ++nitor;
                }
                if (ThaumcraftExtension.blockIsNitor((IBlockAccess)this.field_145850_b, this.field_145851_c, this.nethermindY - 2, this.field_145849_e - 3)) {
                    ++nitor;
                }
                if (ThaumcraftExtension.blockIsNitor((IBlockAccess)this.field_145850_b, this.field_145851_c, this.nethermindY - 2, this.field_145849_e + 3)) {
                    ++nitor;
                }
            }
            this.stability += nitor * 2;
        }
        return this.stability;
    }

    private int getPillarHeight(int x, int y, int z) {
        int height;
        for (height = 0; ThaumcraftExtension.blockIsObsidianTotem((IBlockAccess)this.field_145850_b, x, y, z) && height < PILLAR_MAX_HEIGHT; ++height) {
            ++y;
        }
        return height;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.aspects.readFromNBT(nbttagcompound);
        NBTTagList stacksTagList = nbttagcompound.func_150295_c("baitLeft", 10);
        this.baitLeft.clear();
        for (int i = 0; i < stacksTagList.func_74745_c(); ++i) {
            Integer amt;
            NBTTagCompound nbtcomp = stacksTagList.func_150305_b(i);
            String id = nbtcomp.func_74779_i("mobID");
            if (id == null || (amt = Integer.valueOf(nbtcomp.func_74762_e("amt"))) == null || amt <= 0) continue;
            this.baitLeft.put(id, amt);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        this.aspects.writeToNBT(nbttagcompound);
        NBTTagList stacksTagList = new NBTTagList();
        for (Map.Entry<String, Integer> entry : this.baitLeft.entrySet()) {
            NBTTagCompound nbtcomp = new NBTTagCompound();
            String id = entry.getKey();
            Integer amt = entry.getValue();
            if (amt == null) continue;
            nbtcomp.func_74778_a("mobID", id);
            nbtcomp.func_74768_a("amt", amt.intValue());
            stacksTagList.func_74742_a((NBTBase)nbtcomp);
        }
        nbttagcompound.func_74782_a("baitLeft", (NBTBase)stacksTagList);
    }
}

