/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.config;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.apache.logging.log4j.Level;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.InfusionEnchantmentRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.research.ResearchPage;
import tuhljin.automagy.config.ModRecipes;
import tuhljin.automagy.config.ModResearchItems;
import tuhljin.automagy.lib.ThaumcraftExtension;

public class ModResearchItem
extends ResearchItem {
    private boolean isConcealedSameCategory;
    private String concealedUnlessResearch = "";

    public ModResearchItem(String key, AspectList tags, int col, int row, int complex, ItemStack icon) {
        super(key, "AUTOMAGY", tags, col, row, complex, icon);
    }

    public ModResearchItem(String key, AspectList tags, int col, int row, int complex, ResourceLocation icon) {
        super(key, "AUTOMAGY", tags, col, row, complex, icon);
    }

    public ModResearchItem(String key) {
        super(key, "AUTOMAGY");
    }

    public String getName() {
        return StatCollector.func_74838_a((String)("Automagy.research_name." + this.key));
    }

    public String getText() {
        return StatCollector.func_74838_a((String)("Automagy.research_text." + this.key));
    }

    public ModResearchItem setParentsHidden(String ... par) {
        if (this.parentsHidden == null || !Arrays.asList(this.parentsHidden).contains("INFUSION") || Arrays.asList(par).contains("INFUSION")) {
            super.setParentsHidden(par);
        } else {
            int l = par.length + 1;
            String[] newParentsHidden = Arrays.copyOf(par, l);
            newParentsHidden[l - 1] = "INFUSION";
            super.setParentsHidden(newParentsHidden);
        }
        return this;
    }

    public ModResearchItem createPages(Object ... par) {
        ResearchPage[] pages = new ResearchPage[par.length];
        boolean addedInfusionParent = false;
        int i = 0;
        for (Object obj : par) {
            ResearchPage page;
            if (obj instanceof ResearchPage) {
                page = (ResearchPage)obj;
            } else if (obj instanceof Item) {
                page = ModResearchItem.getRecipePage((Item)obj, -1);
            } else if (obj instanceof ItemStack) {
                ItemStack stack = (ItemStack)obj;
                page = ModResearchItem.getRecipePage(stack.func_77973_b(), stack.func_77960_j());
            } else if (obj instanceof Block) {
                page = ModResearchItem.getRecipePage((Block)obj, -1);
            } else if (obj instanceof String) {
                page = new ResearchPage("Automagy.research_page." + this.key + "." + (String)obj);
            } else if (obj instanceof String[]) {
                String[] arr = (String[])obj;
                page = new ResearchPage(arr[0], "Automagy.research_page." + this.key + "." + arr[1]);
            } else if (obj instanceof List) {
                page = new ResearchPage((List)obj);
            } else if (obj instanceof IArcaneRecipe) {
                page = new ResearchPage((IArcaneRecipe)obj);
            } else if (obj instanceof InfusionEnchantmentRecipe) {
                page = new ResearchPage((InfusionEnchantmentRecipe)obj);
            } else {
                FMLLog.log((Level)Level.ERROR, (String)("[Automagy] Failed to generate page #" + (i + 1) + " for ResearchItem with key \"" + this.key + "\""), (Object[])new Object[0]);
                page = new ResearchPage("ERROR: FAILED TO GENERATE PAGE #" + (i + 1));
            }
            if (!addedInfusionParent && page.type == ResearchPage.PageType.INFUSION_CRAFTING) {
                if (this.parentsHidden == null || this.parentsHidden.length == 0) {
                    super.setParentsHidden(new String[]{"INFUSION"});
                } else {
                    int l = this.parentsHidden.length + 1;
                    String[] newParentsHidden = Arrays.copyOf(this.parentsHidden, l);
                    newParentsHidden[l - 1] = "INFUSION";
                    super.setParentsHidden(newParentsHidden);
                }
                addedInfusionParent = true;
            }
            pages[i] = page;
            ++i;
        }
        this.setPages(pages);
        return this;
    }

    public static ResearchPage getRecipePage(Object item, int damage) {
        boolean isBlock = item instanceof Block;
        if (isBlock || item instanceof Item) {
            Object o;
            if (damage == -1) {
                o = ModRecipes.getRecipe(item);
            } else {
                Object object = o = isBlock ? ModRecipes.getRecipe((Block)item, damage) : ModRecipes.getRecipe((Item)item, damage);
            }
            if (o instanceof InfusionRecipe) {
                Object o2;
                if (damage == -1) {
                    o2 = ModRecipes.getAlternateRecipe(item);
                } else {
                    Object object = o2 = isBlock ? ModRecipes.getAlternateRecipe((Block)item, damage) : ModRecipes.getAlternateRecipe((Item)item, damage);
                }
                if (o2 instanceof InfusionRecipe) {
                    return new ResearchPage(new InfusionRecipe[]{(InfusionRecipe)o, (InfusionRecipe)o2});
                }
                return new ResearchPage((InfusionRecipe)o);
            }
            if (o instanceof CrucibleRecipe) {
                return new ResearchPage((CrucibleRecipe)o);
            }
            if (o instanceof IArcaneRecipe) {
                Object o2;
                if (damage == -1) {
                    o2 = ModRecipes.getAlternateRecipe(item);
                } else {
                    Object object = o2 = isBlock ? ModRecipes.getAlternateRecipe((Block)item, damage) : ModRecipes.getAlternateRecipe((Item)item, damage);
                }
                if (o2 instanceof IArcaneRecipe) {
                    return new ResearchPage(new IArcaneRecipe[]{(IArcaneRecipe)o, (IArcaneRecipe)o2});
                }
                return new ResearchPage((IArcaneRecipe)o);
            }
            if (o instanceof IRecipe) {
                Object o2;
                if (damage == -1) {
                    o2 = ModRecipes.getAlternateRecipe(item);
                } else {
                    Object object = o2 = isBlock ? ModRecipes.getAlternateRecipe((Block)item, damage) : ModRecipes.getAlternateRecipe((Item)item, damage);
                }
                if (o2 instanceof IRecipe) {
                    return new ResearchPage(new IRecipe[]{(IRecipe)o, (IRecipe)o2});
                }
                return new ResearchPage((IRecipe)o);
            }
            if (o instanceof List) {
                return new ResearchPage((List)o);
            }
        }
        String itemRef = isBlock ? ((Block)item).func_149739_a() : (item instanceof Item ? ((Item)item).func_77658_a() : "[UNKNOWN]");
        if (damage != -1) {
            itemRef = itemRef + ":" + damage;
        }
        FMLLog.log((Level)Level.ERROR, (String)("[Automagy] Failed to find recipe page for item \"" + itemRef + "\""), (Object[])new Object[0]);
        return new ResearchPage("ERROR: RECIPE NOT FOUND FOR \"" + itemRef + "\"");
    }

    public ModResearchItem setParents(String ... par) {
        super.setParents(par);
        return this;
    }

    public ModResearchItem setSecondary() {
        super.setSecondary();
        return this;
    }

    public ModResearchItem setHidden() {
        super.setHidden();
        return this;
    }

    public ModResearchItem setHiddenUntilScanAndKillEntity(String ... par) {
        this.setHidden();
        for (String s : par) {
            ModResearchItems.cluesOnKill.put(s, this.key);
        }
        return this;
    }

    public ModResearchItem setConcealedSameCategory() {
        this.setConcealed();
        this.isConcealedSameCategory = true;
        return this;
    }

    public ModResearchItem setConcealedUnless(String key) {
        this.setConcealed();
        this.concealedUnlessResearch = key;
        return this;
    }

    public boolean isConcealedSameCategory() {
        return this.isConcealedSameCategory;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isConcealed() {
        boolean conceal = super.isConcealed();
        if (conceal && (!this.concealedUnlessResearch.isEmpty() && ThaumcraftExtension.isResearchComplete((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g, this.concealedUnlessResearch) || this.isConcealedSameCategory && this.allSameCategoryParentsResearched())) {
            return false;
        }
        return conceal;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean allSameCategoryParentsResearched() {
        ResearchItem parent;
        ModResearchItem res = this;
        String player = FMLClientHandler.instance().getClient().field_71439_g.getDisplayName();
        if (res.parents != null && res.parents.length > 0) {
            for (String pt : res.parents) {
                parent = ResearchCategories.getResearch((String)pt);
                if (parent == null || parent.category != res.category || ThaumcraftApiHelper.isResearchComplete((String)player, (String)parent.key)) continue;
                return false;
            }
        }
        if (res.parentsHidden != null && res.parentsHidden.length > 0) {
            for (String pt : res.parentsHidden) {
                parent = ResearchCategories.getResearch((String)pt);
                if (parent == null || parent.category != res.category || ThaumcraftApiHelper.isResearchComplete((String)player, (String)parent.key)) continue;
                return false;
            }
        }
        return true;
    }

    public void replacePage(int pageNum, ResearchPage newPage) {
        ResearchPage[] pages = this.getPages();
        pages[pageNum - 1] = newPage;
    }
}

