/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tuhljin.automagy.blocks.ItemBlockRarityRare;
import tuhljin.automagy.blocks.ModBlockSpecialRender;
import tuhljin.automagy.blocks.ModBlocks;
import tuhljin.automagy.lib.References;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.renderers.IBlockGlowOverlayWithAlpha;
import tuhljin.automagy.tiles.TileEntityDimensionLure;

public class BlockDimensionLure
extends ModBlockSpecialRender
implements IBlockGlowOverlayWithAlpha {
    private IIcon iconSide;
    private IIcon iconOverlay;

    public BlockDimensionLure(String name) {
        super(name, ModBlocks.materialNiceStone, ItemBlockRarityRare.class);
        this.func_149752_b(2000.0f);
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityDimensionLure();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
        super.func_149651_a(ir);
        this.iconSide = ir.func_94245_a(this.field_149768_d + "Side");
        this.iconOverlay = ir.func_94245_a(this.field_149768_d + "Overlay");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side == 1 ? this.field_149761_L : this.iconSide;
    }

    public MapColor func_149728_f(int p_149728_1_) {
        return MapColor.field_151654_J;
    }

    @Override
    public int func_149645_b() {
        return References.renderBlockDimensionLure;
    }

    @Override
    public IIcon getOverlayTexture(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        return meta == 1 && side == 1 ? this.iconOverlay : null;
    }

    @Override
    public IIcon getOverlayInvTexture(int side, int meta) {
        return side == 1 ? this.iconOverlay : null;
    }

    @Override
    public float getOverlayAlpha(int meta) {
        if (meta != 1) {
            return 1.0f;
        }
        long currentTime = System.currentTimeMillis();
        float alphaState = currentTime / 40L % 100L;
        return TjUtil.dualInterpolate(1.0f, 0.5f, alphaState /= 100.0f);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (ThaumcraftExtension.playerHasWandEquipped(player)) {
            if (!world.field_72995_K) {
                TileEntityDimensionLure te = null;
                try {
                    te = (TileEntityDimensionLure)world.func_147438_o(x, y, z);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (te != null && !te.isEnabled()) {
                    te.tryEnable();
                }
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        TileEntityDimensionLure te = null;
        try {
            te = (TileEntityDimensionLure)world.func_147438_o(x, y, z);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (te != null && te.isEnabled()) {
            long currentTime = System.currentTimeMillis();
            if (te.lastNoise == 0L) {
                te.lastNoise = currentTime - 45000L;
            } else if (currentTime >= te.lastNoise + 12000L) {
                boolean shouldPlay;
                if (te.isConjuring()) {
                    shouldPlay = currentTime >= te.lastNoise + 17000L || rand.nextInt(5) == 0;
                } else {
                    boolean bl = shouldPlay = currentTime >= te.lastNoise + 50000L && rand.nextInt(10) == 0;
                }
                if (shouldPlay) {
                    world.func_72980_b((double)x + 0.5, te.getMidPoint(), (double)z + 0.5, "portal.portal", 1.0f, rand.nextFloat() * 0.3f + 0.3f, false);
                    te.lastNoise = currentTime;
                }
            }
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        TileEntityDimensionLure te = null;
        try {
            te = (TileEntityDimensionLure)world.func_147438_o(x, y, z);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (te != null && te.isEnabled()) {
            te.disable(false);
        }
        super.func_149749_a(world, x, y, z, block, metadata);
    }
}

