/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.metallurgy.recipes;

import com.teammetallurgy.metallurgycore.recipes.RecipeUtils;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class AlloyerRecipes {
    private static AlloyerRecipes instance = new AlloyerRecipes();
    private final ArrayList<AlloyRecipe> recipes = new ArrayList();

    public static AlloyerRecipes getInstance() {
        return instance;
    }

    public void addRecipe(ItemStack itemStack, ItemStack otherItemStack, ItemStack output) {
        this.recipes.add(new AlloyRecipe(itemStack, otherItemStack, output));
    }

    public ItemStack getAlloyResult(ItemStack itemStack, ItemStack otherItemStack) {
        for (int j = 0; j < this.recipes.size(); ++j) {
            AlloyRecipe irecipe = this.recipes.get(j);
            if (!irecipe.matches(itemStack, otherItemStack)) continue;
            return irecipe.getCraftingResult();
        }
        return null;
    }

    public boolean hasUsage(ItemStack itemStack) {
        for (int j = 0; j < this.recipes.size(); ++j) {
            AlloyRecipe irecipe = this.recipes.get(j);
            if (!irecipe.uses(itemStack)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<AlloyRecipe> getRecipesFor(ItemStack output) {
        ArrayList<AlloyRecipe> list = new ArrayList<AlloyRecipe>();
        for (AlloyRecipe alloyRecipe : this.recipes) {
            if (!alloyRecipe.result.func_77969_a(output) || ((AlloyRecipe)alloyRecipe).result.field_77990_d != output.field_77990_d) continue;
            list.add(alloyRecipe);
        }
        return list;
    }

    public ArrayList<AlloyRecipe> getRecipesUsing(ItemStack ingredient) {
        ArrayList<AlloyRecipe> list = new ArrayList<AlloyRecipe>();
        for (AlloyRecipe alloyRecipe : this.recipes) {
            if (alloyRecipe.uses(ingredient)) {
                list.add(alloyRecipe);
                continue;
            }
            if (RecipeUtils.matchesOreDict((ItemStack)ingredient, (ItemStack[])new ItemStack[]{alloyRecipe.first})) {
                list.add(new AlloyRecipe(ingredient, alloyRecipe.baseItem.func_77946_l(), alloyRecipe.result.func_77946_l()));
                continue;
            }
            if (!RecipeUtils.matchesOreDict((ItemStack)ingredient, (ItemStack[])new ItemStack[]{alloyRecipe.baseItem})) continue;
            list.add(new AlloyRecipe(alloyRecipe.first.func_77946_l(), ingredient, alloyRecipe.result.func_77946_l()));
        }
        return list;
    }

    public class AlloyRecipe {
        private final ItemStack baseItem;
        private final ItemStack first;
        private final ItemStack result;

        public AlloyRecipe(ItemStack first, ItemStack baseItem, ItemStack result) {
            this.first = first;
            this.baseItem = baseItem;
            this.result = result;
        }

        public ItemStack getCraftingResult() {
            return this.result.func_77946_l();
        }

        public ItemStack[] getIngredients() {
            return new ItemStack[]{this.first, this.baseItem};
        }

        public boolean matches(ItemStack first, ItemStack second) {
            if (first.func_77969_a(second)) {
                return false;
            }
            if (this.uses(first) && this.uses(second)) {
                return true;
            }
            if (this.uses(first) && second == null) {
                return true;
            }
            if (this.uses(second) && first == null) {
                return true;
            }
            return this.matchesOreDict(first, second);
        }

        private boolean matchesOreDict(ItemStack first, ItemStack second) {
            if (RecipeUtils.matchesOreDict((ItemStack)first, (ItemStack[])new ItemStack[]{this.first}) && RecipeUtils.matchesOreDict((ItemStack)second, (ItemStack[])new ItemStack[]{this.baseItem})) {
                return true;
            }
            if (RecipeUtils.matchesOreDict((ItemStack)first, (ItemStack[])new ItemStack[]{this.baseItem}) && RecipeUtils.matchesOreDict((ItemStack)second, (ItemStack[])new ItemStack[]{this.first})) {
                return true;
            }
            if (RecipeUtils.matchesOreDict((ItemStack)first, (ItemStack[])new ItemStack[]{this.first}) && second == null) {
                return true;
            }
            return RecipeUtils.matchesOreDict((ItemStack)second, (ItemStack[])new ItemStack[]{this.first}) && first == null;
        }

        public boolean uses(ItemStack ingredient) {
            if (ingredient == null) {
                return false;
            }
            if (this.first != null && this.first.func_77969_a(ingredient)) {
                return true;
            }
            return this.baseItem != null && this.baseItem.func_77969_a(ingredient);
        }
    }
}

