/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.metallurgy.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.teammetallurgy.metallurgy.machines.alloyer.GUIAlloyer;
import com.teammetallurgy.metallurgy.recipes.AlloyerRecipes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class AlloyerHandler
extends TemplateRecipeHandler {
    public String getGuiTexture() {
        return "metallurgy:textures/gui/nei_alloyer.png";
    }

    public String getRecipeName() {
        return "Alloy Recipe";
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GUIAlloyer.class;
    }

    public void loadCraftingRecipes(ItemStack output) {
        ArrayList<AlloyerRecipes.AlloyRecipe> recipesFor = AlloyerRecipes.getInstance().getRecipesFor(output);
        for (AlloyerRecipes.AlloyRecipe recipe : recipesFor) {
            NEIRecipe neiRecipe = new NEIRecipe(recipe.getIngredients(), recipe.getCraftingResult(), output);
            this.arecipes.add(neiRecipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        ArrayList<AlloyerRecipes.AlloyRecipe> recipesFor = AlloyerRecipes.getInstance().getRecipesUsing(ingredient);
        for (AlloyerRecipes.AlloyRecipe recipe : recipesFor) {
            NEIRecipe neiRecipe = new NEIRecipe(recipe.getIngredients(), recipe.getCraftingResult(), ingredient);
            this.arecipes.add(neiRecipe);
        }
    }

    private class NEIRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        public PositionedStack result;

        public NEIRecipe(ItemStack[] inputs, ItemStack craftingResult, ItemStack ingredient) {
            super((TemplateRecipeHandler)AlloyerHandler.this);
            this.result = new PositionedStack((Object)craftingResult, 75, 46);
            this.ingredients = new ArrayList();
            this.setIngredients(inputs, craftingResult);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(AlloyerHandler.this.cycleticks / 20, this.ingredients);
        }

        private void setIngredients(ItemStack[] inputs, ItemStack output) {
            PositionedStack stack = new PositionedStack((Object)inputs[0], 57, 1);
            stack.setMaxSize(1);
            this.ingredients.add(stack);
            if (inputs.length > 1 && inputs[1] != null) {
                stack = new PositionedStack((Object)inputs[1], 93, 1);
                stack.setMaxSize(1);
                this.ingredients.add(stack);
            }
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

