/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.metallurgy;

import com.teammetallurgy.metallurgy.BlockList;
import com.teammetallurgy.metallurgy.ItemList;
import com.teammetallurgy.metallurgy.Utils;
import com.teammetallurgy.metallurgy.handlers.BucketsHandler;
import com.teammetallurgy.metallurgy.handlers.ConfigHandler;
import com.teammetallurgy.metallurgy.handlers.EventHandlerMetallurgy;
import com.teammetallurgy.metallurgy.handlers.GUIHandlerMetallurgy;
import com.teammetallurgy.metallurgy.integrations.Integration;
import com.teammetallurgy.metallurgy.lib.Configs;
import com.teammetallurgy.metallurgy.metals.MetalMaterials;
import com.teammetallurgy.metallurgy.metals.VanillaMetals;
import com.teammetallurgy.metallurgy.networking.CommonProxy;
import com.teammetallurgy.metallurgycore.CreativeTab;
import com.teammetallurgy.metallurgycore.handlers.LogHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.File;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Logger;

@Mod(name="Metallurgy", modid="Metallurgy", version="4.0.5", dependencies="required-after:MetallurgyCore@[4.0.4,];before:UndergroundBiomes;after:Botania;after:TConstruct")
public class Metallurgy {
    public static final String MODNAME = "Metallurgy";
    public static final String MODID = "Metallurgy";
    public static final String VERSION = "4.0.5";
    public static final String DEPS = "required-after:MetallurgyCore@[4.0.4,];before:UndergroundBiomes;after:Botania;after:TConstruct";
    @Mod.Instance(value="Metallurgy")
    public static Metallurgy instance;
    @SidedProxy(clientSide="com.teammetallurgy.metallurgy.networking.ClientProxy", serverSide="com.teammetallurgy.metallurgy.networking.CommonProxy")
    public static CommonProxy proxy;
    public CreativeTab creativeTabMachines = new CreativeTab("Metallurgy.Machines");
    public CreativeTab creativeTabBlocks = new CreativeTab("Metallurgy.Blocks");
    public CreativeTab creativeTabItems = new CreativeTab("Metallurgy.Items");
    public CreativeTab creativeTabTools = new CreativeTab("Metallurgy.Tools");
    public CreativeTab creativeTabArmor = new CreativeTab("Metallurgy.Armor");
    private File modsFolder;

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        VanillaMetals.initRecipes();
        ItemList.addRecipes();
        BlockList.initRecipies();
        MetalMaterials.Instance.addRecipes();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GUIHandlerMetallurgy());
        proxy.registerTickHandlers();
        proxy.registerBlockRenderers();
        proxy.registerEntityRenderers();
        proxy.registerFuelHandlers();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerMetallurgy());
        Integration.init(event);
    }

    private void initTabs() {
        this.creativeTabMachines.setItem(BlockList.getAlloyer());
        this.creativeTabBlocks.setItemStack(new ItemStack((Block)BlockList.tabBlock));
        this.creativeTabItems.setItemStack(new ItemStack((Item)ItemList.tabItem));
        this.creativeTabTools.setItemStack(new ItemStack((Item)ItemList.tabItem, 1, 1));
        this.creativeTabArmor.setItemStack(new ItemStack((Item)ItemList.tabItem, 1, 2));
    }

    public String modsPath() {
        try {
            return this.modsFolder.getCanonicalPath();
        }
        catch (IOException e) {
            return "";
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Utils.injectOreDictionaryRecipes();
        Integration.postinit(event);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LogHandler.setLog((Logger)event.getModLog());
        ConfigHandler.setFile(event.getSuggestedConfigurationFile());
        Object value = ObfuscationReflectionHelper.getPrivateValue(Loader.class, (Object)Loader.instance(), (String[])new String[]{"canonicalModsDir"});
        if (value instanceof File) {
            this.modsFolder = (File)value;
        }
        Configs.init();
        BlockList.init();
        ItemList.init();
        BucketsHandler.instance.init();
        this.initTabs();
        Integration.preinit(event);
    }
}

