/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.metallurgy;

import com.teammetallurgy.metallurgy.Metallurgy;
import com.teammetallurgy.metallurgy.api.IMetalSet;
import com.teammetallurgy.metallurgy.handlers.ConfigHandler;
import com.teammetallurgy.metallurgy.machines.alloyer.BlockAlloyer;
import com.teammetallurgy.metallurgy.machines.alloyer.TileEntityAlloyer;
import com.teammetallurgy.metallurgy.machines.crusher.BlockCrusher;
import com.teammetallurgy.metallurgy.machines.crusher.TileEntityCrusher;
import com.teammetallurgy.metallurgy.machines.forge.BlockForge;
import com.teammetallurgy.metallurgy.machines.forge.TileEntityForge;
import com.teammetallurgy.metallurgy.machines.frame.BlockFrame;
import com.teammetallurgy.metallurgy.metals.ItemMetalBlock;
import com.teammetallurgy.metallurgy.metals.MetalBlock;
import com.teammetallurgy.metallurgy.metals.MetalSet;
import com.teammetallurgy.metallurgy.metals.VanillaMetals;
import com.teammetallurgy.metallurgy.tnt.BlockExplosive;
import com.teammetallurgy.metallurgy.tnt.BlockExplosiveItem;
import com.teammetallurgy.metallurgy.tnt.EntityExplosive;
import com.teammetallurgy.metallurgycore.handlers.LogHandler;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class BlockList {
    private static Block machineFrame;
    private static Block crusher;
    private static Block alloyer;
    private static Block forge;
    private static MetalBlock extraSorageBlock;
    private static BlockExplosive explosive;
    public static MetalBlock tabBlock;
    private static Map<String, MetalSet> setList;
    private static String[] setNames;

    public static String[] getDefaultSetNames() {
        return setNames;
    }

    public static String[] getLoadedSetNames() {
        String[] setNames = new String[setList.size()];
        setNames = setList.keySet().toArray(setNames);
        return setNames;
    }

    public static IMetalSet getSet(String name) {
        return setList.get(name);
    }

    public static void init() {
        String blockName = "machine.frame";
        machineFrame = new BlockFrame().func_149663_c(blockName);
        BlockList.registerBlock(machineFrame, blockName);
        blockName = "crusher";
        crusher = new BlockCrusher().func_149663_c(blockName);
        BlockList.registerBlockWithTileEntity(crusher, TileEntityCrusher.class, blockName);
        blockName = "alloyer";
        alloyer = new BlockAlloyer().func_149663_c(blockName);
        BlockList.registerBlockWithTileEntity(alloyer, TileEntityAlloyer.class, blockName);
        blockName = "forge";
        forge = new BlockForge().func_149663_c(blockName);
        BlockList.registerBlockWithTileEntity(forge, TileEntityForge.class, blockName);
        BlockList.initMetalSets();
        VanillaMetals.initBlocks();
        extraSorageBlock = new MetalBlock("extra.storage.block");
        extraSorageBlock.addSubBlock(0, "charcoal", 1, "metallurgy:misc/charcoal_block");
        extraSorageBlock.setHarvestLevel("pickaxe", 0, 0);
        GameRegistry.registerBlock((Block)extraSorageBlock, ItemMetalBlock.class, (String)"extra.storage.block");
        explosive = new BlockExplosive();
        GameRegistry.registerBlock((Block)explosive, BlockExplosiveItem.class, (String)"explosive");
        EntityRegistry.registerModEntity(EntityExplosive.class, (String)"explosiveEntity", (int)0, (Object)Metallurgy.instance, (int)64, (int)10, (boolean)true);
        tabBlock = new MetalBlock("tab.block");
        tabBlock.addSubBlock(0, "tab2", 1, "metallurgy:ender/eximite_block");
        tabBlock.func_149647_a(null);
        GameRegistry.registerBlock((Block)tabBlock, ItemMetalBlock.class, (String)"tab.block");
    }

    private static void initMetalSets() {
        File directory = new File(Metallurgy.instance.modsPath());
        File[] listFiles = directory.listFiles();
        ArrayList<String> zipDirs = new ArrayList<String>();
        if (listFiles != null) {
            for (File file : listFiles) {
                if (!file.getName().contains(".zip") || !file.getName().startsWith("Metallurgy-Addon-")) continue;
                try {
                    zipDirs.add(file.getCanonicalPath());
                }
                catch (IOException e) {}
                break;
            }
        }
        for (String zipDir : zipDirs) {
            try {
                BlockList.readPackZip(zipDir);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (String set : setNames) {
            String path = "assets/metallurgy/data/";
            URL resource = Block.class.getClassLoader().getResource(path + (String)set + ".json");
            boolean enabledSet = ConfigHandler.setEnabled(set);
            try {
                if (resource != null && enabledSet) {
                    BlockList.injectMetalSet(set, resource.openStream());
                    continue;
                }
                LogHandler.log((String)("Could not load '" + path + "'"));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public static void initRecipies() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(machineFrame), new Object[]{"ici", "cic", "ici", Character.valueOf('c'), "ingotCopper", Character.valueOf('i'), Items.field_151042_j}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(crusher), new Object[]{"ccc", "imi", "ifi", Character.valueOf('c'), "ingotCopper", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('m'), new ItemStack(machineFrame), Character.valueOf('f'), Blocks.field_150460_al}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(alloyer), new Object[]{"aaa", "dmd", "dfd", Character.valueOf('a'), "ingotAngmallen", Character.valueOf('d'), "ingotDamascusSteel", Character.valueOf('m'), new ItemStack(machineFrame), Character.valueOf('f'), Blocks.field_150460_al}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(forge), new Object[]{"iii", "sms", "sfs", Character.valueOf('i'), "ingotIgnatius", Character.valueOf('s'), "ingotShadowSteel", Character.valueOf('m'), new ItemStack(machineFrame), Character.valueOf('f'), Blocks.field_150460_al}));
        ItemStack charcoalBlock = new ItemStack((Block)extraSorageBlock, 1, 0);
        ItemStack charcoalStack = new ItemStack(Items.field_151044_h, 1, 1);
        ItemStack charcoalResult = new ItemStack(Items.field_151044_h, 9, 1);
        GameRegistry.addRecipe((ItemStack)charcoalBlock.func_77946_l(), (Object[])new Object[]{"ccc", "ccc", "ccc", Character.valueOf('c'), charcoalStack});
        GameRegistry.addShapelessRecipe((ItemStack)charcoalResult, (Object[])new Object[]{charcoalBlock.func_77946_l()});
        OreDictionary.registerOre((String)"blockCharcoal", (ItemStack)charcoalBlock.func_77946_l());
    }

    private static void injectMetalSet(String name, InputStream stream) throws IOException {
        MetalSet metalSet = new MetalSet(name);
        metalSet.load(stream);
        setList.put(name, metalSet);
    }

    private static void readPackZip(String zipDir) throws IOException {
        ZipFile zipFile = new ZipFile(zipDir);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry nextElement = entries.nextElement();
            String name = nextElement.getName();
            if (nextElement.isDirectory() || !name.contains(".json")) continue;
            Metallurgy.proxy.injectZipAsResource(zipDir);
            InputStream stream = zipFile.getInputStream(nextElement);
            BlockList.injectMetalSet(name.substring(name.lastIndexOf("/") + 1, name.lastIndexOf(".")), stream);
        }
        zipFile.close();
    }

    private static void registerBlock(Block block, String name) {
        GameRegistry.registerBlock((Block)block, (String)name);
    }

    private static void registerBlockWithTileEntity(Block block, Class<? extends TileEntity> teClass, String blockName) {
        BlockList.registerBlock(block, blockName);
        BlockList.registerTileEntity(teClass, blockName);
    }

    private static void registerTileEntity(Class<? extends TileEntity> clazz, String blockName) {
        GameRegistry.registerTileEntity(clazz, (String)("Metallurgy:" + blockName));
    }

    public static Block getAlloyer() {
        return alloyer;
    }

    public static Block getMachineFrame() {
        return machineFrame;
    }

    public static Block getCrusher() {
        return crusher;
    }

    public static Block getForge() {
        return forge;
    }

    public static Block getExtraStorageBlock() {
        return extraSorageBlock;
    }

    public static Block getExplosive() {
        return explosive;
    }

    static {
        setList = new HashMap<String, MetalSet>();
        setNames = new String[]{"base", "ender", "fantasy", "nether", "precious", "utility"};
    }
}

